/**
 * 
 */
package org.blueforest.rockhouse.encoding_converter.popup.actions;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

import org.blueforest.rockhouse.encoding_converter.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;

/**
 * @author akira saito
 *
 */
public class ConvertEncodingAction extends ConvertAction {

	/**
	 * 
	 */
	public ConvertEncodingAction() {
		// TODO Auto-generated constructor stub
	}
	
	@Override
	protected boolean convert(IAction action, IFile file) throws CoreException {
		try {
			String fromCharsetName = file.getCharset();
			String toCharsetName = null;
			Charset charset = this.actionIdToCharset(action);
			if (charset == null) {
				toCharsetName = file.getProject().getDefaultCharset();
			} else {
				toCharsetName = charset.name();
			}
			this.printConsole(fromCharsetName + "->" + toCharsetName + " ");

			if (fromCharsetName.equals(toCharsetName)) {
				this.printConsole("skipped. charset is equals.");
				return false;
			}
			
			Reader is = new InputStreamReader(file.getContents(), fromCharsetName);
			
			CharArrayWriter os = new CharArrayWriter();
			do {
				int c = is.read();
				if (c == -1) break;
				os.write(c);
			} while (true);
			is.close();
			
			InputStream convertedInStream = new ByteArrayInputStream(os.toString().getBytes(toCharsetName));
			file.setContents(convertedInStream, 0, null);
			file.setCharset((charset==null)?null:toCharsetName, null);
			return true;
			
		} catch (IOException e) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, "", e);
			throw new CoreException(status);
		}
	}
	
	private Charset actionIdToCharset(IAction action) {
		String id = action.getId();
		if (id.contains(".to_utf-8")) {
			return Charset.forName("UTF-8");
		} else if (id.contains(".to_project_default")) {
			return null;
		} else {
			throw new IllegalArgumentException("unknown action id. id=" + action.getId());
		}
	}
}
