package org.blueforest.rockhouse.encoding_converter.popup.actions;

import java.io.IOException;
import java.util.Iterator;

import org.blueforest.rockhouse.encoding_converter.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConvertAction implements IObjectActionDelegate {

	private Shell shell;
	private ISelection selection = null;
	private MessageConsoleStream consoleCache = null;
	private static String CONSOLE_ID = "Encoding Converter";
	
	/**
	 * Constructor for Action1.
	 */
	public ConvertAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		shell = targetPart.getSite().getShell();
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		try {
			if (selection == null || selection.isEmpty()) return;
	
			if (!(selection instanceof IStructuredSelection)) {
				return;
			}

			IStructuredSelection structuredSelection = (IStructuredSelection)selection;
			for (@SuppressWarnings("rawtypes")
			Iterator it = (Iterator)structuredSelection.iterator(); it.hasNext();) {
				Object selection = it.next();

				if (!(selection instanceof IFile)) {
					continue;
				}
				
				IFile file = (IFile)selection;
				this.printConsole(file.getFullPath().toPortableString() + ": ");

				if (!checkFile(file)) {
					this.printConsole("\n");
					continue;
				}

				if (!convert(action, file)) {
					this.printConsole("\n");
					continue;
				}

				this.printConsole("success.\n");
			}

		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	protected boolean checkFile(IFile file) throws CoreException {
		if (!file.isAccessible()) {
			this.printConsole("skipped. this file is not accessible file.");
			return false;
		}

		if (file.isPhantom()) {
			this.printConsole("skipped. this file is phantom file.");
			return false;
		}

		if (file.isReadOnly()) {
			this.printConsole("skipped. this file is read-only file.");
			return false;
		}

		if (!file.isSynchronized(0)) {
			this.printConsole("skipped. this file is not synchronized.");
			return false;
		}
		
		return true;
	}

	protected boolean convert(IAction action, IFile file) throws CoreException {
		return false;
	}
	
	protected void printConsole(String message) throws CoreException {
		if (this.consoleCache == null) {
			this.consoleCache = getConsoleWriter();
		}
		this.consoleCache.print(message);
		try {
			this.consoleCache.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	private MessageConsoleStream getConsoleWriter() throws CoreException {
		MessageConsole console = this.findConsole();
		IConsoleView view = (IConsoleView) Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(IConsoleConstants.ID_CONSOLE_VIEW);
		view.display(console);
		return console.newMessageStream();
	}
	
	private MessageConsole findConsole() {
		IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
		for (IConsole console : manager.getConsoles()) {
			if (console.getName().equals(CONSOLE_ID))
				return (MessageConsole)console;
		}
		
		MessageConsole console = new MessageConsole(CONSOLE_ID, null);
		manager.addConsoles(new IConsole[]{console});
		return console;
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

}
