
/*
** in_!mpg123 - MP3 decoder (mpg123) for WINAMP5
**
** Written by Naoki Shibata
** http://shibatch.sourceforge.net/
**
** 2006/10/26 Modified by Otachan
** http://otachan.com/
*/

#define	STRICT

#include "stdafx.h"
#include <process.h>
#include <MMSystem.h>

#define	UNICODE_INPUT_PLUGIN

#include "IN2.H"
#include "wa_ipc.h"

#include "mpglib/mpg123.h"
#include "mpglib/mpglib.h"

#include "CommonFunc.h"

#include "in_mpg123.h"

// begin pl2 by YunaSoft
#include "AsyncSocket.h"
#include "HttpFile.h"
#include "ICYInfo.h"
// end pl2

// begin pl3 by YunaSoft
#include "Param.h"
#include "ConfigDialog.h"
#include "ReplayGainDialog.h"
#include "FormattingDialog.h"
#include "StreamingDialog.h"
#include "PropertySheet.h"
// end pl3

// added by Otachan
#include "FileSys.h"
#include "AdrTime.h"
#include "TagInfo.h"
#include "VbrTag.h"
#include "Bitrate.h"
#include "mp3infp_ExportFunc.h"
//

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CIn_mpg123App, CWinApp)
	//{{AFX_MSG_MAP(CIn_mpg123App)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
		//        ̈ʒuɐR[hҏWȂłB
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CIn_mpg123App::CIn_mpg123App(void)
{
	// TODO: ̈ʒuɍ\zp̃R[hǉĂB
	//  InitInstance ̒̏dvȏׂċLqĂB
}

CIn_mpg123App	theApp;

// avoid CRT. Evil. Big. Bloated.
/*
BOOL WINAPI _DllMainCRTStartup(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}
*/

void __cdecl	config(HWND);
void __cdecl	about(HWND);
void __cdecl	init(void);
void __cdecl	quit(void);
void __cdecl	getfileinfo(const in_char* filename, in_char* title, int* length_in_ms);
int __cdecl	infobox(const in_char* fn, HWND hwnd);
int __cdecl	isourfile(const in_char* fn);
int __cdecl	play(const in_char* fn);
void __cdecl	pause(void);
void __cdecl	unpause(void);
int __cdecl	ispaused(void);
void __cdecl	stop(void);
int __cdecl	getlength(void);
int __cdecl	getoutputtime(void);
void __cdecl	setoutputtime(int time_in_ms);
void __cdecl	setvolume(int volume);
void __cdecl	setpan(int pan);
void __cdecl	eq_set(int on, char data[10], int preamp);

In_Module	mod =
{
	IN_VER,
	"Shibatch mpg123 " _VER,
	NULL,	// hMainWindow
	NULL,	// hDllInstance
	FILE_EXT,
	1,		// is_seekable
	1,		// uses output
	config,
	about,
	init,
	quit,
	getfileinfo,
	infobox,
	isourfile,
	play,
	pause,
	unpause,
	ispaused,
	stop,
	getlength,
	getoutputtime,
	setoutputtime,
	setvolume,
	setpan,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL,
	eq_set,
	NULL,
	NULL
};

UINT __cdecl	PrePlayThreadProc(LPVOID /*Param*/);
unsigned int	__stdcall DecodeThread(LPVOID pParam);
UINT __cdecl	ReceiveThread(LPVOID pParam);

bool	DecoderInUse(void);
void	RunningPlayFunc(bool Running);
void	SetTitleInfoMsg(const WCHAR* Str, const WCHAR* Str2 = NULL);
void	UpdateWinampDisplay(void);
inline void	CreatePlay2ndWindow(void);
inline bool	Play2nd(void);
inline bool	Open(void);
inline bool	OpenStream(void);
// begin pl2 by YunaSoft
bool	ConnectAsyncSocket(CString strAddress, UINT nPort);
UINT	CreateAsyncSocket(UINT nPort, UINT count);
void	ReceiveUDPMsg(const WCHAR* src);
bool	preload_stream(int Size);
bool	read_stream_index(void* RetBuff, int ReadIdx, int Size);
int		read_stream_buffer(void* RetBuff, int Size);
// end pl2
// begin pl3 by YunaSoft
void	DeleteAsyncSocket(void);
UINT	ReadStream(char* buf, UINT nCount);
void	reflect_setting(void);
// end pl3

CRITICAL_SECTION	CriticalSection;

HWND	hPlay2ndWindow = NULL;

HANDLE	m_OpenOutModule;
HANDLE	m_RunningPlayFunc;
HANDLE	m_RunningPrePlayThread;
HANDLE	m_KillPrePlayThread;

THREADPARAM*	pReceive = NULL;
THREADPARAM*	pDecode = NULL;

FileSys*	input_file = NULL;
mp3info	m_mp3info;
CAdrTime	m_adrTime;
Bitrate*	m_Bitrate = NULL;
Tag		m_Tag;

CIn_mpg123dSession*	session = NULL;
CHttpConnection*	connection = NULL;
CIn_mpg123dHttpFile*	httpfile = NULL;
CIn_mpg123dAsyncSocket*	m_pAsyncSocket = NULL;
CIn_mpg123dParam*	prm;

DWORD	m_TitleInfoMsg_ID = 0;
DWORD	m_TitleInfoMsg_GetFileInfo_ID = 0;
HANDLE	m_EventTitleInfoMsg;
CString	m_TitleInfoMsg;
CString	m_StreamErrorMsg;

HMODULE	hMp3infpDll = NULL;
LPMP3INFP_VIEWPROPEX	lpfnMp3infpViewPropEx;

//int		WinampVersion;
WCHAR	lastfn[MAX_PATHLEN];	// currently playing file (used for getting info on the current file)
bool	m_paused;				// are we paused?
volatile int	m_seek_needed;	// if != -1, it is the point that the decode thread should seek to, in ms.
int		m_Format;
bool	m_prefetch_head;
unsigned int	m_head;
unsigned char	m_obuff[OBSIZE];
int		m_bend;
int		m_sample_buffer_16_bend;
int		m_out_ssize;
int		m_vis_ssize;
int		m_ssize;
int		m_decoder_stat;
int		m_decode_pos_samples;
double	m_decode_pos_ms;		// current decoding position, in milliseconds
double	m_vis_pos_ms;			// current vis position, in milliseconds
int		m_skip_start_remain;
int		m_lastBitrate;
OUT_DATA_FUNC	m_OutDataFunc;
VIS_DATA_FUNC	m_VisDataFunc;
char	sample_buffer[576 * (64 >> 3) * 2 * 2];				// sample buffer (64bits * 2ch * 2)
char	sample_buffer_16[576 * (16 >> 3) * 2 * (2 + 1)];	// sample buffer (16bits * 2ch * (2 + 1))

enum
{
	READ_STREAM_MODE_MIN,
	READ_STREAM_MODE_MAX,
};

HANDLE	stream_hF;
char*	stream_buffer = NULL;
volatile bool	strbuf_eof;
volatile bool	read_stream_mode;
volatile int	read_stream_size;
volatile int	strbufp_s;
volatile int	strbufp_e;
volatile int	strbuflen;

extern "C"
{
	__declspec(dllexport) In_Module* __cdecl
	winampGetInModule2(void)
	{
		return &mod;
	}

	__declspec(dllexport) int __cdecl
	winampGetExtendedFileInfoW(extendedFileInfoStructW ExtendedFileInfo)
	{
		return m_Tag.GetExtendedFileInfo(&ExtendedFileInfo, prm->m_nTagPriority, prm->m_nReplayGainTag);
	}
}

LRESULT CALLBACK
Play2ndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return (uMsg == WM_USER) ? Play2nd() : ::DefWindowProc(hwnd, uMsg, wParam, lParam);
}

inline bool
head_check(unsigned int head)
{
	if((head & 0xffe00000) != 0xffe00000) return false;
	if(((head >> 17) & 3) == 0) return false;
//	if((4 - ((head >> 17) & 3)) != 3) return false;
	if(((head >> 10) & 0x3) == 0x3) return false;

	const int	bitrate = (head >> 12) & 0xf;

	if((bitrate == 0x0) || (bitrate == 0xf)) return false;

	return true;
}

inline bool
head_check2(unsigned int head, mp3info* info)
{
	if((head & 0xffe00000) != 0xffe00000) return false;

	const int	lay = (head >> 17) & 3;

	if(lay == 0) return false;
//	if((4 - ((head >> 17) & 3)) != 3) return false;

	const int	freq = (head >> 10) & 0x3;

	if(freq == 0x3) return false;

	const int	bitrate = (head >> 12) & 0xf;

	if((bitrate == 0x0) || (bitrate == 0xf)) return false;

	bool	mpeg25;
	int		lsf;

	if(head & (1 << 20)) {
		mpeg25 = false;
		lsf = (head & (1 << 19)) ? 0 : 1;
	} else {
		mpeg25 = true;
		lsf = 1;
	}

	if(mpeg25 != info->mpeg25) return false;
	if(lsf != info->lsf) return false;
	if((4 - lay) != info->lay) return false;
	if(freqs[freq + (mpeg25 ? 6 : lsf * 3)] != info->freq) return false;
	if(((((head >> 6) & 0x3) == MPG_MD_MONO) ? 1 : 2) != info->nch) return false;

	return true;
}

bool
getmp3info(bool Decode, const WCHAR* fn, mp3info* info, VBRTAGDATA* vbr_tag)
{
	HANDLE	input_file = ::CreateFile(
									fn,
									GENERIC_READ,
									FILE_SHARE_READ,
									NULL,
									OPEN_EXISTING,
									FILE_FLAG_RANDOM_ACCESS,
									NULL);

	if(input_file == INVALID_HANDLE_VALUE) {
		// error opening file

		return false;
	}

	info->nbytes = ::GetFileSize(input_file, NULL);

	bool	Riff = false;
	DWORD	ReadByte;
	int		hpos;

	if(info->nbytes >= 4) {
		unsigned char	Tag[10];

		::ReadFile(input_file, Tag, 4, &ReadByte, NULL);

		if((*Tag == 'I') && (*(Tag + 1) == 'D') && (*(Tag + 2) == '3')) {
			// skip ID3v2 tag

			if(info->nbytes < 10) {
				::CloseHandle(input_file);
				return false;
			}

			::ReadFile(input_file, Tag + 4, 6, &ReadByte, NULL);

			hpos =	10 +
					(*(Tag + 6) << 21) +
					(*(Tag + 7) << 14) +
					(*(Tag + 8) << 7) +
					*(Tag + 9) +
					((*(Tag + 5) & 0x10) ? 10 : 0);
		} else if((*Tag == 'R') && (*(Tag + 1) == 'I') && (*(Tag + 2) == 'F') && (*(Tag + 3) == 'F')) {
			// skip RIFF chunk

			hpos = 0;

			MMIOINFO	mmioinfo;

			memset(&mmioinfo, 0, sizeof mmioinfo);
			mmioinfo.adwInfo[0] = reinterpret_cast<DWORD>(input_file);

			HMMIO	hmmio = ::mmioOpen(NULL, &mmioinfo, MMIO_READ);

			if(hmmio) {
				for(int Idx = 0; Idx < 2; Idx++) {
					MMCKINFO	mmckinfoParent;

					switch(Idx) {
					case 0:
						mmckinfoParent.fccType = mmioFOURCC('R', 'M', 'P', '3');
						break;
					case 1:
						mmckinfoParent.fccType = mmioFOURCC('W', 'A', 'V', 'E');
						break;
					}

					::mmioSeek(hmmio, 0, SEEK_SET);

					if(::mmioDescend(hmmio, &mmckinfoParent, NULL, MMIO_FINDRIFF) == 0) {
						MMCKINFO	mmckinfoSubchunk;

						mmckinfoSubchunk.ckid = mmioFOURCC('d', 'a', 't', 'a');
						if(::mmioDescend(hmmio, &mmckinfoSubchunk, &mmckinfoParent,
															MMIO_FINDCHUNK) == 0) {
							hpos = mmckinfoSubchunk.dwDataOffset;
							info->nbytes = mmckinfoSubchunk.cksize;
							Riff = true;
						}
						break;
					}
				}

				::mmioClose(hmmio, MMIO_FHOPEN);
			}
		} else {
			hpos = 0;
		}
	} else {
		hpos = 0;
	}

	::SetFilePointer(input_file, hpos, NULL, FILE_BEGIN);

	bool	FindHeader = false;

	for(int Idx = 0; Idx < MAX_SEARCH_HEADER; Idx++) {
		unsigned int	read_head;

		if(Idx == 0) {
			::ReadFile(input_file, &read_head, 4, &ReadByte, NULL);

			if(ReadByte < 4) break;
		} else {
			unsigned char	head1byte;

			::ReadFile(input_file, &head1byte, 1, &ReadByte, NULL);

			if(ReadByte < 1) break;

			read_head >>= 8;
			*(reinterpret_cast<unsigned char*>(&read_head) + 3) = head1byte;
		}

		unsigned int	head;

		if(head_check(head = BSwap32(read_head))) {
			if(head & (1 << 20)) {
				info->mpeg25 = false;
				info->lsf = (head & (1 << 19)) ? 0 : 1;
			} else {
				info->mpeg25 = true;
				info->lsf = 1;
			}

			const int	bitrate = (head >> 12) & 0xf;
			const int	padding = (head >> 9) & 0x1;

			info->lay = 4 - ((head >> 17) & 3);
			info->freq = freqs[((head >> 10) & 0x3) + (info->mpeg25 ? 6 : info->lsf * 3)];
			info->mode = (head >> 6) & 0x3;
			info->nch = (info->mode == MPG_MD_MONO) ? 1 : 2;
			info->bitrate = tabsel_123[info->lsf][info->lay - 1][bitrate] * 1000;

			int		framesize;

			switch(info->lay) {
			case 3:
				framesize = info->bitrate * 144 / (info->freq << info->lsf) + padding;
				break;
			case 2:
				framesize = info->bitrate * 144 / info->freq + padding;
				break;
			case 1:
				framesize = (info->bitrate * 12 / info->freq + padding) * 4;
				break;
			}

			::SetFilePointer(input_file, framesize - 4, NULL, FILE_CURRENT);

			unsigned int	next_read_head;

			::ReadFile(input_file, &next_read_head, 4, &ReadByte, NULL);

			if(ReadByte < 4) break;

			if(head_check2(BSwap32(next_read_head), info)) {
				if(Decode) {
					m_head = read_head;
					m_prefetch_head = true;
				}

				hpos += Idx;

				FindHeader = true;
				break;
			}

			::SetFilePointer(input_file, -framesize, NULL, FILE_CURRENT);
		}
	}

	if(FindHeader == false) {
		::CloseHandle(input_file);
		return false;
	}

	info->hpos = hpos;

	if(Riff == false) {
		info->nbytes -= hpos;

		bool	FindID3v2TagFooter;

		if(info->nbytes >= 10) {
			unsigned char	Tag[10];

			::SetFilePointer(input_file, -10, NULL, FILE_END);
			::ReadFile(input_file, Tag, 4, &ReadByte, NULL);

			if((*Tag == '3') && (*(Tag + 1) == 'D') && (*(Tag + 2) == 'I') &&  (*(Tag + 3) >= 4)) {
				::ReadFile(input_file, Tag + 4, 6, &ReadByte, NULL);

				const int	ID3v2_TagAllSize =	10 +
												(*(Tag + 6) << 21) +
												(*(Tag + 7) << 14) +
												(*(Tag + 8) << 7) +
												*(Tag + 9) +
												10;

				if(info->nbytes < ID3v2_TagAllSize) {
					::CloseHandle(input_file);
					return false;
				}

				info->nbytes -= ID3v2_TagAllSize;

				FindID3v2TagFooter = true;
			} else {
				FindID3v2TagFooter = false;
			}
		} else {
			FindID3v2TagFooter = false;
		}

		bool	FindAPETag;

		if((FindID3v2TagFooter == false) && (info->nbytes >= sizeof(APE_TAG_FOOTER))) {
			APE_TAG_FOOTER	APETagFooter;

			::SetFilePointer(input_file, -static_cast<LONG>(sizeof APETagFooter), NULL, FILE_END);
			::ReadFile(input_file, &APETagFooter, sizeof APETagFooter, &ReadByte, NULL);

			if(memcmp(APETagFooter.m_cID, "APETAGEX", 8) == 0) {
				const int	APE_TagAllSize =
								((APETagFooter.m_nFlags & APE_TAG_FLAG_CONTAINS_HEADER) ?
									sizeof APETagFooter :
									0) +
								APETagFooter.m_nSize;

				if(info->nbytes < APE_TagAllSize) {
					::CloseHandle(input_file);
					return false;
				}

				info->nbytes -= APE_TagAllSize;

				FindAPETag = true;
			} else {
				const int	APE_ID3_TagSize = sizeof(id3tag) + sizeof(APE_TAG_FOOTER);

				if(info->nbytes >= APE_ID3_TagSize) {
					::SetFilePointer(input_file, -APE_ID3_TagSize, NULL, FILE_END);
					::ReadFile(input_file, &APETagFooter, sizeof APETagFooter, &ReadByte, NULL);

					if(memcmp(APETagFooter.m_cID, "APETAGEX", 8) == 0) {
						const int	APE_ID3_TagAllSize =
										((APETagFooter.m_nFlags & APE_TAG_FLAG_CONTAINS_HEADER) ?
											sizeof APETagFooter :
											0) +
										APETagFooter.m_nSize +
										sizeof(id3tag);

						if(info->nbytes < APE_ID3_TagAllSize) {
							::CloseHandle(input_file);
							return false;
						}

						info->nbytes -= APE_ID3_TagAllSize;

						FindAPETag = true;
					} else {
						FindAPETag = false;
					}
				} else {
					FindAPETag = false;
				}
			}
		} else {
			FindAPETag = false;
		}

		if((FindID3v2TagFooter == false) && (FindAPETag == false)) {
			if(info->nbytes >= sizeof(id3tag)) {
				id3tag	ID3Tag;

				::SetFilePointer(input_file, -static_cast<LONG>(sizeof ID3Tag), NULL, FILE_END);
				::ReadFile(input_file, &ID3Tag, sizeof ID3Tag, &ReadByte, NULL);

				if(memcmp(ID3Tag.tag, "TAG", 3) == 0) info->nbytes -= sizeof ID3Tag;
			}
		}
	}
	// end pl3

	info->hnbytes = hpos + info->nbytes;

//	info->stream = false;

	switch(info->lay) {
	case 3:
		info->frame_samples = 576 * (info->lsf ? 1 : 2 );
		info->decode_delay = DECODE_DELAY_LAYER3;
		break;
	case 2:
		info->frame_samples = 1152;
		info->decode_delay = DECODE_DELAY_LAYER2;
		break;
	case 1:
		info->frame_samples = 384;
		info->decode_delay = DECODE_DELAY_LAYER1;
		break;
	}

	// read VBR tag

	unsigned char	buf[XING_HEADER_SIZE];

	::SetFilePointer(input_file, hpos, NULL, FILE_BEGIN);
	::ReadFile(input_file, buf, XING_HEADER_SIZE, &ReadByte, NULL);

	::CloseHandle(input_file);

	if((ReadByte == XING_HEADER_SIZE) && GetVbrTag(vbr_tag, buf) && (vbr_tag->frames != -1)) {
		info->vbr_tag = true;
		info->frames = vbr_tag->frames;
		info->samples = info->frames * info->frame_samples;
		if(vbr_tag->bytes != -1) info->nbytes = vbr_tag->bytes;
		info->bitrate = ::MulDiv(info->nbytes << 3, info->freq, info->samples);
		info->skip_start = (vbr_tag->enc_delay == -1) ? 0 : vbr_tag->enc_delay;
		info->samples -= (info->skip_start +
							((vbr_tag->enc_padding == -1) ? 0 : vbr_tag->enc_padding));
		info->length = ::MulDiv(info->samples, 1000, info->freq);
		info->skip_start += ((vbr_tag->enc_delay == -1) ? 0 : POST_DELAY);
		info->skip_start_ms = info->skip_start * 1000. / info->freq;
		info->skip_start += info->decode_delay;
		info->replaygain_valid_track_gain = vbr_tag->ValidRadioReplayGain;
		info->replaygain_valid_track_peak = vbr_tag->ValidPeakSignalAmplitude;
		info->replaygain_valid_album_gain = vbr_tag->ValidAudioPhileReplayGain;
		info->replaygain_valid_album_peak = false;
		info->replaygain_track_gain = vbr_tag->RadioReplayGain;
		info->replaygain_track_peak = vbr_tag->PeakSignalAmplitude;
		info->replaygain_album_gain = vbr_tag->AudioPhileReplayGain;
	} else {
		info->vbr_tag = false;
		info->length = ::MulDiv(info->nbytes, 1000 << 3, info->bitrate);
		info->samples = ::MulDiv(info->length, info->freq, 1000);
		info->frames = info->samples / info->frame_samples;
		info->skip_start = info->decode_delay;
		info->skip_start_ms = 0.;
		info->replaygain_valid_track_gain = false;
		info->replaygain_valid_track_peak = false;
		info->replaygain_valid_album_gain = false;
		info->replaygain_valid_album_peak = false;
	}

	return true;
}

// for streaming
inline bool
getmp3info_stream(mp3info* info)
{
	bool	FindHeader = false;

	for(int Idx = 0; Idx < MAX_SEARCH_HEADER; Idx++) {
		unsigned int	read_head;

		if(read_stream_index(&read_head, Idx, 4) == false) break;

		unsigned int	head;

		if(head_check(head = BSwap32(read_head))) {
			if(head & (1 << 20)) {
				info->mpeg25 = false;
				info->lsf = (head & (1 << 19)) ? 0 : 1;
			} else {
				info->mpeg25 = true;
				info->lsf = 1;
			}

			const int	bitrate = (head >> 12) & 0xf;
			const int	padding = (head >> 9) & 0x1;

			info->lay = 4 - ((head >> 17) & 3);
			info->freq = freqs[((head >> 10) & 0x3) + (info->mpeg25 ? 6 : info->lsf * 3)];
			info->mode = (head >> 6) & 0x3;
			info->nch = (info->mode == MPG_MD_MONO) ? 1 : 2;
			info->bitrate = tabsel_123[info->lsf][info->lay - 1][bitrate] * 1000;

			int		framesize;

			switch(info->lay) {
			case 3:
				framesize = info->bitrate * 144 / (info->freq << info->lsf) + padding;
				break;
			case 2:
				framesize = info->bitrate * 144 / info->freq + padding;
				break;
			case 1:
				framesize = (info->bitrate * 12 / info->freq + padding) * 4;
				break;
			}

			if(read_stream_index(&read_head, Idx + framesize, 4) == false) break;

			if(head_check2(BSwap32(read_head), info)) {
				::EnterCriticalSection(&CriticalSection);

				strbufp_s += Idx;
				if(strbufp_s >= strbuflen) strbufp_s -= strbuflen;
				strbufp_e -= Idx;

				::LeaveCriticalSection(&CriticalSection);

				FindHeader = true;
				break;
			}
		}
	}

	if(FindHeader == false) return false;

//	info->stream = true;
	info->vbr_tag = false;
	info->hpos = 0;
	info->nbytes = 0;
	info->hnbytes = 0;

	switch(info->lay) {
	case 3:
		info->frame_samples = 576 * (info->lsf ? 1 : 2 );
		info->decode_delay = DECODE_DELAY_LAYER3;
		break;
	case 2:
		info->frame_samples = 1152;
		info->decode_delay = DECODE_DELAY_LAYER2;
		break;
	case 1:
		info->frame_samples = 384;
		info->decode_delay = DECODE_DELAY_LAYER1;
		break;
	}

	info->length = 0;
	info->skip_start = info->decode_delay;
//	info->replaygain_valid_track_gain = false;
//	info->replaygain_valid_track_peak = false;
//	info->replaygain_valid_album_gain = false;
//	info->replaygain_valid_album_peak = false;

	return true;
}

bool
DecoderInUse(void)
{
	return pDecode ? (::WaitForSingleObject(pDecode->Thread, 0) != WAIT_OBJECT_0) : false;
}

void
RunningPlayFunc(bool Running)
{
	if((::WaitForSingleObject(m_RunningPlayFunc, 0) == WAIT_OBJECT_0) != Running) {
		if(Running) {
			::SetEvent(m_RunningPlayFunc);

			m_TitleInfoMsg_ID = 0;
			m_TitleInfoMsg_GetFileInfo_ID = 0;

			m_TitleInfoMsg = "";
		} else {
			::ResetEvent(m_RunningPlayFunc);
		}
	}
}

void
SetTitleInfoMsg(const WCHAR* Str, const WCHAR* Str2)
{
	if(::WaitForSingleObject(m_RunningPlayFunc, 0) == WAIT_OBJECT_0) {
		if(*Str) {
			m_TitleInfoMsg = L"[";
			m_TitleInfoMsg += Str;
			m_TitleInfoMsg += L"]";

			if(Str2) {
				m_TitleInfoMsg += L" ";
				m_TitleInfoMsg += Str2;
			}
		} else {
			m_TitleInfoMsg = L"";
		}

		m_TitleInfoMsg_ID++;

		::SendMessage(mod.hMainWindow, WM_WA_IPC, 0, IPC_UPDTITLE);
		::WaitForSingleObject(m_EventTitleInfoMsg, 500);
	}
}

void
UpdateWinampDisplay(void)
{
	if(DecoderInUse()) ::PostMessage(mod.hMainWindow, WM_WA_IPC, 0, IPC_UPDTITLE);
}

// begin pl3 by YunaSoft
void
reflect_thread_setting(void)
{
	// Xbh
	if(pDecode) {
//		pDecode->mt->SetThreadPriority(prm->GetPriorityValue(prm->m_nDecodeThreadPriority));

		::SetThreadPriority(pDecode->Thread, prm->GetPriorityValue(prm->m_nDecodeThreadPriority));
	}

	if(pReceive) {
		pReceive->mt->SetThreadPriority(prm->GetPriorityValue(prm->m_nReceiveThreadPriority));
	}

	/*
	if(httpfile) {
		SetThreadPriority(httpfile->pParam->hThread,
			prm->GetPriorityValue(prm->m_nDecodeThreadPriority));
	}
	*/
}
// end pl3

void
reflect_setting(void)
{
	// begin pl3 by YunaSoft
	mod.FileExtensions = prm->m_bEnable ? FILE_EXT : "\0";

	if(prm->m_bDispAvg && DecoderInUse()) {
		mod.SetInfo(m_lastBitrate = m_mp3info.bitrate / 1000, -1, -1, -1);
	}
	// end pl3
}

// begin pl3 by YunaSoft
/*
void config_getinifn(In_Module *this_mod, char *ini_file)
{	// makes a .ini file in the winamp directory named "plugin.ini"
	char *p;
	GetModuleFileName(this_mod->hDllInstance,ini_file,MAX_PATH);
	p=ini_file+strlen(ini_file);
	while (p >= ini_file && *p != '\\') p--;
	if (++p >= ini_file) *p = 0;
	strcat(ini_file,"plugin.ini");
}
*/
// end pl3

void __cdecl
init(void)
{
	::InitializeCriticalSection(&CriticalSection);

//	WinampVersion = ::SendMessage(mod.hMainWindow, WM_WA_IPC, 0, IPC_GETVERSION);

	mod.UsesOutputPlug |= 0x08;

	m_OpenOutModule = ::CreateEvent(NULL, true, false, NULL);
	m_RunningPlayFunc = ::CreateEvent(NULL, true, false, NULL);
	m_RunningPrePlayThread = ::CreateEvent(NULL, true, false, NULL);
	m_KillPrePlayThread = ::CreateEvent(NULL, true, false, NULL);
	m_EventTitleInfoMsg = ::CreateEvent(NULL, false, false, NULL);

	// begin pl3 by YunaSoft
	// makes Parameter Class
	prm = new CIn_mpg123dParam();
	// get profiles
	prm->GetIniFn(mod.hDllInstance);
	prm->GetProfile();
	reflect_setting();
	// end pl3

//	HINSTANCE hDllInstance;
//	In_Module* (*_winampGetInModule2)(void);
}

void __cdecl
quit(void)
{
	if(hMp3infpDll) ::FreeLibrary(hMp3infpDll);

	if(hPlay2ndWindow) {
		::DestroyWindow(hPlay2ndWindow);
		::UnregisterClass(PLAY2ND_CLASS, mod.hDllInstance);
	}

	// begin pl3 by YunaSoft
	delete prm;
	// end pl3

	::CloseHandle(m_OpenOutModule);
	::CloseHandle(m_RunningPlayFunc);
	::CloseHandle(m_RunningPrePlayThread);
	::CloseHandle(m_KillPrePlayThread);
	::CloseHandle(m_EventTitleInfoMsg);

	::DeleteCriticalSection(&CriticalSection);
}

//

void __cdecl
config(HWND hwndParent)
{
	// begin pl3 by YunaSoft
	CString str;
	str.LoadString(IDS_CONFIGDLG);

	CIn_mpg123dPropertySheet*	prop = new CIn_mpg123dPropertySheet(str, NULL, 0);
//	prop->m_psh.dwFlags |= PSH_USEHICON;
//	prop->m_psh.hIcon = AfxGetApp()->LoadIcon(IDI_SMALLICON);
	prop->m_psh.nStartPage = prm->m_nStartPage;

	prop->pParam = prm;

	CConfigDialog dlg1;
	dlg1.pr = prm;
	dlg1.SetParam();

	CReplayGainDialog dlg2;
	dlg2.pr = prm;
	dlg2.SetParam();

	CStreamingDialog dlg3;
	dlg3.pr = prm;
	dlg3.SetParam();

	CFormattingDialog dlg4;
	dlg4.pr = prm;
	dlg4.SetParam();

	prop->AddPage(&dlg1);
	prop->AddPage(&dlg2);
	prop->AddPage(&dlg3);
	prop->AddPage(&dlg4);

	prop->DoModal();

	delete prop;
	// end pl3
}

void __cdecl
about(HWND hwndParent)
{
	::MessageBox(
			hwndParent,
			L"mpg123 " VER L"\n\n"
				L"by Shibatch, YunaSoft, moka, and Otachan\n\n"
				L"http://www.mpg123.de/\n"
				L"http://shibatch.sourceforge.net/\n"
				L"http://yunasoft.nerv.org/\n"
				L"http://get.to/dagashiya/\n"
				L"http://otachan.com/",
			L"About",
			MB_OK | MB_ICONINFORMATION);
}

int __cdecl
isourfile(const in_char* fn)
{
//	MessageBox(mod.hMainWindow, fn, "", MB_OK);

	WCHAR	FileExt[MAX_PATHLEN];

	CutFileNameExt(fn, NULL, 0, FileExt, MAX_PATHLEN);

	static DWORD	GetIsourfileTime = 0;
//	const int	WinampHighVersion = 0x5011;
	int		RetCode;

	if(/*(WinampVersion >= WinampHighVersion) &&*/
			((::timeGetTime() - GetIsourfileTime) <= 100) &&
			(_wcsicmp(FileExt, L"mp3") == 0)) {
		GetIsourfileTime = 0;
		RetCode = 0;
	} else if((wcsncmp(fn, L"http://", 7) == 0) || (wcsncmp(fn, L"https://", 8) == 0)) {
//		if(WinampVersion >= WinampHighVersion) {
			if(prm->m_bEnableStreaming == false) mod.FileExtensions = "\0";
			GetIsourfileTime = ::timeGetTime();
//		}

		RetCode =	prm->m_bEnable &&
					prm->m_bEnableStreaming &&
					_wcsicmp(FileExt, L"mp4") &&
					_wcsicmp(FileExt, L"m4v") &&
					_wcsicmp(FileExt, L"m4a") &&
					_wcsicmp(FileExt, L"m4p") &&
					_wcsicmp(FileExt, L"aac") &&
					_wcsicmp(FileExt, L"aacp") &&
					_wcsicmp(FileExt, L"asf") &&
					_wcsicmp(FileExt, L"wmv") &&
					_wcsicmp(FileExt, L"wma") &&
					_wcsicmp(FileExt, L"nsv") &&
					_wcsicmp(FileExt, L"nsa") &&
					_wcsicmp(FileExt, L"ogg") &&
					_wcsicmp(FileExt, L"apl") &&
					_wcsicmp(FileExt, L"vlb");
	} else if((wcsncmp(fn, L"mms://", 6) == 0) ||
			(wcsncmp(fn, L"mmsu://", 7) == 0) ||
			(wcsncmp(fn, L"mmst://", 7) == 0)) {
//		if(WinampVersion >= WinampHighVersion) {
			if(prm->m_bEnableStreaming == false) mod.FileExtensions = "\0";
			GetIsourfileTime = ::timeGetTime();
//		}

		RetCode = 0;
	} else {
//		if(WinampVersion >= WinampHighVersion) {
			mod.FileExtensions = prm->m_bEnable ? FILE_EXT : "\0";
			GetIsourfileTime = 0;
//		}

		RetCode = 0;
	}

/*
	int		RetCode;

	// begin pl3 by YunaSoft
	if(prm->m_bEnable && prm->m_bEnableStreaming && (memcmp(fn, "http://", 7) == 0)) {
		char	FileExt[MAX_PATHLEN];

		CutFileNameExt(fn, NULL, 0, FileExt, sizeof FileExt);
		RetCode =	_stricmp(FileExt, "mp4") &&
					_stricmp(FileExt, "m4v") &&
					_stricmp(FileExt, "m4a") &&
					_stricmp(FileExt, "m4p") &&
					_stricmp(FileExt, "aac") &&
					_stricmp(FileExt, "aacp") &&
					_stricmp(FileExt, "nsv") &&
					_stricmp(FileExt, "nsa") &&
					_stricmp(FileExt, "ogg") &&
					_stricmp(FileExt, "apl") &&
					_stricmp(FileExt, "vlb");
	} else {
		RetCode = 0;
	}
	// end pl3
*/

	return RetCode;
}

void __cdecl
pause(void)
{
	if(::WaitForSingleObject(m_RunningPrePlayThread, 0) != WAIT_OBJECT_0) mod.outMod->Pause(1);
	m_paused = true;
}

void __cdecl
unpause(void)
{
	if(::WaitForSingleObject(m_RunningPrePlayThread, 0) != WAIT_OBJECT_0) mod.outMod->Pause(0);
	m_paused = false;
}

int __cdecl
ispaused(void)
{
	return m_paused;
}

int __cdecl
getoutputtime(void)
{
	return (::WaitForSingleObject(m_RunningPlayFunc, 0) == WAIT_OBJECT_0) ?
				0:
				Max(RInt32(m_decode_pos_ms) -
					(mod.outMod->GetWrittenTime() - mod.outMod->GetOutputTime()), 0);
}

void __cdecl
setoutputtime(int time_in_ms)
{
	m_seek_needed = time_in_ms;
}

void __cdecl
setvolume(int volume)
{
	// begin pl3 by YunaSoft
	prm->m_nVolume = volume;
	// end pl3
	mod.outMod->SetVolume(volume);
}

void __cdecl
setpan(int pan)
{
	// begin pl3 by YunaSoft
	prm->m_nPan = pan;
	// end pl3
	mod.outMod->SetPan(pan);
}

int __cdecl
infobox(const in_char* fn, HWND hwnd)
{
	int		RetCode;

	if(wcsncmp(fn, L"http://", 7) && wcsncmp(fn, L"https://", 8)) {
		enum
		{
			MP3INFP_INSTALLED,
			MP3INFP_NOT_INSTALLED,
			MP3INFP_INVALID_VERSION,
		};
		int		Mp3infp;

		if(hMp3infpDll) {
			Mp3infp = MP3INFP_INSTALLED;
		} else {
			WCHAR	FileName[MAX_PATHLEN + 16];

			::GetSystemDirectory(FileName, MAX_PATHLEN + 16);
			wcscat_s(FileName, MAX_PATHLEN + 16, L"\\mp3infp.dll");

			if((hMp3infpDll = ::LoadLibrary(FileName)) == NULL) {
				hMp3infpDll = ::LoadLibrary(L"mp3infp.dll");
			}

			if(hMp3infpDll) {
				if(lpfnMp3infpViewPropEx = reinterpret_cast<LPMP3INFP_VIEWPROPEX>
						(::GetProcAddress(hMp3infpDll, "mp3infp_ViewPropEx"))) {
					Mp3infp = MP3INFP_INSTALLED;
				} else {
					::FreeLibrary(hMp3infpDll);
					hMp3infpDll = NULL;
					Mp3infp = MP3INFP_INVALID_VERSION;
				}
			} else {
				Mp3infp = MP3INFP_NOT_INSTALLED;
			}
		}

		switch(Mp3infp) {
		case MP3INFP_INSTALLED:
			char	mp3infpFileName[MAX_PATHLEN];

			Strcpy(mp3infpFileName, MAX_PATHLEN, fn);

			if(lpfnMp3infpViewPropEx(hwnd, mp3infpFileName, 0, false, 0, 0) >= 0) {
				m_Tag.FlushCache();
				RetCode = 0;
			} else {
				RetCode = 1;
			}
			break;
		case MP3INFP_NOT_INSTALLED:
			{
				SHELLEXECUTEINFO	ExecInfo;

				ExecInfo.cbSize = sizeof ExecInfo;
				ExecInfo.fMask = SEE_MASK_INVOKEIDLIST;
				ExecInfo.hwnd = hwnd;
				ExecInfo.lpVerb = L"properties";
				ExecInfo.lpFile = fn;
				ExecInfo.lpParameters = L"";
				ExecInfo.lpDirectory = NULL;
				ExecInfo.nShow = SW_SHOWNORMAL;
				ExecInfo.hInstApp = NULL;
				ExecInfo.lpIDList = NULL;

				::ShellExecuteEx(&ExecInfo);
			}

			RetCode = 1;
			break;
		case MP3INFP_INVALID_VERSION:
			::MessageBox(
					mod.hMainWindow,
					L"Please install mp3infp v2.48 or higher.",
					L"mpg123",
					MB_OK | MB_ICONSTOP);
			RetCode = 1;
			break;
		}
	} else {
		if(::MessageBox(hwnd, fn, L"Stream URL", MB_OKCANCEL) == IDOK) {
			const int	fnSize = wcslen(fn) + 1;
			HANDLE	hGlobalMemory = ::GlobalAlloc(GMEM_MOVEABLE, fnSize * sizeof WCHAR);
			WCHAR*	lpGlobalMemory = reinterpret_cast<WCHAR*>(::GlobalLock(hGlobalMemory));

			wcscpy_s(lpGlobalMemory, fnSize, fn);
			::GlobalUnlock(hGlobalMemory);

			::OpenClipboard(hwnd);
			::EmptyClipboard();
			::SetClipboardData(CF_TEXT, hGlobalMemory);
			::CloseClipboard();
		}

		RetCode = 1;
	}

	return RetCode;
}

int __cdecl
getlength(void)
{
	return m_mp3info.stream ? -1000 : m_mp3info.length;
}

void __cdecl
eq_set(int on, char data[10], int preamp)
{
}

inline void
CreatePlay2ndWindow(void)
{
	WNDCLASSEX	wndclass;

	wndclass.cbSize        = sizeof wndclass;
	wndclass.style         = 0;
	wndclass.lpfnWndProc   = Play2ndProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = mod.hDllInstance;
	wndclass.hIcon         = NULL;
	wndclass.hCursor       = NULL;
	wndclass.hbrBackground = NULL;
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = PLAY2ND_CLASS;
	wndclass.hIconSm       = NULL;

	::RegisterClassEx(&wndclass);

	hPlay2ndWindow = ::CreateWindowEx(
									0,
									PLAY2ND_CLASS,
									NULL,
									0,
									0,
									0,
									0,
									0,
									NULL,
									NULL,
									mod.hDllInstance,
									NULL);
}

int __cdecl
play(const in_char* fn)
{
	stop();

	wcscpy_s(lastfn, MAX_PATHLEN, fn);

	m_mp3info.stream = (wcsncmp(lastfn, L"http://", 7) == 0) || (wcsncmp(lastfn, L"https://", 8) == 0);

	mod.is_seekable = !m_mp3info.stream;

	m_mp3info.length = -1000;
	m_paused = false;
	m_seek_needed = -1;
	m_sample_buffer_16_bend = 0;
	m_decode_pos_ms = 0.;
	m_vis_pos_ms = 0.;

	RunningPlayFunc(true);

	::SetEvent(m_RunningPrePlayThread);
	::ResetEvent(m_KillPrePlayThread);

	if(hPlay2ndWindow == NULL) CreatePlay2ndWindow();

	AfxBeginThread(PrePlayThreadProc, NULL);

	return 0;
}

inline bool
Play2nd(void)
{
	const int	OutputBps = prm->m_nOutputBps;
	const int	maxlatency = mod.outMod->Open(m_mp3info.freq, m_mp3info.nch, OutputBps, -1, -1);

	if(maxlatency < 0) return false;

	::SetEvent(m_OpenOutModule);

	RunningPlayFunc(false);

	m_Format = (OutputBps >= 0) ? mpg123::DATA_FORMAT_LINEAR_PCM : mpg123::DATA_FORMAT_IEEE_FLOAT;
	m_mp3info.out_bps = (OutputBps >= 0) ? OutputBps : -OutputBps;
	m_mp3info.out_bps_b = m_mp3info.out_bps >> 3;
	m_mp3info.out_bps_b_nch = m_mp3info.out_bps_b * m_mp3info.nch;
	m_out_ssize = 576 * m_mp3info.out_bps_b_nch;

	m_mp3info.vis_bps_b_nch = (16 >> 3) * m_mp3info.nch;
	m_vis_ssize = 576 * m_mp3info.vis_bps_b_nch;

	m_mp3info.bps = 64;
	m_mp3info.bps_b = 64 >> 3;
	m_mp3info.bps_b_nch = m_mp3info.bps_b * m_mp3info.nch;
	m_ssize = 576 * m_mp3info.bps_b_nch;
	m_decode_pos_samples = 0;
	m_skip_start_remain = m_mp3info.skip_start;

	mod.SetInfo(
			m_lastBitrate = m_mp3info.bitrate / 1000,
			m_mp3info.freq / 1000,
			m_mp3info.nch,
			1);

	// initialize vis stuff
	mod.SAVSAInit(maxlatency, m_mp3info.freq);
	mod.VSASetInfo(m_mp3info.freq, m_mp3info.nch);

	// set the output plug-ins default volume
	mod.outMod->SetVolume(-666);

	m_Bitrate = new Bitrate(maxlatency, m_mp3info.freq, 576);

	// begin pl3 by YunaSoft
	// [JXbh쐬Jn
	pDecode = new THREADPARAM;
	pDecode->EventReadyThread = ::CreateEvent(NULL, false, false, NULL);
	pDecode->EventDestroyThread = ::CreateEvent(NULL, false, false, NULL);
	pDecode->param = prm;

	unsigned int	dwThread;

	pDecode->Thread = reinterpret_cast<HANDLE>(_beginthreadex(
															NULL,
															0,
															DecodeThread,
															pDecode,
															CREATE_SUSPENDED,
															&dwThread));

	::SetThreadPriority(pDecode->Thread, prm->GetPriorityValue(prm->m_nDecodeThreadPriority));
	::ResumeThread(pDecode->Thread);

	::WaitForSingleObject(pDecode->EventReadyThread, INFINITE);

	::CloseHandle(pDecode->EventReadyThread);

	return true;
}

UINT __cdecl
PrePlayThreadProc(LPVOID /*Param*/)
{
	const bool	OpenStatus = m_mp3info.stream ? OpenStream() : Open();

	if((::WaitForSingleObject(m_KillPrePlayThread, 0) != WAIT_OBJECT_0) &&
			(::WaitForSingleObject(m_RunningPlayFunc, 0) == WAIT_OBJECT_0)) {
		if((OpenStatus ? ::SendMessage(hPlay2ndWindow, WM_USER, 0, 0) != 0 : false) == false) {
			::PostMessage(mod.hMainWindow, WM_WA_MPEG_EOF, 0, 0);
		}
	}

	::ResetEvent(m_RunningPrePlayThread);

	return 0;
}

inline bool
Open(void)
{
	bool	RetCode;
	VBRTAGDATA	vbr_tag;

	if(getmp3info(true, lastfn, &m_mp3info, &vbr_tag)) {
		input_file = new FileSys(2);

		if(input_file->Open(
						prm->m_bFullBuffering ?
							FILESYS_OPENMODE_FULLBUFFERING : FILESYS_OPENMODE_NORMAL,
						lastfn,
						GENERIC_READ,
						FILE_SHARE_READ,
						NULL,
						OPEN_EXISTING,
						FILE_FLAG_SEQUENTIAL_SCAN)) {
			m_adrTime.Init(input_file, m_mp3info.hpos, m_mp3info.frames);
			input_file->SetPointer(MPG123_FILESYS_NO, m_mp3info.hpos + 4);
			RetCode = true;
		} else {
			delete input_file;
			input_file = NULL;
			RetCode = false;
		}
	} else {
		SetTitleInfoMsg(L"Valid frame not found");
		RetCode = false;
	}

	return RetCode;
}

inline bool
OpenStream(void)
{
	AfxSocketInit();

	// begin pl2 by YunaSoft
	// initialize
	// begin pl3 by YunaSoft
	DWORD	dwServiceType;
	CString	strServer;
	CString	strObject;
	INTERNET_PORT	nPort;
	CString	strUsername;
	CString	strPassword;

	// begin pl2 by YunaSoft
	if(AfxParseURLEx(
				lastfn,
				dwServiceType,
				strServer,
				strObject,
				nPort,
				strUsername,
				strPassword) == 0) {
		SetTitleInfoMsg(L"Parse URL error");
		return false;
	}
	// end pl2

	SetTitleInfoMsg(L"Connecting", strServer);

	const WCHAR*	proxy_bypass = L"";

	session = new CIn_mpg123dSession(
								USER_AGENT,
								1,
								prm->m_bProxy ? INTERNET_OPEN_TYPE_PROXY : INTERNET_OPEN_TYPE_DIRECT,
								prm->m_strProxy,
								proxy_bypass,
								0);
		// end pl3

	if(session == NULL) {
		SetTitleInfoMsg(L"Create session error");
		return false;
	}

	// begin pl4 by YunaSoft
//	session->SetOption(INTERNET_OPTION_CONNECT_RETRIES, 5);
//	session->SetOption(INTERNET_OPTION_CONNECT_TIMEOUT, 5000);
//	session->SetOption(INTERNET_OPTION_RECEIVE_TIMEOUT, 5000);
//	session->SetOption(INTERNET_OPTION_SEND_TIMEOUT, 5000);
	// end pl4

	// begin pl3 by YunaSoft

	prm->m_icy.Init();
	prm->m_icy.m_server = strServer;

	WCHAR	szHeaders[256];

	// making http header...
	wcscpy_s(szHeaders, 256, L"Accept: audio/mpeg, audio/x-mpegurl, */*\r\n");

	if(prm->m_bTitleStreaming) {
		wcscat_s(szHeaders, 256, L"icy-metadata: 1\r\n");

		if(prm->m_bTitleStreamingUDP) {
			if(prm->m_icy.m_udpport = CreateAsyncSocket(nPort, 10)) {
				const size_t	szHeadersLen = wcslen(szHeaders);

				swprintf_s(
						szHeaders + szHeadersLen,
						256 - szHeadersLen,
						L"x-audiocast-udpport: %d\r\n",
						prm->m_icy.m_udpport);

				// UDP|[gJ
				ConnectAsyncSocket(prm->m_icy.m_server, prm->m_icy.m_udpport);
			}
		}
	}

	wcscat_s(szHeaders, 256, L"\r\n");

	try {
		connection = session->GetHttpConnection(strServer, nPort, strUsername, strPassword);
	} catch(CInternetException* pEx) {
		pEx->Delete();

		connection = NULL;
	}

	if(connection) {
		try {
			httpfile = reinterpret_cast<CIn_mpg123dHttpFile*>
								(connection->OpenRequest(
													CHttpConnection::HTTP_VERB_GET,
													strObject,
													NULL,
													1,
													NULL,
													NULL,
													INTERNET_FLAG_TRANSFER_BINARY |
														INTERNET_FLAG_RELOAD |
														INTERNET_FLAG_NO_CACHE_WRITE |
														INTERNET_FLAG_NO_UI |
														((dwServiceType == AFX_INET_SERVICE_HTTPS) ? 
															INTERNET_FLAG_SECURE |
																INTERNET_FLAG_KEEP_CONNECTION |
																INTERNET_FLAG_IGNORE_CERT_CN_INVALID |
																INTERNET_FLAG_IGNORE_CERT_DATE_INVALID
															: 0)));

			if(dwServiceType == AFX_INET_SERVICE_HTTPS) {
				DWORD	dwValue;

				httpfile->QueryOption(INTERNET_OPTION_SECURITY_FLAGS, dwValue);

				dwValue |= SECURITY_FLAG_IGNORE_UNKNOWN_CA;

				httpfile->SetOption(INTERNET_OPTION_SECURITY_FLAGS, dwValue);
			}
		} catch(CInternetException* pEx) {
			pEx->Delete();

			httpfile = NULL;
		}
	}

	if(httpfile) {
		try {
			httpfile->SendRequest(szHeaders, wcslen(szHeaders));
		} catch(CInternetException* pEx) {
			pEx->Delete();

			httpfile->Close();
//			httpfile->Quit();
			delete httpfile;
			httpfile = NULL;
		}
	}

	if((connection == NULL) || (httpfile == NULL)) {
		if(connection) {
			connection->Close();
			delete connection;
			connection = NULL;
		}

		// begin pl2 by YunaSoft
//		if(session) {
			session->Close();
			delete session;
			session = NULL;
//		}
		// end pl2

		// begin pl3 by YunaSoft
		DeleteAsyncSocket();
		// end pl3
		SetTitleInfoMsg(L"Connection failed");
		return false;
	}

	// begin pl3 by YunaSoft
	httpfile->Init(prm->GetPriorityValue(prm->m_nReceiveThreadPriority));

	strbuflen = prm->m_nBufferLength * 1024;
	stream_buffer = reinterpret_cast<char*>(realloc(stream_buffer, strbuflen));
	read_stream_size = 0;
	read_stream_mode = READ_STREAM_MODE_MIN;

	// [JXbh쐬Jn
	pReceive = new THREADPARAM;
	pReceive->EventReadyThread = ::CreateEvent(NULL, false, false, NULL);
	pReceive->EventDestroyThread = ::CreateEvent(NULL, false, false, NULL);
	pReceive->param = prm;
	pReceive->mt = AfxBeginThread(
								ReceiveThread,
								pReceive,
								prm->GetPriorityValue(prm->m_nReceiveThreadPriority),
								0,
								CREATE_SUSPENDED);
	pReceive->mt->m_bAutoDelete = false;
	pReceive->mt->ResumeThread();

	::WaitForSingleObject(pReceive->EventReadyThread, INFINITE);

	::CloseHandle(pReceive->EventReadyThread);

	SetTitleInfoMsg(L"Searching frame");

	bool	RetCode;

	if(getmp3info_stream(&m_mp3info)) {
		SetTitleInfoMsg(L"");
		RetCode = true;
	} else {
		SetTitleInfoMsg((m_StreamErrorMsg != L"") ? m_StreamErrorMsg : L"Valid frame not found");
		RetCode = false;
	}

	return RetCode;
}

void __cdecl
stop(void)
{
	RunningPlayFunc(false);

	if(::WaitForSingleObject(m_RunningPrePlayThread, 0) == WAIT_OBJECT_0) {
		::SetEvent(m_KillPrePlayThread);

		if(connection) connection->Close();
//		if(session) session->Close();

		do {
			MSG		Msg;

			if(::PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE)) {
				::TranslateMessage(&Msg);
				::DispatchMessage(&Msg);
			}
		} while(::WaitForSingleObject(m_RunningPrePlayThread, 0) == WAIT_OBJECT_0);
	}

	// begin pl3 by YunaSoft / ot13 by Otachan
	if(pReceive) {
		::SetEvent(pReceive->EventDestroyThread);

		// Xbh̏I莞ԑ҂
		if(::WaitForSingleObject(pReceive->mt->m_hThread, 5000) != WAIT_OBJECT_0) {
			// Ō̎i
			// 莞ԑ҂ĂIȂƂ́AInternetReadFile API
			// ubNĂƔfAYAPI񂵂ĂXbĥ
			// ނ TerminateThread ĎMXbh̏I҂
//			::MessageBox(
//					mod.hMainWindow,
//					"error asking receive thread to die!",
//					"error killing receive thread",
//					MB_OK | MB_ICONEXCLAMATION);
			if(::TerminateThread(httpfile->pParam->hThread, 0)) {
				::WaitForSingleObject(httpfile->pParam->hThread, 3000);
			}
			::CloseHandle(httpfile->pParam->hThread);
			httpfile->pParam->hThread = INVALID_HANDLE_VALUE;
			// Xbh̏I莞ԑ҂
			if(::WaitForSingleObject(pReceive->mt->m_hThread, 5000) != WAIT_OBJECT_0) {
				if(::TerminateThread(pReceive->mt->m_hThread, 0)) {
					::WaitForSingleObject(pReceive->mt->m_hThread, 3000);
				}
			}
		}

		::CloseHandle(pReceive->EventDestroyThread);

		// CWinThreadIuWFNg̍폜
		delete pReceive->mt;
		delete pReceive;
		pReceive = NULL;
	}
	// end pl3

	if(httpfile) {
		httpfile->Close();
		// begin pl2 by YunaSoft
		httpfile->Quit();
		delete httpfile;
		// end pl2
		httpfile = NULL;
	}

	if(connection) {
		connection->Close();
		delete connection;
		connection = NULL;
	}

	if(session) {
		session->Close();
		// begin pl1 by YunaSoft
		delete session;
		// begin pl3 by YunaSoft
		DeleteAsyncSocket();
		// end pl3
		session = NULL;
		// end pl1
	}

	// begin pl3 by YunaSoft
	prm->m_icy.DeleteHeader();
	// end pl3

	// begin pl3 by YunaSoft / ot13 by Otachan
	if(pDecode) {
		::SetEvent(pDecode->EventDestroyThread);

		if(::WaitForSingleObject(pDecode->Thread, 5000) != WAIT_OBJECT_0) {
			if(::TerminateThread(pDecode->Thread, 0)) {
				::WaitForSingleObject(pDecode->Thread, 3000);
			}
		}

		::CloseHandle(pDecode->Thread);
		::CloseHandle(pDecode->EventDestroyThread);

		delete pDecode;
		pDecode = NULL;
	}
	// end pl3

	if(m_Bitrate) {
		delete m_Bitrate;
		m_Bitrate = NULL;
	}

	m_adrTime.Release();

	if(input_file) {
		delete input_file;
		input_file = NULL;
	}

	if(::WaitForSingleObject(m_OpenOutModule, 0) == WAIT_OBJECT_0) {
		mod.outMod->Close();
		mod.SAVSADeInit();

		::ResetEvent(m_OpenOutModule);
	}
}

void __cdecl
getfileinfo(const in_char* filename, in_char* title, int* length_in_ms)
{
	if((filename == NULL) || (*filename == L'\0')) {
		// currently playing file
		if(length_in_ms) *length_in_ms = m_mp3info.stream ? -1000 : m_mp3info.length;

		if(title) {
			if((::WaitForSingleObject(m_RunningPlayFunc, 0) == WAIT_OBJECT_0) &&
					(m_TitleInfoMsg != L"")) {
				wcscpy_s(title, GETFILEINFO_TITLE_LENGTH, m_TitleInfoMsg);
			// begin pl1 by YunaSoft
			} else if(m_mp3info.stream) {
				if((prm->m_icy.m_title == L"") && (prm->m_icy.m_name == L"")) {
					WCHAR	Name[MAX_PATHLEN];

					CutPathFileName(lastfn, NULL, 0, Name, MAX_PATHLEN);
					CutFileNameExt(Name, title, GETFILEINFO_TITLE_LENGTH);
				} else {
					const int	BuffLen = wcslen(prm->m_icy.m_title) + 2 +
											wcslen(prm->m_icy.m_name) + 2;
					WCHAR*	Buff = new WCHAR[BuffLen * sizeof WCHAR];

					// begin pl3 by YunaSoft
					if(prm->m_icy.m_title == L"") {
						*Buff = L'\0';
					} else {
						wcscpy_s(Buff, BuffLen, prm->m_icy.m_title); 
					}

					if(prm->m_icy.m_name != L"") {
						if(prm->m_icy.m_title != L"") wcscat_s(Buff, BuffLen, L" (");
						wcscat_s(Buff, BuffLen, prm->m_icy.m_name);
						if(prm->m_icy.m_title != L"") wcscat_s(Buff, BuffLen, L")");
					}

					Strncpy(title, Buff, GETFILEINFO_TITLE_LENGTH - 1);

					delete[] Buff;
					// end pl3
				}
			} else {
			// end pl1
				if(m_Tag.Get(title, prm->m_strID3Format, prm->m_nTagPriority, lastfn) == false) {
					WCHAR	Name[MAX_PATHLEN];

					CutPathFileName(lastfn, NULL, 0, Name, MAX_PATHLEN);
					CutFileNameExt(Name, title, GETFILEINFO_TITLE_LENGTH);
				}
			}

			if((m_TitleInfoMsg_GetFileInfo_ID + 1) == m_TitleInfoMsg_ID) {
				::SetEvent(m_EventTitleInfoMsg);
				m_TitleInfoMsg_GetFileInfo_ID++;
			}
		}
	} else {
		// some other file
		if(wcsncmp(filename, L"http://", 7) && wcsncmp(filename, L"https://", 8)) {
			mp3info	info;
			VBRTAGDATA	vbr_tag;

			if(getmp3info(false, filename, &info, &vbr_tag)) {
				if(length_in_ms) *length_in_ms = info.length;

				if(title &&
						(m_Tag.Get(
								title,
								prm->m_strID3Format,
								prm->m_nTagPriority,
								filename) == false)) {
					WCHAR	Name[MAX_PATHLEN];

					CutPathFileName(filename, NULL, 0, Name, MAX_PATHLEN);
					CutFileNameExt(Name, title, GETFILEINFO_TITLE_LENGTH);
				}
			} else {
				// not MP3 file
				if(length_in_ms) *length_in_ms = -1000;
				if(title) CutPathFileName(filename, NULL, 0, title, GETFILEINFO_TITLE_LENGTH);
			}
		} else {
			if(length_in_ms) *length_in_ms = -1000;
			if(title) *title = L'\0';
		}
	}
}

// Decoding thread

void
Out_Float64toInt16(char* OutBuff, unsigned char* InBuff, const int Size)
{
	short*	OutBuff_ = reinterpret_cast<short*>(OutBuff);

	for(int Idx = 0; Idx < Size; Idx += 8) {
		int		v = RInt32(*reinterpret_cast<double*>(InBuff + Idx) * 0x7fff);

		if(v > 0x7fff) {
			v = 0x7fff;
		} else if(v < -0x8000) {
			v = -0x8000;
		}

		*OutBuff_++ = v;
	}
}

void
Out_Float64toInt24(char* OutBuff, unsigned char* InBuff, const int Size)
{
	for(int Idx = 0; Idx < Size; Idx += 8) {
		__int64	v = RInt64(*reinterpret_cast<double*>(InBuff + Idx) * 0x7fffff);

		if(v > 0x7fffffi64) {
			v = 0x7fffffi64;
		} else if(v < -0x800000i64) {
			v = -0x800000i64;
		}

		*reinterpret_cast<unsigned short*>(OutBuff) = *reinterpret_cast<unsigned short*>(&v);
		*(OutBuff + 2) = *(reinterpret_cast<unsigned char*>(&v) + 2);

		OutBuff += 3;
	}
}

void
Out_Float64toInt32(char* OutBuff, unsigned char* InBuff, const int Size)
{
	int*	OutBuff_ = reinterpret_cast<int*>(OutBuff);

	for(int Idx = 0; Idx < Size; Idx += 8) {
		__int64	v = RInt64(*reinterpret_cast<double*>(InBuff + Idx) * 0x7fffffff);

		if(v > 0x7fffffffi64) {
			v = 0x7fffffffi64;
		} else if(v < -0x80000000i64) {
			v = -0x80000000i64;
		}

		*OutBuff_++ = static_cast<int>(v);
	}
}

void
Out_Float64toFloat32(char* OutBuff, unsigned char* InBuff, const int Size)
{
	float*	OutBuff_ = reinterpret_cast<float*>(OutBuff);

	for(int Idx = 0; Idx < Size; Idx += 8) {
		*OutBuff_++ = static_cast<float>(*reinterpret_cast<double*>(InBuff + Idx));
	}
}

void
Out_Float64toFloat64(char* OutBuff, unsigned char* InBuff, const int Size)
{
	memcpy(OutBuff, InBuff, Size);
}

void
Vis_Int16toInt16(char* OutBuff, char* InBuff, const int Size)
{
	memcpy(OutBuff, InBuff, Size);
}

void
Vis_Int24toInt16(char* OutBuff, char* InBuff, const int Size)
{
	short*	OutBuff_ = reinterpret_cast<short*>(OutBuff);

	for(int Idx = 1; Idx < Size; Idx += 3) {
		*OutBuff_++ = *reinterpret_cast<short*>(InBuff + Idx);
	}
}

void
Vis_Int32toInt16(char* OutBuff, char* InBuff, const int Size)
{
	short*	OutBuff_ = reinterpret_cast<short*>(OutBuff);

	for(int Idx = 2; Idx < Size; Idx += 4) {
		*OutBuff_++ = *reinterpret_cast<short*>(InBuff + Idx);
	}
}

void
Vis_Float32toInt16(char* OutBuff, char* InBuff, const int Size)
{
	short*	OutBuff_ = reinterpret_cast<short*>(OutBuff);

	for(int Idx = 0; Idx < Size; Idx += 4) {
		int		v = static_cast<int>(*reinterpret_cast<float*>(InBuff + Idx) * 0x7fff);

		if(v > 0x7fff) {
			v = 0x7fff;
		} else if(v < -0x8000) {
			v = -0x8000;
		}

		*OutBuff_++ = v;
	}
}

void
Vis_Float64toInt16(char* OutBuff, char* InBuff, const int Size)
{
	short*	OutBuff_ = reinterpret_cast<short*>(OutBuff);

	for(int Idx = 0; Idx < Size; Idx += 8) {
		int		v = static_cast<int>(*reinterpret_cast<double*>(InBuff + Idx) * 0x7fff);

		if(v > 0x7fff) {
			v = 0x7fff;
		} else if(v < -0x8000) {
			v = -0x8000;
		}

		*OutBuff_++ = v;
	}
}

inline void	PostProcStereo(unsigned char* Buff, const int Size);
inline void	PostProcMono(unsigned char* Buff, const int Size);

inline void
PostProc(unsigned char* Buff, int Size)
{
	if(m_mp3info.nch == 2) {
		PostProcStereo(Buff, Size);
	} else {
		PostProcMono(Buff, Size);
	}
}

inline void
PostProcStereo(unsigned char* Buff, const int Size)
{
	const bool	bReverseLR = prm->m_bReverseLR;
	const bool	bReversePhase = prm->m_bReversePhase;
	const bool	bAltVolume = prm->m_bAltVolume;
	const int	nVolume = prm->m_nVolume;
	const int	nPan = prm->m_nPan;
	const int	pl = nPan > 0 ? 127 - nPan : 127;
	const int	pr = nPan < 0 ? 127 + nPan : 127;

	const int	Bps = 8;
	const int	AddIdx = Bps * 2;

	for(int Idx = 0; Idx < Size; Idx += AddIdx) {
		unsigned char*	IdxBuff = Buff + Idx;
		double*	l = reinterpret_cast<double*>(IdxBuff);
		double*	r = reinterpret_cast<double*>(IdxBuff + Bps);

		if(bReverseLR) Swap(l, r);

		if(bReversePhase) {
			*l *= -1;
			*r *= -1;
		}

		if(bAltVolume && ((nVolume != 255) || (nPan != 0))) {
			*l = nVolume * pl * *l / (255 * 127);
			*r = nVolume * pr * *r / (255 * 127);
		}
	}
}

inline void
PostProcMono(unsigned char* Buff, const int Size)
{
	const bool	bReversePhase = prm->m_bReversePhase;
	const bool	bAltVolume = prm->m_bAltVolume;
	const int	nVolume = prm->m_nVolume;

	const int	Bps = 8;

	for(int Idx = 0; Idx < Size; Idx += Bps) {
		double*	p = reinterpret_cast<double*>(Buff + Idx);

		if(bReversePhase) {
			*p *= -1;
		}

		if(bAltVolume && (nVolume != 255)) {
			*p = nVolume * *p / 255;
		}
	}
}

/*
void postproc(char *buf,int size)
{
	int Bps = 2;

	// begin pl3 by YunaSoft
	if (!prm->m_bReverse && !prm->m_bInvert && !prm->m_bAltVolume) return;
	// end pl3
	
	if (m_mp3info.nch == 2) {
		int i;
		int pl=127,pr=127;
		// begin pl3 by YunaSoft
		if (prm->m_nPan > 0) pl = 127 - prm->m_nPan;
		if (prm->m_nPan < 0) pr = 127 + prm->m_nPan;
		// end pl3

		for(i=0;i<size/2/Bps;i++)
		{
			short *l = (short *)&buf[i*4],*r = (short *)&buf[i*4+2];

			// begin pl3 by YunaSoft
			if (prm->m_bReverse) {
			// end pl3
				short s;
				s = *l; *l = *r; *r = s;
			}
		
			// begin pl3 by YunaSoft
			if (prm->m_bInvert) {
			// end pl3
				*l = *l == -32768 ? 32767 : -*l; *r = *r == -32768 ? 32767 : -*r;
			}

			// begin pl3 by YunaSoft
			if (prm->m_bAltVolume) {
				*l = prm->m_nVolume*pl*(int)*l/(255*127);
				*r = prm->m_nVolume*pr*(int)*r/(255*127);
			}
			// end pl3
		}
	} else if (m_mp3info.nch == 1) {
		int i;
		for(i=0;i<size/Bps;i++)
		{
			short *p = (short *)&buf[i*2];

			// begin pl3 by YunaSoft
			if (prm->m_bInvert) {
				*p = *p == -32768 ? 32767 : -*p;
			}

			if (prm->m_bAltVolume) {
				*p = prm->m_nVolume*(int)*p/255;
			}
			// end pl3
		}
	}
}
*/

inline int
get_576_samples(mpg123* mp, char* out, bool* supZero)
{
	while(m_bend < m_ssize) {
		int		Size;

		if(m_decoder_stat != MP3_ERR) {
			DWORD	Len;
			unsigned char*	InBuff;
			unsigned char	Buff[FBSIZE];

			if(m_decoder_stat == MP3_NEED_MORE) {
				if(m_mp3info.stream) {
					Len = read_stream_buffer(Buff, FBSIZE);
				} else {
					const DWORD	ShiftBuff = m_prefetch_head ? 4 : 0;
					const DWORD	ReadPnt = input_file->GetPointer(MPG123_FILESYS_NO);
					const DWORD	RemainSize = (static_cast<DWORD>(m_mp3info.hnbytes) > ReadPnt) ?
												m_mp3info.hnbytes - ReadPnt : 0;
					const DWORD	ReadSize = Min(FBSIZE - ShiftBuff, RemainSize);

					if(ReadSize) {
						input_file->Read(MPG123_FILESYS_NO, Buff + ShiftBuff, ReadSize, &Len);
					} else {
						Len = 0;
					}

					if(m_prefetch_head) {
						*reinterpret_cast<unsigned int*>(Buff) = m_head;
						Len += 4;
						m_prefetch_head = false;
					}
				}

				if(Len) {
					InBuff = Buff;
				} else {
					break;
				}
			} else {
				Len = 0;
				InBuff = NULL;
			}

			m_decoder_stat = mp->decode(InBuff, Len, m_obuff + m_bend, OBSIZE - m_bend, &Size);
		}

		if(m_decoder_stat == MP3_OK) {
/*
			if((m_mp3info.stream == false) && (m_mp3info.vbr_tag == false)) {
				const int	framesize = mp->totalFramesize / mp->nframe;
				const int	samples = m_mp3info.nbytes / framesize * m_mp3info.frame_samples;

				m_mp3info.length = ::MulDiv(samples, 1000, m_mp3info.freq);
			}
*/

			m_bend += Size;

			if(m_skip_start_remain) {
				const int	bend_samples = m_bend / m_mp3info.bps_b_nch;

				if(m_skip_start_remain < bend_samples) {
					const int	m_skip_start_remain_size = m_skip_start_remain * m_mp3info.bps_b_nch;

					m_bend -= m_skip_start_remain_size;
					memmove(m_obuff, m_obuff + m_skip_start_remain_size, m_bend);

					m_skip_start_remain = 0;
				} else {
					m_bend = 0;

					m_skip_start_remain -= bend_samples;
				}
			}

			if(*supZero) {
				const int	nch = m_mp3info.nch;
				const int	bps_b = m_mp3info.bps_b;
				int		p;

				for(p = 0; p < m_bend; p += m_mp3info.bps_b_nch) {
					for(int c = 0; c < nch; c++) {
						for(int q = 0; q < bps_b; q++) {
							if(m_obuff[p + c * bps_b + q] != 0) goto BreakSupLoop;
						}
					}
				}

BreakSupLoop:
				if(p < m_bend) {
					m_bend -= p;
					memmove(m_obuff, m_obuff + p, m_bend);

					*supZero = false;
				} else {
					m_bend = 0;
				}

				const int	zero_samples = p / m_mp3info.bps_b_nch;

				m_decode_pos_ms += (zero_samples * 1000. / m_mp3info.freq);
				m_vis_pos_ms = m_decode_pos_ms;
				if(m_mp3info.vbr_tag) m_decode_pos_samples += zero_samples;
			}
		} else if(m_decoder_stat == MP3_WAR) {
			m_decode_pos_ms += (m_mp3info.frame_samples * 1000. / m_mp3info.freq);
			m_vis_pos_ms = m_decode_pos_ms;
			if(m_mp3info.vbr_tag) m_decode_pos_samples += m_mp3info.frame_samples;
		} else if(m_decoder_stat == MP3_ERR) {
			return -1;
		}
	}

	int		CopySize = Min(m_bend, m_ssize);

	if(CopySize) {
		if(m_mp3info.vbr_tag) {
			int		CopySamples = CopySize / m_mp3info.bps_b_nch;

			if((m_decode_pos_samples + CopySamples) >= m_mp3info.samples) {
				CopySamples = (m_mp3info.samples > m_decode_pos_samples) ?
									m_mp3info.samples - m_decode_pos_samples :
									0;
				CopySize = CopySamples * m_mp3info.bps_b_nch;
			}

			m_decode_pos_samples += CopySamples;
		}

		if(CopySize) {
			m_Bitrate->Set(mp->currentBitrate);

			if(prm->m_bPostProc) PostProc(m_obuff, CopySize);

			m_OutDataFunc(out, m_obuff, CopySize);

			m_bend -= CopySize;
			if(m_bend) memmove(m_obuff, m_obuff + CopySize, m_bend);
		}
	}

	return CopySize / m_mp3info.bps_b_nch;
}

bool
SearchHeader(mpg123* mp, const bool Seek, const DWORD Offset)
{
	bool	RetCode = false;

	input_file->SetPointer(MPG123_FILESYS_NO, Offset);

	const int	MaxSeach = Min(static_cast<int>(m_mp3info.hnbytes - 4 - Offset + 1), MAX_SEARCH_HEADER);

	for(int Idx = 0; Idx < MaxSeach; Idx++) {
		DWORD	ReadByte;
		unsigned int	read_head;

		if(Idx == 0) {
			input_file->Read(MPG123_FILESYS_NO, &read_head, 4, &ReadByte);

			if(ReadByte < 4) break;
		} else {
			unsigned char	head1byte;

			input_file->Read(MPG123_FILESYS_NO, &head1byte, 1, &ReadByte);

			if(ReadByte < 1) break;

			read_head >>= 8;
			*(reinterpret_cast<unsigned char*>(&read_head) + 3) = head1byte;
		}

		if(head_check2(BSwap32(read_head), &m_mp3info)) {
			m_head = read_head;
			m_prefetch_head = true;

			double	NewPos = m_adrTime.ToTime(Offset + Idx);

			if(NewPos == -1.) NewPos = Seek ? 0. : m_decode_pos_samples * 1000. / m_mp3info.freq;

			if(Seek) {
				m_skip_start_remain = m_mp3info.skip_start;
			} else {
				NewPos -= m_mp3info.skip_start_ms;
				m_skip_start_remain = m_mp3info.decode_delay;
			}

			m_sample_buffer_16_bend = 0;
			m_decode_pos_ms = RInt32(NewPos);
			m_vis_pos_ms = m_decode_pos_ms;
			if(m_mp3info.vbr_tag) m_decode_pos_samples = RInt32(NewPos * m_mp3info.freq / 1000.);

			mp->flush();

			m_bend = 0;
			m_decoder_stat = MP3_NEED_MORE;

			RetCode = true;
			break;
		}
	}

	return RetCode;
}

inline bool
SearchHeader_stream(mpg123* mp)
{
	bool	RetCode = false;

	read_stream_size = 0;
	read_stream_mode = READ_STREAM_MODE_MIN;

	for(int Idx = 0; Idx < MAX_SEARCH_HEADER; Idx++) {
		unsigned int	read_head;

		if(read_stream_index(&read_head, Idx, 4) == false) break;

		if(head_check2(BSwap32(read_head), &m_mp3info)) {
			::EnterCriticalSection(&CriticalSection);

			strbufp_s += Idx;
			if(strbufp_s >= strbuflen) strbufp_s -= strbuflen;
			strbufp_e -= Idx;

			::LeaveCriticalSection(&CriticalSection);

			m_skip_start_remain = m_mp3info.decode_delay;

			mp->flush();

			m_bend = 0;
			m_decoder_stat = MP3_NEED_MORE;

			read_stream_size = Max(strbuflen / 16, MIN_STREAM_SIZE);

			if(preload_stream(read_stream_size)) {
				read_stream_mode = READ_STREAM_MODE_MAX;
				RetCode = true;
			}
			break;
		}
	}

	return RetCode;
}

inline void
WriteOutModule(const int Len)
{
	const int	SampleBuffLen = Len * m_mp3info.out_bps_b_nch;

	m_VisDataFunc(
				sample_buffer_16 + m_sample_buffer_16_bend,
				sample_buffer,
				SampleBuffLen);

	m_sample_buffer_16_bend += Len * m_mp3info.vis_bps_b_nch;

	while(m_sample_buffer_16_bend >= m_vis_ssize) {
		const int	PosMs = RInt32(m_vis_pos_ms);

		mod.SAAddPCMData(sample_buffer_16, m_mp3info.nch, 16, PosMs);
		mod.VSAAddPCMData(sample_buffer_16, m_mp3info.nch, 16, PosMs);

		m_sample_buffer_16_bend -= m_vis_ssize;

		if(m_sample_buffer_16_bend) {
			memmove(
				sample_buffer_16,
				sample_buffer_16 + m_vis_ssize,
				m_sample_buffer_16_bend);
		}

		m_vis_pos_ms += 576 * 1000. / m_mp3info.freq;
	}

	mod.outMod->Write(sample_buffer, SampleBuffLen);

	m_decode_pos_ms += Len * 1000. / m_mp3info.freq;
}

void
SetInfo_Bitrate(void)
{
	if(prm->m_bDispAvg == false) {
		const int	Bitrate = m_Bitrate->Get(mod.outMod->GetWrittenTime() -
									mod.outMod->GetOutputTime());

		if((Bitrate != 0) && (Bitrate != m_lastBitrate)) {
			mod.SetInfo(Bitrate, -1, -1, -1);
			m_lastBitrate = Bitrate;
		}
	}
}

inline void
GetReplayGainInfo(double* ReplayGainGain, bool* ReplayGainHardLimit, double* ReplayGainPeak)
{
	if(prm->m_bReplayGainEnable) {
		if(m_mp3info.stream) {
			*ReplayGainGain = prm->m_nReplayGainPreAmpWithoutRG / 10.;
			*ReplayGainHardLimit =
								prm->m_bReplayGainHardLimit && (prm->m_nReplayGainPreAmpWithoutRG > 0);
			*ReplayGainPeak = 1.;
		} else {
			Tag::_ReplayGainInfo	Info;

			m_Tag.GetReplayGainInfo(
								&Info,
								&m_mp3info,
								prm->m_nTagPriority,
								prm->m_nReplayGainTag,
								lastfn);

			const int	ReplayGainMode = ((prm->m_nReplayGainMode == 1) && Info.ValidAlbumGain) ? 1 : 0;

			if(((ReplayGainMode == 0) && Info.ValidTrackGain) || (ReplayGainMode == 1)) {
				*ReplayGainGain = ((ReplayGainMode == 0) ? Info.TrackGain : Info.AlbumGain) +
										prm->m_nReplayGainPreAmpWithRG / 10.;
				*ReplayGainHardLimit =
									prm->m_bReplayGainHardLimit && (prm->m_nReplayGainPreAmpWithRG > 0);
				*ReplayGainPeak = (ReplayGainMode == 0) ?
										(Info.ValidTrackPeak ? Info.TrackPeak : 0.) :
										(Info.ValidAlbumPeak ? Info.AlbumPeak : 0.);
			} else {
				*ReplayGainGain = prm->m_nReplayGainPreAmpWithoutRG / 10.;
				*ReplayGainHardLimit =
								prm->m_bReplayGainHardLimit && (prm->m_nReplayGainPreAmpWithoutRG > 0);
				*ReplayGainPeak = 1.;
			}
		}
	} else {
		*ReplayGainGain = 0.;
		*ReplayGainHardLimit = false;
		*ReplayGainPeak = 0.;
	}
}

// begin pl2 by YunaSoft
//UINT DecodeThread(LPVOID pParam)
unsigned int __stdcall
DecodeThread(LPVOID pParam)
// end pl2
{
	// begin pl2 by YunaSoft
	// THREADPARAM
	THREADPARAM*	p = reinterpret_cast<THREADPARAM*>(pParam);
	// end pl2

	double	ReplayGainGain;
	bool	ReplayGainHardLimit;
	double	ReplayGainPeak;

	GetReplayGainInfo(&ReplayGainGain, &ReplayGainHardLimit, &ReplayGainPeak);

	mpg123*	mp = new mpg123(ReplayGainGain, ReplayGainHardLimit, ReplayGainPeak);

	m_bend = 0;
	m_decoder_stat = MP3_NEED_MORE;

	switch(m_mp3info.out_bps) {
	case 16:
		m_OutDataFunc = Out_Float64toInt16;
		m_VisDataFunc = Vis_Int16toInt16;
		break;
	case 24:
		m_OutDataFunc = Out_Float64toInt24;
		m_VisDataFunc = Vis_Int24toInt16;
		break;
	case 32:
		switch(m_Format) {
		case mpg123::DATA_FORMAT_LINEAR_PCM:
			m_OutDataFunc = Out_Float64toInt32;
			m_VisDataFunc = Vis_Int32toInt16;
			break;
		case mpg123::DATA_FORMAT_IEEE_FLOAT:
			m_OutDataFunc = Out_Float64toFloat32;
			m_VisDataFunc = Vis_Float32toInt16;
			break;
		}
		break;
	case 64:
		m_OutDataFunc = Out_Float64toFloat64;
		m_VisDataFunc = Vis_Float64toInt16;
		break;
	}

	bool	DecodeEof = false;
	bool	done = false;
	bool	supZero = prm->m_bSupZero;

	if(m_paused) mod.outMod->Pause(1);

	::SetEvent(p->EventReadyThread);

	if(m_mp3info.stream) {
		stream_hF = INVALID_HANDLE_VALUE;

		read_stream_size = Max(strbuflen / 16, MIN_STREAM_SIZE);

		if(preload_stream(read_stream_size)) {
			read_stream_mode = READ_STREAM_MODE_MAX;
		} else {
			done = true;
		}
	}

	// begin pl2 by YunaSoft
	while(::WaitForSingleObject(p->EventDestroyThread, 0) != WAIT_OBJECT_0) {
//	while (! *((int *)b) ) 
	// end pl2
		if(m_seek_needed != -1) {
			if(SearchHeader(mp, true, m_adrTime.ToAddress(m_seek_needed))) {
				done = false;
				supZero = false;

				mod.outMod->Flush(RInt32(m_decode_pos_ms));
				m_Bitrate->Flush();

				m_seek_needed = -1;
			} else {
				done = true;
			}
		}

		if(done) {
			// fR[hICobt@̓eׂď̂҂Ă
//			mod.outMod->CanWrite();

			if(mod.outMod->IsPlaying() == 0) {
				DecodeEof = true;
				break;
			}

			SetInfo_Bitrate();

			::Sleep(1);
		} else if(mod.outMod->CanWrite() >= (m_out_ssize << (mod.dsp_isactive() ? 1 : 0))) {
			// ʏ
			int		Len = get_576_samples(mp, sample_buffer, &supZero);

			if(Len == -1) {
				if(m_mp3info.stream) {
					if(SearchHeader_stream(mp)) {
						supZero = false;
					} else {
						done = true;
					}
				} else {
					if(SearchHeader(mp, false, input_file->GetPointer(MPG123_FILESYS_NO))) {
						supZero = false;
					} else {
						done = true;
					}
				}
			} else if(Len == 0) {
				done = true;
			} else {
				if(mod.dsp_isactive()) {
					Len = mod.dsp_dosamples(
										reinterpret_cast<short*>(sample_buffer),
										Len,
										m_mp3info.out_bps,
										m_mp3info.nch,
										m_mp3info.freq);
				}

				if(Len) WriteOutModule(Len);
			}
		} else {
			SetInfo_Bitrate();

			::Sleep(1);
		}

		if(m_mp3info.stream &&
				(p->param->m_bSaveStream == false) &&
				(stream_hF != INVALID_HANDLE_VALUE)) {
			CloseHandle(stream_hF);
			stream_hF = INVALID_HANDLE_VALUE;
		}
	}

	if(m_mp3info.stream && (stream_hF != INVALID_HANDLE_VALUE)) CloseHandle(stream_hF);

	delete mp;

	if(DecodeEof) ::PostMessage(mod.hMainWindow, WM_WA_MPEG_EOF, 0, 0);

	_endthreadex(0);

	return 0;
}

// begin pl2 by YunaSoft

/////////////////////////////////////////////////////////////////////////////
// CIn_mpg123dSession object

// In_mpg123d wants to use its own derivative of the CInternetSession class
// just so it can implement an OnStatusCallback() override.

CIn_mpg123dSession::CIn_mpg123dSession(LPCTSTR pstrAgent,
									   DWORD dwContext,
									   DWORD dwAccessType,
									   LPCTSTR pstrProxyName,
									   LPCTSTR pstrProxyBypass,
									   DWORD dwFlags) 
	: CInternetSession(pstrAgent, dwContext, dwAccessType, pstrProxyName,
									   pstrProxyBypass, dwFlags)
{

}

//void
//CIn_mpg123dSession::OnStatusCallback(DWORD /* dwContext */, DWORD dwInternetStatus,
//	LPVOID /* lpvStatusInfomration */, DWORD /* dwStatusInformationLen */)
//{
//	AFX_MANAGE_STATE( AfxGetAppModuleState( ) );
//	if(dwInternetStatus == INTERNET_STATUS_CONNECTED_TO_SERVER) {
//		int a = 0;
//	}
//}

#if 0
/////////////////////////////////////////////////////////////////////////////
// CIn_mpg123dException -- used if something goes wrong for us

// In_mpg123d will throw its own exception type to handle problems it might
// encounter while fulfilling the user's request.

IMPLEMENT_DYNCREATE(CIn_mpg123dException, CException)

CIn_mpg123dException::CIn_mpg123dException(int nCode)
	: m_nErrorCode(nCode)
{
}

void
ThrowIn_mpg123dException(int nCode)
{
	CIn_mpg123dException* pEx = new CIn_mpg123dException(nCode);
	throw pEx;
}

#endif

//////////////////////////////////////////////////////////////
// UDP
//
// CSocket DGRAMł̓oȋĈ
// CAsyncSocket g܂

BOOL
CIn_mpg123App::InitInstance(void)
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(!AfxSocketInit()) {
		AfxMessageBox(L"Failed to initialize sockets", MB_OK | MB_ICONSTOP);
		return false;
	}

	return CWinApp::InitInstance();
}

UINT
CreateAsyncSocket(UINT nPort, UINT count)
{
	UINT i = 0;
	bool bFlag = false;

	if(m_pAsyncSocket) delete m_pAsyncSocket;

	m_pAsyncSocket = (CIn_mpg123dAsyncSocket*)new CIn_mpg123dAsyncSocket();
	if(!m_pAsyncSocket) return 0;

	while((i < count) && (!bFlag)) {
		if (!m_pAsyncSocket->Create(nPort + i, SOCK_DGRAM, NULL)) {
			i++;
		} else {
			bFlag = true;
		}
	}

	if(!bFlag) {
		delete m_pAsyncSocket;
		m_pAsyncSocket = NULL;
		return 0;
	}

	return nPort + i;
}

bool
ConnectAsyncSocket(CString strAddress, UINT nPort)
{
	if(!m_pAsyncSocket->Connect(strAddress, nPort)) {
		delete m_pAsyncSocket;
		m_pAsyncSocket = NULL;
		return false;
	}

	return true;
}

// begin pl3 by YunaSoft
void
DeleteAsyncSocket(void)
{
	if(m_pAsyncSocket) {
		delete m_pAsyncSocket;
		m_pAsyncSocket = NULL;
	}
}

void
ReceiveUDPMsg(const WCHAR* src)
{
	if(prm->m_icy.m_udpport > 0) {
		prm->m_icy.m_title = src;
		UpdateWinampDisplay();
	}
}

void
UpdateUDPSocket(CString server, UINT nPort)
{
	// UDP󂯂
	DeleteAsyncSocket();
	CreateAsyncSocket(nPort, 1);
	ConnectAsyncSocket(server, nPort);
}
// end pl3

//////////////////////////////////////////////////////////////
// ReadStream
//
// httpfile->Read ɑウ ƎɃCv httpfile->ReadEx
// gĂ܂BIn_mpg123dHttpFile.cpp QƂĂ

// begin pl3 by YunaSoft

UINT ReadStream(char* src, UINT nCount)
{
	// Streamǂ
	return httpfile->ReadEx(src, nCount);
}

// end pl3

// begin pl2 by YunaSoft
//////////////////////////////////////////////////////////////
// ReceiveThread
//
// CreateThread ŏグThreadlibc̊֐̋ۏ؂
// Ȃ̂ŁAAfxBeginThread ŏグĂ܂

/*
UINT
ReceiveThread(LPVOID pParam)
//DWORD WINAPI __stdcall ReceiveThread(void *b)
// end pl2
{
	// THREADPARAM
	THREADPARAM*	p = reinterpret_cast<THREADPARAM*>(pParam);

	strbuf_eof = false;
	CFileException fe;
	CFile* fp;
	char tmp[READUNIT + 0xff * 16]; // StreamTextEŒǉǂݏôłQ{m

	// begin pl3 by YunaSoft
	fp = NULL;
	// end pl3

	// begin pl3 by YunaSoft
	// Streamt@CɗƂƂ͂Ȋ
	if(p->param->m_bSaveStream) {
		fp = new CFile;
		fp->Open(p->param->m_strSaveStream, CFile::modeCreate | CFile::modeWrite);
	}
	// end pl3

	::SetEvent(p->EventReadyThread);

	// begin pl2 by YunaSoft
//	while (! *((int *)b) ) 
	while(::WaitForSingleObject(p->EventDestroyThread, 0) != WAIT_OBJECT_0)
	// end pl2
	{
		if((strbufp_e == strbuflen) && (strbufp_s != 0)) strbufp_e = 0;

		if((strbufp_e != strbuflen) && (strbufp_e >= strbufp_s)) {
			// begin pl3 by YunaSoft
//			len = httpfile->Read(stream_buffer+strbufp_e,len2);

			UINT	len = ReadStream(tmp, Min(strbuflen - strbufp_e, READUNIT));

			// get ICY info and remove streamtext
			len = p->param->m_icy.GetICYInfo(stream_buffer + strbufp_e, tmp, len);

			if(p->param->m_bSaveStream) {
				// open if fp was closed
				if(!fp) {
					fp = new CFile;
					fp->Open(p->param->m_strSaveStream, CFile::modeCreate | CFile::modeWrite);
				}
				fp->Write(stream_buffer + strbufp_e, len);
			} else {
				// close if fp was opened
				if(fp) {
					fp->Flush();
					fp->Close();
					delete fp;
					fp = NULL;
				}
			}
			// end pl3

			strbufp_e += len;

			if(len == 0) break;
		} else if(!((strbufp_e == strbuflen - 1) && (strbufp_s == strbuflen)) &&
					(strbufp_e < strbufp_s - 1)) {
			// begin pl3 by YunaSoft
//			len = httpfile->Read(stream_buffer+strbufp_e,len2);

			UINT	len = ReadStream(tmp, Min(strbufp_s - strbufp_e - 1, READUNIT));

			// get ICY info and remove streamtext
			len = p->param->m_icy.GetICYInfo(stream_buffer + strbufp_e, tmp, len);

			if(p->param->m_bSaveStream) {
				// open if fp was closed
				if(!fp) {
					fp = new CFile;
					fp->Open(p->param->m_strSaveStream, CFile::modeCreate | CFile::modeWrite); 
				}
				fp->Write(stream_buffer + strbufp_e, len);
			} else {
				// close if fp was opened
				if(fp) {
					fp->Flush();
					fp->Close();
					delete fp;
					fp = NULL;
				}
			}
			// end pl3

			strbufp_e += len;

			if(len == 0) break;
		} else {
			Sleep(20);
		}
	}

// begin pl3 by YunaSoft

	//	if(p->param->m_bSaveStream) {
		if(fp) {
			fp->Flush();
			fp->Close();
			delete fp;
			fp = NULL;
		}
	//}
// end pl3

	strbuf_eof = true;

	return 0;
}
*/

HANDLE
OpenStreamFile(void)
{
	WCHAR	FileName[MAX_PATHLEN];
	WCHAR	FileNameOnly[MAX_PATHLEN];

	CutPathFileName(prm->m_strSaveStream, FileName, MAX_PATHLEN, FileNameOnly, MAX_PATHLEN);

	size_t	FileNameLen = wcslen(FileName);
	size_t	FileNameSize = MAX_PATHLEN - FileNameLen;
	DWORD	Idx = 0;

	do {
		WCHAR*	FormatStr;

		if(Idx <= 99) {
			FormatStr = L"%02u_%s";
		} else {
			FormatStr = L"%u_%s";
		}

		swprintf_s(FileName + FileNameLen, FileNameSize, FormatStr, Idx++, FileNameOnly);
	} while(::GetFileAttributes(FileName) != 0xffffffff);

	return ::CreateFile(
					FileName,
					GENERIC_WRITE,
					0,
					NULL,
					CREATE_ALWAYS,
					FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,
					NULL);
}

bool
preload_stream(int Size)
{
	while((strbuf_eof == false) && (strbufp_e < Size)) {
		::Sleep(20);
	}

	return !strbuf_eof;
}

/*
bool
read_stream_index(char* RetData, int ReadIdx)
{
	bool	RetCode;

	if((ReadIdx < strbuflen) && preload_stream(ReadIdx + 1)) {
		int		ReadPnt = strbufp_s + ReadIdx;

		if(ReadPnt >= strbuflen) ReadPnt -= strbuflen;

		*RetData = *(stream_buffer + ReadPnt);
		RetCode = true;
	} else {
		RetCode = false;
	}

	return RetCode;
}
*/

bool
read_stream_index(void* RetBuff, int ReadIdx, int Size)
{
	bool	RetCode;
	const int	MaxReadIdx = ReadIdx + Size;

	if(MaxReadIdx <= strbuflen) {
		read_stream_size = Min((MaxReadIdx / PRE_READ_STREAM_SIZE + 1) * PRE_READ_STREAM_SIZE,
								strbuflen);

		if(preload_stream(read_stream_size) == false) return false;

		::EnterCriticalSection(&CriticalSection);

		int		ReadPnt = strbufp_s + ReadIdx;

		if(ReadPnt >= strbuflen) ReadPnt -= strbuflen;

		const int	MaxCopySize = ReadPnt + Size;

		if(MaxCopySize <= strbuflen) {
			memcpy(RetBuff, stream_buffer + ReadPnt, Size);
		} else {
			const int	CopySize1 = strbuflen - ReadPnt;
			const int	CopySize2 = MaxCopySize - strbuflen;

			memcpy(RetBuff, stream_buffer + ReadPnt, CopySize1);
			memcpy(reinterpret_cast<char*>(RetBuff) + CopySize1, stream_buffer, CopySize2);
		}

		::LeaveCriticalSection(&CriticalSection);

		RetCode = true;
	} else {
		RetCode = false;
	}

	return RetCode;
}

int
read_stream_buffer(void* RetBuff, int Size)
{
	int		RetCode;

	if(Size <= strbuflen) {
		if(strbufp_e < MIN_STREAM_SIZE) preload_stream(Max(strbuflen / 16, MIN_STREAM_SIZE));

		::EnterCriticalSection(&CriticalSection);

		Size = Min(Size, strbufp_e);

		const int	MaxCopySize = strbufp_s + Size;

		if(MaxCopySize <= strbuflen) {
			memcpy(RetBuff, stream_buffer + strbufp_s, Size);
		} else {
			const int	CopySize1 = strbuflen - strbufp_s;
			const int	CopySize2 = MaxCopySize - strbuflen;

			memcpy(RetBuff, stream_buffer + strbufp_s, CopySize1);
			memcpy(reinterpret_cast<char*>(RetBuff) + CopySize1, stream_buffer, CopySize2);
		}

		strbufp_s = (MaxCopySize >= strbuflen) ? MaxCopySize - strbuflen : MaxCopySize;
		strbufp_e -= Size;

		if(prm->m_bSaveStream && Size) {
			if(stream_hF == INVALID_HANDLE_VALUE) stream_hF = OpenStreamFile();

			if(stream_hF != INVALID_HANDLE_VALUE) {
				DWORD	NumberOfBytesWritten;

				::WriteFile(stream_hF, RetBuff, Size, &NumberOfBytesWritten, NULL);
			}
		}

		::LeaveCriticalSection(&CriticalSection);

		RetCode = Size;
	} else {
		RetCode = 0;
	}

	return RetCode;
}

UINT __cdecl
ReceiveThread(LPVOID pParam)
{
	THREADPARAM*	p = reinterpret_cast<THREADPARAM*>(pParam);

	p->param->m_icy.GetIcyInfoFromHttpHeader(httpfile);

	m_StreamErrorMsg = "";

	strbuf_eof = false;
	strbufp_s = 0;
	strbufp_e = 0;

	::SetEvent(p->EventReadyThread);

	while(::WaitForSingleObject(p->EventDestroyThread, 0) != WAIT_OBJECT_0) {
		const int	ReceiveSize = Min(
									(read_stream_mode == READ_STREAM_MODE_MIN) ?
										Max(read_stream_size - strbufp_e, 0) : strbuflen - strbufp_e,
									READ_STREAM_SIZE);

		if(ReceiveSize) {
			char	ReceiveBuff[READ_STREAM_SIZE + 1 + 0xff * 16];
			UINT	Size = ReadStream(ReceiveBuff, ReceiveSize);

			if(Size == 0) break;

			char	StreamBuff[READ_STREAM_SIZE];
			bool	Error;

			Size = p->param->m_icy.GetICYInfo(
											StreamBuff,
											ReceiveBuff,
											Size,
											&Error,
											&m_StreamErrorMsg);

			if(Error) break;

			if(Size) {
				::EnterCriticalSection(&CriticalSection);

				int		WritePnt = strbufp_s + strbufp_e;

				if(WritePnt >= strbuflen) WritePnt -= strbuflen;

				const int	MaxCopySize = WritePnt + Size;

				if(MaxCopySize <= strbuflen) {
					memcpy(stream_buffer + WritePnt, StreamBuff, Size);
				} else {
					const int	CopySize1 = strbuflen - WritePnt;
					const int	CopySize2 = MaxCopySize - strbuflen;

					memcpy(stream_buffer + WritePnt, StreamBuff, CopySize1);
					memcpy(stream_buffer, StreamBuff + CopySize1, CopySize2);
				}

				strbufp_e += Size;

				::LeaveCriticalSection(&CriticalSection);
			}
		} else {
			::Sleep(20);
		}
	}

	strbuf_eof = true;

	return 0;
}

