
#include "stdafx.h"
#include <MMSystem.h>
//#include <mbctype.h>
//#include <mbstring.h>

#define	UNICODE_INPUT_PLUGIN

#include "IN2.H"
#include "wa_ipc.h"

#include "CommonFunc.h"

#include "in_mpg123.h"

#include "TagInfo.h"
#include "VbrTag.h"

bool	getmp3info(bool Decode, const WCHAR* fn, mp3info* info, VBRTAGDATA* vbr_tag);

const char*	GenreList[MAX_GENRE] =
{
	"Blues", "Classic Rock", "Country", "Dance", "Disco",
	"Funk", "Grunge", "Hip-Hop", "Jazz", "Metal",
	"New Age", "Oldies", "Other", "Pop", "R&B",
	"Rap", "Reggae", "Rock", "Techno", "Industrial",
	"Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack",
	"Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk",
	"Fusion", "Trance", "Classical", "Instrumental", "Acid",
	"House", "Game", "Sound Clip", "Gospel", "Noise",
	"AlternRock", "Bass", "Soul", "Punk", "Space",
	"Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic",
	"Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance",
	"Dream", "Southern Rock", "Comedy", "Cult", "Gangsta",
	"Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American",
	"Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes",
	"Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz",
	"Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock",
	"Folk", "Folk/Rock", "National Folk", "Swing", "Fast-Fusion",
	"Bebob", "Latin", "Revival", "Celtic", "Bluegrass",
	"Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock",
	"Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic",
	"Humour", "Speech", "Chanson", "Opera", "Chamber Music",
	"Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove",
	"Satire", "Slow Jam", "Club", "Tango", "Samba",
	"Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle",
	"Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House",
	"Dance Hall", "Goa", "Drum & Bass", "Club House", "Hardcore",
	"Terror", "Indie", "BritPop", "NegerPunk", "Polsk Punk",
	"Beat", "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover",
	"Contemporary C", "Christian Rock", "Merengue", "Salsa", "Thrash Metal",
	"Anime", "JPop", "SynthPop",
};

Tag::Tag(void)
{
	::InitializeCriticalSection(&CriticalSection);

	FlushCache();
}

Tag::~Tag(void)
{
	::DeleteCriticalSection(&CriticalSection);
}

void
Tag::FlushCache(void)
{
	::EnterCriticalSection(&CriticalSection);

	*Cache.TagInfo.FileName = L'\0';
	Cache.GetTagTime = 0;

	*CacheReplayGainInfo.ReplayGainInfo.FileName = L'\0';
	CacheReplayGainInfo.GetTagTime = 0;

	::LeaveCriticalSection(&CriticalSection);
}

bool
Tag::Get(WCHAR* Title, const WCHAR* Format, const int TagPriority, const WCHAR* FileName)
{
	bool	RetCode;
	_TagInfo	Info;

	wcscpy_s(Info.FileName, MAX_PATHLEN, FileName);

	if(RetCode = GetTitle(TagPriority, &Info)) DoFormat(Title, GETFILEINFO_TITLE_LENGTH, Format, &Info);

	return RetCode;
}

bool
Tag::GetReplayGainInfo(
					_ReplayGainInfo* Info,
					mp3info* mp3Info,
					const int TagPriority,
					const UINT ReplayGainTag,
					const WCHAR* FileName)
{
	if(ReplayGainTag & REPLAYGAIN_TAG_LAME) {
		Info->ValidTrackGain = mp3Info->replaygain_valid_track_gain;
		Info->ValidTrackPeak = mp3Info->replaygain_valid_track_peak;
		Info->ValidAlbumGain = mp3Info->replaygain_valid_album_gain;
		Info->ValidAlbumPeak = mp3Info->replaygain_valid_album_peak;
		Info->TrackGain = mp3Info->replaygain_track_gain;
		Info->TrackPeak = mp3Info->replaygain_track_peak;
		Info->AlbumGain = mp3Info->replaygain_album_gain;
		Info->AlbumPeak = mp3Info->replaygain_album_peak;
	} else {
		Info->ValidTrackGain = false;
		Info->ValidTrackPeak = false;
		Info->ValidAlbumGain = false;
		Info->ValidAlbumPeak = false;
	}

	bool	RetCode;
	const WCHAR*	ReplayGainFileName = FileName ? FileName : Info->FileName;

	switch(TagPriority) {
	case 0:
	case 1:
	case 4:
		RetCode =	((ReplayGainTag & REPLAYGAIN_TAG_ID3V2) ?
						GetTitleFromID3v2(NULL, Info, ReplayGainFileName) : false) ||
					((ReplayGainTag & REPLAYGAIN_TAG_APE) ?
						GetTitleFromAPE(NULL, Info, ReplayGainFileName) : false);
		break;
	case 2:
	case 3:
	case 5:
		RetCode =	((ReplayGainTag & REPLAYGAIN_TAG_APE) ?
						GetTitleFromAPE(NULL, Info, ReplayGainFileName) : false) ||
					((ReplayGainTag & REPLAYGAIN_TAG_ID3V2) ?
						GetTitleFromID3v2(NULL, Info, ReplayGainFileName) : false);
		break;
	}

	return RetCode || Info->ValidTrackGain || Info->ValidAlbumGain;
}

int
Tag::GetExtendedFileInfo(
					extendedFileInfoStructW* ExtendedFileInfo,
					const int TagPriority,
					const UINT ReplayGainTag)
{
	::EnterCriticalSection(&CriticalSection);

	int		RetCode;
	const char*	MetaData = reinterpret_cast<const char*>(ExtendedFileInfo->metadata);

	if(_stricmp(MetaData, "replaygain_track_gain") &&
			_stricmp(MetaData, "replaygain_track_peak") &&
			_stricmp(MetaData, "replaygain_album_gain") &&
			_stricmp(MetaData, "replaygain_album_peak") &&
			_stricmp(MetaData, "gain")) {
		RetCode = GetCache(ExtendedFileInfo, TagPriority);
	} else {
		RetCode = GetCacheReplayGainInfo(ExtendedFileInfo, TagPriority, ReplayGainTag);
	}

	::LeaveCriticalSection(&CriticalSection);

	return RetCode;
}

int
Tag::GetCache(extendedFileInfoStructW* ExtendedFileInfo, const int TagPriority)
{
	if(ExtendedFileInfo->retlen == 0) return 0;

	bool	FindTag = *ExtendedFileInfo->filename &&
						(wcscmp(ExtendedFileInfo->filename, Cache.TagInfo.FileName) == 0) &&
						((::timeGetTime() - Cache.GetTagTime) <= 2000);

	if(FindTag) {
		Cache.GetTagTime = ::timeGetTime();
	} else {
		mp3info	info;
		VBRTAGDATA	vbr_tag;

		if(wcsncmp(ExtendedFileInfo->filename, L"http://", 7) &&
				wcsncmp(ExtendedFileInfo->filename, L"https://", 8) &&
				getmp3info(false, ExtendedFileInfo->filename, &info, &vbr_tag)) {
			WCHAR	BackFileName[MAX_PATHLEN];

			wcscpy_s(BackFileName, MAX_PATHLEN, Cache.TagInfo.FileName);
			wcscpy_s(Cache.TagInfo.FileName, MAX_PATHLEN, ExtendedFileInfo->filename);

			if(FindTag = GetTitle(TagPriority, &Cache.TagInfo)) {
				Cache.TagInfo.Length = info.length;
				Cache.GetTagTime = ::timeGetTime();
			} else {
				wcscpy_s(Cache.TagInfo.FileName, MAX_PATHLEN, BackFileName);
			}
		}
	}

	int		RetCode;

	if(FindTag) {
		WCHAR	Buff[16];
		WCHAR*	RetBuff;
//		const WCHAR*	MetaData = ExtendedFileInfo->metadata;
		const char*	MetaData = reinterpret_cast<const char*>(ExtendedFileInfo->metadata);

//		if(_wcsicmp(MetaData, L"length") == 0) {
		if(_stricmp(MetaData, "length") == 0) {
			_itow_s(Cache.TagInfo.Length, Buff, 16, 10);
			RetBuff = Buff;
			RetCode = 1;
//		} else if(_wcsicmp(MetaData, L"title") == 0) {
		} else if(_stricmp(MetaData, "title") == 0) {
			RetBuff = Cache.TagInfo.Title;
			RetCode = 1;
//		} else if(_wcsicmp(MetaData, L"artist") == 0) {
		} else if(_stricmp(MetaData, "artist") == 0) {
			RetBuff = Cache.TagInfo.Artist;
			RetCode = 1;
//		} else if(_wcsicmp(MetaData, L"album") == 0) {
		} else if(_stricmp(MetaData, "album") == 0) {
			RetBuff = Cache.TagInfo.Album;
			RetCode = 1;
//		} else if(_wcsicmp(MetaData, L"year") == 0) {
		} else if(_stricmp(MetaData, "year") == 0) {
			RetBuff = Cache.TagInfo.Year;
			RetCode = 1;
//		} else if(_wcsicmp(MetaData, L"comment") == 0) {
		} else if(_stricmp(MetaData, "comment") == 0) {
			RetBuff = Cache.TagInfo.Comment;
			RetCode = 1;
//		} else if(_wcsicmp(MetaData, L"genre") == 0) {
		} else if(_stricmp(MetaData, "genre") == 0) {
			RetBuff = Cache.TagInfo.Genre;
			RetCode = 1;
//		} else if(_wcsicmp(MetaData, L"track") == 0) {
		} else if(_stricmp(MetaData, "track") == 0) {
			RetBuff = Cache.TagInfo.Track;
			RetCode = 1;
//		} else if(_wcsicmp(MetaData, L"encoder") == 0) {
		} else if(_stricmp(MetaData, "encoder") == 0) {
			RetBuff = Cache.TagInfo.Encoder;
			RetCode = 1;
		} else {
			RetCode = 0;
		}

		if(RetCode) Strncpy(ExtendedFileInfo->ret, RetBuff, ExtendedFileInfo->retlen - 1);
	} else {
		RetCode = 0;
	}

	return RetCode;
}

int
Tag::GetCacheReplayGainInfo(
						extendedFileInfoStructW* ExtendedFileInfo,
						const int TagPriority,
						const UINT ReplayGainTag)
{
	if(ExtendedFileInfo->retlen == 0) return 0;

	bool	FindTag = *ExtendedFileInfo->filename &&
						(wcscmp(
							ExtendedFileInfo->filename,
							CacheReplayGainInfo.ReplayGainInfo.FileName) == 0) &&
						((::timeGetTime() - CacheReplayGainInfo.GetTagTime) <= 2000);

	if(FindTag) {
		CacheReplayGainInfo.GetTagTime = ::timeGetTime();
	} else {
		mp3info	info;
		VBRTAGDATA	vbr_tag;

		if(wcsncmp(ExtendedFileInfo->filename, L"http://", 7) &&
				wcsncmp(ExtendedFileInfo->filename, L"https://", 8) &&
				getmp3info(false, ExtendedFileInfo->filename, &info, &vbr_tag)) {
			_ReplayGainInfo	BackReplayGainInfo;

			memcpy(&BackReplayGainInfo, &CacheReplayGainInfo.ReplayGainInfo, sizeof BackReplayGainInfo);
			wcscpy_s(
				CacheReplayGainInfo.ReplayGainInfo.FileName,
				MAX_PATHLEN,
				ExtendedFileInfo->filename);

			if(FindTag = GetReplayGainInfo(
										&CacheReplayGainInfo.ReplayGainInfo,
										&info,
										TagPriority,
										ReplayGainTag)) {
				CacheReplayGainInfo.GetTagTime = ::timeGetTime();
			} else {
				memcpy(
					&CacheReplayGainInfo.ReplayGainInfo,
					&BackReplayGainInfo,
					sizeof CacheReplayGainInfo.ReplayGainInfo);
			}
		}
	}

	if(FindTag) {
		WCHAR	Buff[32];
		WCHAR*	RetBuff;
//		const WCHAR*	MetaData = ExtendedFileInfo->metadata;
		const char*	MetaData = reinterpret_cast<const char*>(ExtendedFileInfo->metadata);

//		if(_wcsicmp(MetaData, L"replaygain_track_gain") == 0) {
		if(_stricmp(MetaData, "replaygain_track_gain") == 0) {
			if(CacheReplayGainInfo.ReplayGainInfo.ValidTrackGain) {
				swprintf_s(Buff, 32, L"%g dB", CacheReplayGainInfo.ReplayGainInfo.TrackGain);
				RetBuff = Buff;
			} else {
				RetBuff = L"";
			}
//		} else if(_wcsicmp(MetaData, L"replaygain_track_peak") == 0) {
		} else if(_stricmp(MetaData, "replaygain_track_peak") == 0) {
			if(CacheReplayGainInfo.ReplayGainInfo.ValidTrackPeak) {
				swprintf_s(Buff, 32, L"%g", CacheReplayGainInfo.ReplayGainInfo.TrackPeak);
				RetBuff = Buff;
			} else {
				RetBuff = L"";
			}
//		} else if(_wcsicmp(MetaData, L"replaygain_album_gain") == 0) {
		} else if(_stricmp(MetaData, "replaygain_album_gain") == 0) {
			if(CacheReplayGainInfo.ReplayGainInfo.ValidAlbumGain) {
				swprintf_s(Buff, 32, L"%g dB", CacheReplayGainInfo.ReplayGainInfo.AlbumGain);
				RetBuff = Buff;
			} else {
				RetBuff = L"";
			}
//		} else if(_wcsicmp(MetaData, L"replaygain_album_peak") == 0) {
		} else if(_stricmp(MetaData, "replaygain_album_peak") == 0) {
			if(CacheReplayGainInfo.ReplayGainInfo.ValidAlbumPeak) {
				swprintf_s(Buff, 32, L"%g", CacheReplayGainInfo.ReplayGainInfo.AlbumPeak);
				RetBuff = Buff;
			} else {
				RetBuff = L"";
			}
//		} else if(_wcsicmp(MetaData, L"gain") == 0) {
		} else if(_stricmp(MetaData, "gain") == 0) {
			RetBuff = L"";
		}

		Strncpy(ExtendedFileInfo->ret, RetBuff, ExtendedFileInfo->retlen - 1);
	} else {
		*ExtendedFileInfo->ret = L'\0';
	}

	return 1;
}

bool
Tag::GetTitle(const int TagPriority, _TagInfo* Info)
{
	bool	RetCode;

	switch(TagPriority) {
	case 0:
		RetCode = GetTitleFromID3v2(Info) || GetTitleFromAPE(Info) || GetTitleFromID3v1(Info);
		break;
	case 1:
		RetCode = GetTitleFromID3v2(Info) || GetTitleFromID3v1(Info) || GetTitleFromAPE(Info);
		break;
	case 2:
		RetCode = GetTitleFromAPE(Info) || GetTitleFromID3v2(Info) || GetTitleFromID3v1(Info);
		break;
	case 3:
		RetCode = GetTitleFromAPE(Info) || GetTitleFromID3v1(Info) || GetTitleFromID3v2(Info);
		break;
	case 4:
		RetCode = GetTitleFromID3v1(Info) || GetTitleFromID3v2(Info) || GetTitleFromAPE(Info);
		break;
	case 5:
		RetCode = GetTitleFromID3v1(Info) || GetTitleFromAPE(Info) || GetTitleFromID3v2(Info);
		break;
	}

	return RetCode;
}

void
Tag::StoreReplayGainInfo(_ReplayGainInfo* Info, const int ReplayGainFieldName, WCHAR* Buff)
{
	if((ReplayGainFieldName == REPLAYGAIN_TRACK_GAIN) ||
			(ReplayGainFieldName == REPLAYGAIN_ALBUM_GAIN)) {
		WCHAR*	dB = wcsstr(Buff, L" dB");

		if(dB) *dB = L'\0';
	}

	const double	GainPeak = _wtof(Buff);

	switch(ReplayGainFieldName) {
	case REPLAYGAIN_TRACK_GAIN:
		Info->ValidTrackGain = true;
		Info->TrackGain = GainPeak;
		break;
	case REPLAYGAIN_TRACK_PEAK:
		Info->ValidTrackPeak = true;
		Info->TrackPeak = GainPeak;
		break;
	case REPLAYGAIN_ALBUM_GAIN:
		Info->ValidAlbumGain = true;
		Info->AlbumGain = GainPeak;
		break;
	case REPLAYGAIN_ALBUM_PEAK:
		Info->ValidAlbumPeak = true;
		Info->AlbumPeak = GainPeak;
		break;
	}
}

void
Tag::DoFormat(WCHAR* Title, const size_t TitleSize, const WCHAR* Format, const _TagInfo* Info)
{
	WCHAR*	MaxTitle = Title + TitleSize;
	WCHAR	Str;
	const int	MaxBlock = 8;
	int		BlockIdx = -1;
	WCHAR*	Block[MaxBlock];
	size_t	MaxReplaceSize[MaxBlock];

	for(; (Str = *Format) != L'\0'; Format++) {
		if(Str == L'[') {
			if(++BlockIdx == MaxBlock) break;
			Block[BlockIdx] = Title;
			MaxReplaceSize[BlockIdx] = 0;
			continue;
		} else if(Str == L']') {
			if(BlockIdx == -1) break;
			if(MaxReplaceSize[BlockIdx] == 0) Title = Block[BlockIdx];
			BlockIdx--;
			continue;
		} else if(Str == L'%') {
			const WCHAR*	CommandPnt = Format + 1;

			if(*CommandPnt == L'%') {
				Format++;
				if(Title < MaxTitle) *Title++ = L'%';
			} else if(*CommandPnt == L'[') {
				Format++;
				if(Title < MaxTitle) *Title++ = L'[';
			} else if(*CommandPnt == L']') {
				Format++;
				if(Title < MaxTitle) *Title++ = L']';
			} else {
				const int	CommandLen = KanjiStrChr(CommandPnt, L'%');

				if(CommandLen == -1) break;

				WCHAR	Command[MAX_FORMATTEXT];

				memcpy(Command, CommandPnt, CommandLen * sizeof WCHAR);
				*(Command + CommandLen) = L'\0';

				Format += 1 + CommandLen;

				const size_t	TitleRemainSize = MaxTitle - Title;
				errno_t	Error;

				if(_wcsicmp(Command, L"title") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->Title);
				} else if(_wcsicmp(Command, L"artist") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->Artist);
				} else if(_wcsicmp(Command, L"album") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->Album);
				} else if(_wcsicmp(Command, L"year") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->Year);
				} else if(_wcsicmp(Command, L"comment") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->Comment);
				} else if(_wcsicmp(Command, L"genre") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->Genre);
				} else if(_wcsicmp(Command, L"filename") == 0) {
					if(Title < MaxTitle) {
						WCHAR	Name[MAX_PATHLEN];

						CutPathFileName(Info->FileName, NULL, 0, Name, MAX_PATHLEN);
						*Title = L'\0';
						CutFileNameExt(Name, Title, TitleRemainSize);
						Error = 0;
					} else {
						Error = 1;
					}
				} else if(_wcsicmp(Command, L"filepath") == 0) {
					if(Title < MaxTitle) {
						*Title = L'\0';
						CutPathFileName(Info->FileName, Title, TitleRemainSize);
						Error = 0;
					} else {
						Error = 1;
					}
				} else if(_wcsicmp(Command, L"fileext") == 0) {
					if(Title < MaxTitle) {
						*Title = L'\0';
						CutFileNameExt(Info->FileName, NULL, 0, Title, TitleRemainSize);
						Error = 0;
					} else {
						Error = 1;
					}
				} else if(_wcsicmp(Command, L"track") == 0) {
					if(Title < MaxTitle) {
						*Title = L'\0';

						if(*Info->Track) {
							FormatItow(_wtoi(Info->Track), Title, TitleRemainSize, 2, L'0');
						}

						Error = 0;
					} else {
						Error = 1;
					}
				} else if(_wcsicmp(Command, L"composer") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->Composer);
				} else if(_wcsicmp(Command, L"origartist") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->OrgArtist);
				} else if(_wcsicmp(Command, L"copyright") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->Copyright);
				} else if(_wcsicmp(Command, L"encoder") == 0) {
					Error = wcscpy_s(Title, TitleRemainSize, Info->Encoder);
				} else {
					Error = 1;
				}

				if(Error == 0) {
					const size_t	ReplaceSize = wcslen(Title);

					Title += ReplaceSize;

					for(int Idx = 0; Idx <= BlockIdx; Idx++) {
						MaxReplaceSize[Idx] = Max(ReplaceSize, MaxReplaceSize[Idx]);
					}
				}
			}

			continue;
		}

		if(Title < MaxTitle) *Title++ = Str;
	}

	if(Title < MaxTitle) {
		*Title = L'\0';
	} else {
		*(MaxTitle - 1) = L'\0';
	}
}

