// StreamingDialog.cpp : Cve[V t@C
//

#include "stdafx.h"

#include "CommonFunc.h"

#include "in_mpg123.h"

#include "HttpFile.h"
#include "ICYInfo.h"

#include "Param.h"
#include "StreamingDialog.h"
#include "PropertySheet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStreamingDialog vpeB y[W

IMPLEMENT_DYNCREATE(CStreamingDialog, CPropertyPage)

CStreamingDialog::CStreamingDialog() : CPropertyPage(CStreamingDialog::IDD)
{

	//{{AFX_DATA_INIT(CStreamingDialog)
	m_bEnableStreaming = false;
	m_strBufferLength = _T("");
	m_strProxy = _T("");
	m_strSaveStream = _T("");
	m_strTitleStreamingFormat = _T("");
	m_bProxy = false;
	m_bSaveStream = false;
	m_bTitleStreaming = false;
	m_bTitleStreamingUDP = false;
	//}}AFX_DATA_INIT

}

CStreamingDialog::~CStreamingDialog()
{
}

void CStreamingDialog::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStreamingDialog)
	DDX_Check(pDX, IDC_CH_ENABLE_STREAMING, m_bEnableStreaming);
	DDX_Control(pDX, IDC_COMBO_PRIORITY, m_comboReceivePriority);
	DDX_Text(pDX, IDC_ED_STRBUF, m_strBufferLength);
	DDX_Control(pDX, IDC_ED_TITLESTREAMING_FORMAT, m_editTitleStreamingFormat);
	DDX_Control(pDX, IDC_TITLESTREAMING_UDP, m_buttonTitleStreamingUDP);
	DDX_Control(pDX, IDC_BUTTON_FILEDIALOG, m_buttonFileDialog);
	DDX_Control(pDX, IDC_ED_PROXY, m_editProxy);
	DDX_Control(pDX, IDC_ED_STRBUF, m_editBufferLength);
	DDX_Control(pDX, IDC_ED_SAVESTREAM, m_editSaveStream);
	DDX_Text(pDX, IDC_ED_PROXY, m_strProxy);
	DDX_Text(pDX, IDC_ED_SAVESTREAM, m_strSaveStream);
	DDX_Text(pDX, IDC_ED_TITLESTREAMING_FORMAT, m_strTitleStreamingFormat);
	DDX_Check(pDX, IDC_PROXY, m_bProxy);
	DDX_Check(pDX, IDC_SAVESTREAM, m_bSaveStream);
	DDX_Check(pDX, IDC_TITLESTREAMING, m_bTitleStreaming);
	DDX_Check(pDX, IDC_TITLESTREAMING_UDP, m_bTitleStreamingUDP);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CStreamingDialog, CPropertyPage)
	//{{AFX_MSG_MAP(CStreamingDialog)
	ON_BN_CLICKED(IDC_CH_ENABLE_STREAMING, OnEnableStreaming)
	ON_CBN_SELCHANGE(IDC_COMBO_PRIORITY, OnSelchangeComboPriority)
	ON_EN_CHANGE(IDC_ED_STRBUF, OnChangeEdStrbuf)
	ON_EN_KILLFOCUS(IDC_ED_STRBUF, OnKillfocusEdStrbuf)
	ON_BN_CLICKED(IDC_BUTTON_FILEDIALOG, OnButtonFiledialog)
	ON_BN_CLICKED(IDC_SAVESTREAM, OnSavestream)
	ON_BN_CLICKED(IDC_TITLESTREAMING, OnTitlestreaming)
	ON_BN_CLICKED(IDC_PROXY, OnProxy)
	ON_EN_CHANGE(IDC_ED_PROXY, OnChangeEdProxy)
	ON_BN_CLICKED(IDC_TITLESTREAMING_UDP, OnTitlestreamingUdp)
	ON_EN_CHANGE(IDC_ED_SAVESTREAM, OnChangeEdSavestream)
	ON_EN_CHANGE(IDC_ED_TITLESTREAMING_FORMAT, OnChangeEdTitlestreamingFormat)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStreamingDialog bZ[W nh

void CStreamingDialog::OnOK() 
{
	bool	bFlag = false;

	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();

	pr->m_bEnableStreaming = m_bEnableStreaming != 0;

	if(pr->m_nReceiveThreadPriority != m_comboReceivePriority.GetCurSel()) {
		pr->m_nReceiveThreadPriority = m_comboReceivePriority.GetCurSel();
		bFlag = true;
	}

	pr->m_nBufferLength = Max(_wtoi((LPCTSTR)m_strBufferLength), MIN_STREAM_SIZE / 1024);
	pr->m_strProxy = m_strProxy;
	pr->m_strSaveStream = m_strSaveStream;
	pr->m_strTitleStreamingFormat = m_strTitleStreamingFormat;
	pr->m_bProxy = m_bProxy != 0;
	pr->m_bSaveStream = m_bSaveStream != 0;
	pr->m_bTitleStreaming = m_bTitleStreaming != 0;
	pr->m_bTitleStreamingUDP = m_bTitleStreamingUDP != 0;

	/* activeIndex 擾 */
	CIn_mpg123dPropertySheet* pSheet = (CIn_mpg123dPropertySheet*)GetParent();
	pr->m_nStartPage = pSheet->GetActiveIndex();
	pSheet->ReflectSetting(bFlag);

	CPropertyPage::OnOK();
}

void CStreamingDialog::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	
	CPropertyPage::OnCancel();
}

void CStreamingDialog::OnKillfocusEdStrbuf() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ

	CString str;
	
	str = m_strBufferLength;

	UpdateData();

	int l;
	l = _wtoi((LPCTSTR)m_strBufferLength);
	if (l <= 0) {
		m_editBufferLength.SetWindowText(str);
	}
}

BOOL CStreamingDialog::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ

	if(!m_bProxy) {
		m_editProxy.EnableWindow(FALSE);
	} else {
		m_editProxy.EnableWindow(TRUE);
	}

	if(!m_bSaveStream) {
		m_editSaveStream.EnableWindow(FALSE);
		m_buttonFileDialog.EnableWindow(FALSE);
	} else {
		m_editSaveStream.EnableWindow(TRUE);
		m_buttonFileDialog.EnableWindow(TRUE);
	}

	if(!m_bTitleStreaming) {
		m_buttonTitleStreamingUDP.EnableWindow(FALSE);
//		m_editTitleStreamingFormat.EnableWindow(FALSE);
	} else {
		m_buttonTitleStreamingUDP.EnableWindow(TRUE);
//		m_editTitleStreamingFormat.EnableWindow(TRUE);
	}
	
	m_comboReceivePriority.SetCurSel(pr->m_nReceiveThreadPriority);

	UpdateData(FALSE);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CStreamingDialog::OnButtonFiledialog() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();

	CString str;

	str.LoadString(IDS_SAVESTREAMDLG);
	UpdateData();

	CFileDialog FileDialog(
		FALSE,
		L"*.mp3",
		L"notitle.mp3",
		OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,
		str,
		this,
		0
	);

	//FileDialog.m_ofn.lpstrTitle = pTitle;
	//FileDialog.m_ofn.lpstrInitialDir = pFileName;
	UpdateData();
	if (FileDialog.DoModal() == IDOK ) {
		m_editSaveStream.SetWindowText(FileDialog.GetPathName());
	}
}

void CStreamingDialog::SetParam()
{
	CString tmp;

	m_bEnableStreaming = pr->m_bEnableStreaming;
	m_strProxy = pr->m_strProxy;
	m_strSaveStream = pr->m_strSaveStream;
	tmp.Format(L"%d", pr->m_nBufferLength);
	m_strBufferLength = tmp;
	m_strTitleStreamingFormat = pr->m_strTitleStreamingFormat;
	m_bProxy = pr->m_bProxy;
	m_bSaveStream = pr->m_bSaveStream;
	m_bTitleStreaming = pr->m_bTitleStreaming;
	m_bTitleStreamingUDP = pr->m_bTitleStreamingUDP;

}

void CStreamingDialog::OnEnableStreaming() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CStreamingDialog::OnSelchangeComboPriority() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CStreamingDialog::OnChangeEdStrbuf() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_CHANGE tOt CRichEditCrtl().SetEventMask()
	// bZ[WRg[֑邽߂ CPropertyPage::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CStreamingDialog::OnSavestream() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
	UpdateData();
	if(!m_bSaveStream) {
		m_editSaveStream.EnableWindow(FALSE);
		m_buttonFileDialog.EnableWindow(FALSE);
	} else {
		m_editSaveStream.EnableWindow(TRUE);
		m_buttonFileDialog.EnableWindow(TRUE);
	}
	
}

void CStreamingDialog::OnTitlestreaming() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();

	UpdateData();
	if(!m_bTitleStreaming) {
		m_buttonTitleStreamingUDP.EnableWindow(FALSE);
//		m_editTitleStreamingFormat.EnableWindow(FALSE);
	} else {
		m_buttonTitleStreamingUDP.EnableWindow(TRUE);
//		m_editTitleStreamingFormat.EnableWindow(TRUE);
	}
	
}

void CStreamingDialog::OnProxy() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();

	UpdateData();
	if(!m_bProxy) {
		m_editProxy.EnableWindow(FALSE);
	} else {
		m_editProxy.EnableWindow(TRUE);
	}
	
}

void CStreamingDialog::OnChangeEdProxy() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_CHANGE tOt CRichEditCrtl().SetEventMask()
	// bZ[WRg[֑邽߂ CPropertyPage::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CStreamingDialog::OnTitlestreamingUdp() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CStreamingDialog::OnChangeEdSavestream() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_CHANGE tOt CRichEditCrtl().SetEventMask()
	// bZ[WRg[֑邽߂ CPropertyPage::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CStreamingDialog::OnChangeEdTitlestreamingFormat() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_CHANGE tOt CRichEditCrtl().SetEventMask()
	// bZ[WRg[֑邽߂ CPropertyPage::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

