// In_mpg123dParam.cpp: CIn_mpg123dParam NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "CommonFunc.h"

#include "in_mpg123.h"

#include "HttpFile.h"
#include "ICYInfo.h"

#include "Param.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CIn_mpg123dParam::CIn_mpg123dParam()
{
	// Initialize members

	m_nStartPage					= 0;

	m_bEnable						= true;
	m_nDecodeThreadPriority			= 2 /* THREAD_PRIORITY_HIGHEST */;
	m_nOutputBps					= 16;
	m_bSupZero						= false;
	m_bDispAvg						= false;
	m_bAltVolume					= false;
	m_bReverseLR					= false;
	m_bReversePhase					= false;
	m_bFullBuffering				= false;

	m_nVolume						= 255;
	m_nPan							= 0;

	m_bReplayGainEnable				= false;
	m_nReplayGainMode				= 0;
	m_nReplayGainTag				= REPLAYGAIN_TAG_INIT;
	m_nReplayGainPreAmpWithRG		= 0;
	m_nReplayGainPreAmpWithoutRG	= 0;
	m_bReplayGainHardLimit			= true;

	m_bEnableStreaming				= false;
	m_nReceiveThreadPriority		= 2;
	m_nBufferLength					= 256;
	m_bProxy						= false;
	m_strProxy						= L"";
	m_bSaveStream					= false;
	m_strSaveStream					= L"";
	m_bTitleStreaming				= true;
	m_bTitleStreamingUDP			= false;
	m_strTitleStreamingFormat		= L"%1 (%2)";

	m_nTagPriority					= 0;
	m_strID3Format					= L"%1 - %2";
	m_strSIFFormat					= L"%IART - %INAM";
}

CIn_mpg123dParam::~CIn_mpg123dParam()
{
	WriteProfile();
}

void CIn_mpg123dParam::GetIniFn(HMODULE hDllInstance)
{
	WCHAR	FileName[MAX_PATHLEN];

	::GetModuleFileName(hDllInstance, FileName, MAX_PATHLEN);
	CutPathFileName(FileName, ini_file, NULL);
	wcscat_s(ini_file, MAX_PATHLEN, L"plugin.ini");
}

void CIn_mpg123dParam::GetProfile(void)
{

	WCHAR buf[MAX_PATHLEN];
	static const WCHAR szAppName[] = L"Shibatch mpg123";

	m_bEnable = ::GetPrivateProfileInt(szAppName, L"Enable", 1, ini_file) != 0;
	m_nDecodeThreadPriority = ::GetPrivateProfileInt(szAppName, L"DecodePriority", 2, ini_file);
	m_nOutputBps = ::GetPrivateProfileInt(szAppName, L"OutputFormat", 16, ini_file);
	m_bFullBuffering = ::GetPrivateProfileInt(szAppName, L"FullBuffering", 0, ini_file) != 0;
	m_bSupZero = ::GetPrivateProfileInt(szAppName, L"SupZero", 0, ini_file) != 0;
	m_bReverseLR = ::GetPrivateProfileInt(szAppName, L"ReverseLR", 0, ini_file) != 0;
	m_bReversePhase = ::GetPrivateProfileInt(szAppName, L"ReversePhase", 0, ini_file) != 0;
	m_bAltVolume = ::GetPrivateProfileInt(szAppName, L"Volume", 0, ini_file) != 0;
	m_bDispAvg = ::GetPrivateProfileInt(szAppName, L"DispAvg", 0, ini_file) != 0;

	if(m_nOutputBps == 64) m_nOutputBps = -64;

	m_bPostProc = m_bReverseLR || m_bReversePhase || m_bAltVolume;

	m_nVolume = ::GetPrivateProfileInt(szAppName, L"XVolume", 255, ini_file);
	m_nPan = ::GetPrivateProfileInt(szAppName, L"XPan", 0, ini_file);

	m_bReplayGainEnable = ::GetPrivateProfileInt(szAppName, L"ReplayGain_Enable", 0, ini_file) != 0;
	m_nReplayGainMode = ::GetPrivateProfileInt(szAppName, L"ReplayGain_Mode", 0, ini_file);
	m_nReplayGainTag = ::GetPrivateProfileInt(
											szAppName,
											L"ReplayGain_Tag",
											REPLAYGAIN_TAG_INIT,
											ini_file);
	m_nReplayGainPreAmpWithRG = ::GetPrivateProfileInt(
													szAppName,
													L"ReplayGain_PreAmp_WithRG",
													0,
													ini_file);
	m_nReplayGainPreAmpWithoutRG = ::GetPrivateProfileInt(
														szAppName,
														L"ReplayGain_PreAmp_WithoutRG",
														0,
														ini_file);
	m_bReplayGainHardLimit = ::GetPrivateProfileInt(
												szAppName,
												L"ReplayGain_HardLimit",
												1,
												ini_file) != 0;

	m_bEnableStreaming = ::GetPrivateProfileInt(szAppName, L"EnableStreaming", 0, ini_file) != 0;
	m_nReceiveThreadPriority = ::GetPrivateProfileInt(szAppName, L"ReceivePriority", 2, ini_file);
	m_nBufferLength = Max((int)GetPrivateProfileInt(szAppName, L"StrBuf", 256, ini_file),
							MIN_STREAM_SIZE / 1024);
	m_bProxy = ::GetPrivateProfileInt(szAppName, L"EnableProxy", 0, ini_file) != 0;
	m_bSaveStream = ::GetPrivateProfileInt(szAppName, L"SaveStream", 0, ini_file) != 0;
	m_bTitleStreaming = ::GetPrivateProfileInt(szAppName, L"TitleStreaming", 1, ini_file) != 0;
	m_bTitleStreamingUDP = ::GetPrivateProfileInt(szAppName, L"UseUDP", 0, ini_file) != 0;

	::GetPrivateProfileString(szAppName, L"Proxy", L"", buf, MAX_PATHLEN, ini_file);
	m_strProxy = buf;
	::GetPrivateProfileString(szAppName, L"SaveStreamFile", L"", buf, MAX_PATHLEN, ini_file);
	m_strSaveStream = buf;
	::GetPrivateProfileString(
							szAppName,
							L"TitleStreamingFormat",
							L"%1 (%2)",
							buf,
							MAX_PATHLEN,
							ini_file);
	m_strTitleStreamingFormat = buf;

	::GetPrivateProfileString(
							szAppName,
							L"FormatEx",
							L"[%artist% - ]%title%",
							buf,
							MAX_PATHLEN,
							ini_file);
	m_strID3Format = buf;
	::GetPrivateProfileString(szAppName, L"SIFFormat", L"%IART - %INAM", buf, MAX_PATHLEN, ini_file);
	m_strSIFFormat = buf;

	m_nTagPriority = ::GetPrivateProfileInt(szAppName, L"TagPriority", 0, ini_file);
}

void CIn_mpg123dParam::WriteProfile(void)
{
	WCHAR string[32];
	static const WCHAR szAppName[] = L"Shibatch mpg123";

	_itow_s(m_bEnable, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"Enable", string, ini_file);

	_itow_s(m_nDecodeThreadPriority, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"DecodePriority", string, ini_file);

	_itow_s(m_nOutputBps, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"OutputFormat", string, ini_file);

	_itow_s(m_bFullBuffering, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"FullBuffering", string, ini_file);

	_itow_s(m_bSupZero, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"SupZero", string, ini_file);

	_itow_s(m_bReverseLR, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"ReverseLR", string, ini_file);

	_itow_s(m_bReversePhase, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"ReversePhase", string, ini_file);

	_itow_s(m_bAltVolume, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"Volume", string, ini_file);

	_itow_s(m_bDispAvg, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"DispAvg", string, ini_file);

	_itow_s(m_nVolume, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"XVolume", string, ini_file);

	_itow_s(m_nPan, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"XPan", string, ini_file);

	_itow_s(m_bReplayGainEnable, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"ReplayGain_Enable", string, ini_file);

	_itow_s(m_nReplayGainMode, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"ReplayGain_Mode", string, ini_file);

	_itow_s(m_nReplayGainTag, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"ReplayGain_Tag", string, ini_file);

	_itow_s(m_nReplayGainPreAmpWithRG, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"ReplayGain_PreAmp_WithRG", string, ini_file);

	_itow_s(m_nReplayGainPreAmpWithoutRG, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"ReplayGain_PreAmp_WithoutRG", string, ini_file);

	_itow_s(m_bReplayGainHardLimit, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"ReplayGain_HardLimit", string, ini_file);

	_itow_s(m_bEnableStreaming, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"EnableStreaming", string, ini_file);

	_itow_s(m_nReceiveThreadPriority, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"ReceivePriority", string, ini_file);

	_itow_s(m_nBufferLength, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"StrBuf", string, ini_file);

	_itow_s(m_bProxy, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"EnableProxy", string, ini_file);

	_itow_s(m_bSaveStream, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"SaveStream", string, ini_file);

	_itow_s(m_bTitleStreaming, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"TitleStreaming", string, ini_file);

	_itow_s(m_bTitleStreamingUDP, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"UseUDP", string, ini_file);

	::WritePrivateProfileString(szAppName, L"Proxy", (LPCTSTR)m_strProxy, ini_file);
	::WritePrivateProfileString(szAppName, L"SaveStreamFile", (LPCTSTR)m_strSaveStream, ini_file);
	::WritePrivateProfileString(
							szAppName,
							L"TitleStreamingFormat",
							(LPCTSTR)m_strTitleStreamingFormat,
							ini_file);

	::WritePrivateProfileString(szAppName, L"FormatEx", (LPCTSTR)m_strID3Format, ini_file);
	::WritePrivateProfileString(szAppName, L"SIFFormat", (LPCTSTR)m_strSIFFormat, ini_file);

	_itow_s(m_nTagPriority, string, 32, 10);
	::WritePrivateProfileString(szAppName, L"TagPriority", string, ini_file);

}

int CIn_mpg123dParam::GetPriorityValue(int n)
{
	int		ret;

	switch(n) {
	case 0:
		ret = THREAD_PRIORITY_NORMAL;
		break;
	case 1:
		ret = THREAD_PRIORITY_ABOVE_NORMAL;
		break;
	default:
		ret = THREAD_PRIORITY_HIGHEST;
		break;
	}

	return ret;
}

