// ConfigDialog.cpp : Cve[V t@C
//

#include "stdafx.h"

#include "wa_ipc.h"

#include "in_mpg123.h"

#include "HttpFile.h"
#include "ICYInfo.h"

#include "Param.h"
#include "ConfigDialog.h"
#include "PropertySheet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const int	List_Bps[] =
{16, 24, 32, -32, -64};

/////////////////////////////////////////////////////////////////////////////
// CConfigDialog _CAO

IMPLEMENT_DYNCREATE(CConfigDialog, CPropertyPage)

CConfigDialog::CConfigDialog() : CPropertyPage(CConfigDialog::IDD)
{
	//{{AFX_DATA_INIT(CConfigDialog)
	m_bEnable = false;
	m_bFullBuffering = false;
	m_bSupZero = false;
	m_bReverseLR = false;
	m_bReversePhase = false;
	m_bAltVolume = false;
	m_bDispAvg = false;
	//}}AFX_DATA_INIT
}

void CConfigDialog::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigDialog)
	DDX_Control(pDX, IDC_COMBO_DECODER_PRIORITY, m_comboDecodePriority);
	DDX_Control(pDX, IDC_COMBO_OUTPUTBPS, m_comboOutputBps);
	DDX_Check(pDX, IDC_CH_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CH_FULLBUFFERING, m_bFullBuffering);
	DDX_Check(pDX, IDC_CH_SUPZERO, m_bSupZero);
	DDX_Check(pDX, IDC_CH_REVERSE_LR, m_bReverseLR);
	DDX_Check(pDX, IDC_CH_REVERSE_PHASE, m_bReversePhase);
	DDX_Check(pDX, IDC_CH_VOLUME, m_bAltVolume);
	DDX_Check(pDX, IDC_CH_DISPAVG, m_bDispAvg);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CConfigDialog, CPropertyPage)
	//{{AFX_MSG_MAP(CConfigDialog)
	ON_CBN_SELCHANGE(IDC_COMBO_DECODER_PRIORITY, OnCbnSelchangeComboDecoderPriority)
	ON_CBN_SELCHANGE(IDC_COMBO_OUTPUTBPS, OnCbnSelchangeComboOutputbps)
	ON_BN_CLICKED(IDC_CH_ENABLE, OnChEnable)
	ON_BN_CLICKED(IDC_CH_FULLBUFFERING, OnChFullBuffering)
	ON_BN_CLICKED(IDC_CH_SUPZERO, OnChSupzero)
	ON_BN_CLICKED(IDC_CH_REVERSE_LR, OnChReverseLR)
	ON_BN_CLICKED(IDC_CH_REVERSE_PHASE, OnChReversePhase)
	ON_BN_CLICKED(IDC_CH_VOLUME, OnChVolume)
	ON_BN_CLICKED(IDC_CH_DISPAVG, OnChDispavg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigDialog bZ[W nh

void CConfigDialog::OnOK() 
{
	bool	bFlag = false;

	UpdateData();

	if(pr->m_nDecodeThreadPriority != m_comboDecodePriority.GetCurSel()) {
		pr->m_nDecodeThreadPriority = m_comboDecodePriority.GetCurSel();
		bFlag = true;
	}

	if(pr->m_nOutputBps != List_Bps[m_comboOutputBps.GetCurSel()]) {
		pr->m_nOutputBps = List_Bps[m_comboOutputBps.GetCurSel()];
		bFlag = true;
	}

	pr->m_bEnable = m_bEnable != 0;
	pr->m_bFullBuffering = m_bFullBuffering != 0;
	pr->m_bSupZero = m_bSupZero != 0;
	pr->m_bReverseLR = m_bReverseLR != 0;
	pr->m_bReversePhase = m_bReversePhase != 0;
	pr->m_bAltVolume = m_bAltVolume != 0;
	pr->m_bDispAvg = m_bDispAvg != 0;

	pr->m_bPostProc = m_bReverseLR || m_bReversePhase || m_bAltVolume;

	/* activeIndex 擾 */
	CIn_mpg123dPropertySheet* pSheet = (CIn_mpg123dPropertySheet*)GetParent();
	pr->m_nStartPage = pSheet->GetActiveIndex();
	pSheet->ReflectSetting(bFlag);

	CPropertyPage::OnOK();
}

void CConfigDialog::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	
	CPropertyPage::OnCancel();
}

void CConfigDialog::SetParam()
{
	m_bEnable = pr->m_bEnable;
	m_bFullBuffering = pr->m_bFullBuffering;
	m_bSupZero = pr->m_bSupZero;
	m_bReverseLR = pr->m_bReverseLR;
	m_bReversePhase = pr->m_bReversePhase;
	m_bAltVolume = pr->m_bAltVolume;
	m_bDispAvg = pr->m_bDispAvg;
}

void CConfigDialog::OnCbnSelchangeComboDecoderPriority() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CConfigDialog::OnCbnSelchangeComboOutputbps()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	SetModified();
}

void CConfigDialog::OnChEnable() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CConfigDialog::OnChFullBuffering() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CConfigDialog::OnChSupzero() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CConfigDialog::OnChReverseLR() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CConfigDialog::OnChReversePhase() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CConfigDialog::OnChVolume() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

void CConfigDialog::OnChDispavg() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetModified();
	
}

BOOL CConfigDialog::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	// TODO: ̈ʒuɏ̕⑫ǉĂ

	m_comboDecodePriority.SetCurSel(pr->m_nDecodeThreadPriority);

	for(int Idx = 0; Idx < 5; Idx++) {
		if(List_Bps[Idx] == pr->m_nOutputBps) {
			m_comboOutputBps.SetCurSel(Idx);
			break;
		}
	}

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}
