
//
//  ėp֐
//
//  Written by Otachan
//  http://otachan.com/
//

#define	STRICT

#include <windows.h>
#include <mbctype.h>

#include "CommonFunc.h"

void
CutPathFileName(
			const WCHAR* FullFileName,
			WCHAR* FileNamePath,
			const size_t FileNamePathSize,
			WCHAR* FileName,
			const size_t FileNameSize)
{
	WCHAR	Str;
	size_t	cnt = 0;
	size_t	BackSlashCnt = -1;

	while((Str = *(FullFileName + cnt)) != L'\0') {
		if((Str == L'\\') || (Str == L'/')) BackSlashCnt = cnt;
		cnt++;
	}

	BackSlashCnt++;

	if(FileNamePath) {
		const size_t	CopySize = Min(BackSlashCnt, FileNamePathSize - 1);

		memcpy(FileNamePath, FullFileName, CopySize * sizeof WCHAR);
		*(FileNamePath + CopySize) = L'\0';
	}

	if(FileName) {
		wcscpy_s(FileName, FileNameSize, FullFileName + BackSlashCnt);
	}
}

void
CutFileNameExt(
			const WCHAR* FullFileName,
			WCHAR* FileName,
			const size_t FileNameSize,
			WCHAR* FileExt,
			const size_t FileExtSize)
{
	WCHAR	Str = L'\0';
	size_t	ExtCnt;
	const size_t	FullFileNameLen = wcslen(FullFileName);

	if(FullFileNameLen) {
		for(ExtCnt = FullFileNameLen - 1; ; ExtCnt--) {
			Str = *(FullFileName + ExtCnt);
			if((Str == L'.') || (Str == L'\\')  || (Str == L'/') || (ExtCnt == 0)) break;
		}
	}

	if(Str != L'.') ExtCnt = FullFileNameLen;

	if(FileName) {
		const size_t	CopySize = Min(ExtCnt, FileNameSize - 1);

		memcpy(FileName, FullFileName, CopySize * sizeof WCHAR);
		*(FileName + CopySize) = L'\0';
	}

	if(FileExt) {
		if(Str == L'.') {
			wcscpy_s(FileExt, FileExtSize, FullFileName + ExtCnt + 1);
		} else {
			*FileExt = L'\0';
		}
	}
}

WCHAR*
Strcpy(
	WCHAR* OutBuff,
	const UINT OutBuffSize,
	WCHAR* InBuff,
	UINT InBuffSize,
	const bool UseBOM,
	bool BigEndian)
{
	InBuffSize = Min(InBuffSize, OutBuffSize - 1);

	if(UseBOM && (InBuffSize >= 1)) {
		if(*InBuff == L'\ufffe') {			// rbOGfBA
			InBuff++;
			InBuffSize--;
			BigEndian = true;
		} else if(*InBuff == L'\ufeff') {	// gGfBA
			InBuff++;
			InBuffSize--;
			BigEndian = false;
		}
	}

	WCHAR*	WorkBuff;

	if(BigEndian) {
		WorkBuff = new WCHAR[InBuffSize];

		unsigned short*	InBuffPnt = reinterpret_cast<unsigned short*>(InBuff);
		unsigned short*	WorkBuffPnt = reinterpret_cast<unsigned short*>(WorkBuff);

		for(UINT Idx = 0; Idx < InBuffSize; Idx++) {
			*WorkBuffPnt++ = BSwap16(*InBuffPnt++);
		}
	} else {
		WorkBuff = InBuff;
	}

	memcpy(OutBuff, WorkBuff, InBuffSize * sizeof WCHAR);

	if(BigEndian) delete[] WorkBuff;

	*(OutBuff + InBuffSize) = L'\0';

	return OutBuff;
}

int
KanjiStrChr(const WCHAR* InBuff, WCHAR Chr1)
{
	WCHAR	Str;
	int		cnt = 0;

	while((Str = *(InBuff + cnt)) != L'\0') {
		if(Str == Chr1) break;
		cnt++;
	}

	if((Str == L'\0') && (Chr1 != L'\0')) cnt = -1;

	return cnt;
}

// 񒆁A̗]ȃXy[X菜

void
EraseSpace(WCHAR* InBuff, int Len)
{
	if(Len == -1) Len = static_cast<int>(wcslen(InBuff));

	int		Idx;

	for(Idx = Len - 1; Idx >= 0; Idx--) {
		WCHAR*	InBuffIdx = InBuff + Idx;

		if((*InBuffIdx != L' ') && (*InBuffIdx != L'\0')) break;
	}

	if(Idx < 0) {
		*InBuff = L'\0';
		return;
	}

	// ̍ŌCR+LF菜

	if((Idx >= 1) && (*(InBuff + Idx - 1) == L'\x0d') && (*(InBuff + Idx) == L'\x0a')) {
		*(InBuff + Idx - 1) = L'\0';
		if(Idx == 1) return;
	} else {
		*(InBuff + Idx + 1) = L'\0';
	}
}

void
FormatItow(const int Value, WCHAR* RetBuff, const size_t RetBuffSize, const size_t Size, const WCHAR c)
{
	WCHAR	Work[SIZE_ITOA10];

	_itow_s(Value, Work, SIZE_ITOA10, 10);

	const size_t	WorkLen = wcslen(Work);

	if(Size >= WorkLen) {
		const size_t	CopyOffset = Size - WorkLen;

		for(size_t Idx = 0; Idx < CopyOffset; Idx++) {
			*(RetBuff + Idx) = c;
		}

		wcscpy_s(RetBuff + CopyOffset, RetBuffSize - CopyOffset, Work);
	} else {
		Strncpy(RetBuff, Work + WorkLen - Size, Size);
	}
}

