
#define	STRICT

#include <windows.h>

#include "CommonFunc.h"

#include "Bitrate.h"

Bitrate::Bitrate(int _MaxLatency, int _Sr, int _FrameSamples)
{
	MaxLatency = _MaxLatency;
	Sr = _Sr;
	FrameSamples = _FrameSamples;

	MaxHistory = Max(::MulDiv(_MaxLatency, _Sr, 1000) / _FrameSamples / REALTIME_VBR_UPDATE_FRAME + 1,
					2);

	History = new int[MaxHistory];

	Flush();
}

Bitrate::~Bitrate(void)
{
	delete[] History;
}

void
Bitrate::Flush(void)
{
	memset(History, 0, MaxHistory * sizeof(int));

	First = true;
	HistoryIdx = 0;
	SetCnt = 0;
	AddBitrate = 0;
	AverageLatencyIdx = 0;
}

void
Bitrate::Set(int Bitrate)
{
	AddBitrate += Bitrate;

	*(History + HistoryIdx) = static_cast<int>(AddBitrate / ++SetCnt);

	if(SetCnt == REALTIME_VBR_UPDATE_FRAME) {
		if(++HistoryIdx == MaxHistory) {
			HistoryIdx = 0;
			First = false;
		}

		AddBitrate = 0;
		SetCnt = 0;
	}
}

int
Bitrate::Get(int Latency)
{
	int		RetCode;

	if(Latency <= MaxLatency) {
		const int	LatencyIdx = Max(::MulDiv(Latency, Sr, 1000) / FrameSamples /
										REALTIME_VBR_UPDATE_FRAME, 1);

		AverageLatencyIdx = AverageLatencyIdx ? (AverageLatencyIdx + LatencyIdx) / 2 : LatencyIdx;

		RetCode = (HistoryIdx >= AverageLatencyIdx) ?
						*(History + HistoryIdx - AverageLatencyIdx) :
						(First ? 0 : *(History + HistoryIdx + MaxHistory - AverageLatencyIdx));
	} else {
		RetCode = 0;
	}

	return RetCode;
}

