
#ifndef _ADRTIME_H
#define _ADRTIME_H

class CAdrTime  
{
public:
	CAdrTime(void);
	~CAdrTime(void);

	bool Init(FileSys* input_file, int pos, int frames = -1);
	void Release(void);

	DWORD ToAddress(double nTime);
	double ToTime(DWORD dwAdr);

private:
	struct AdrTimeData
	{
		DWORD dwAdr;
		double nTime;
		AdrTimeData(void) : dwAdr((DWORD)-1), nTime(-1) {}
		AdrTimeData(DWORD dw, int n) : dwAdr(dw), nTime(n) {}
		static int __cdecl CompAdr(const AdrTimeData* p1, const AdrTimeData* p2);
		static int __cdecl CompTime(const AdrTimeData* p1, const AdrTimeData* p2);
	};
	FileSys* m_input_file;
	AdrTimeData* m_pData;
	DWORD m_dwFileSize;
	int m_nFrames;
	int m_nNumData;
	int m_nMaxData;
	double m_dTime;

	double GetFrameTime(const frame& fr);
	bool GetFrame(frame& fr);
	int ReadFrame(frame& fr);
	bool CheckHeader(DWORD header);
	inline DWORD GetFilePtr(void);
	bool AddData(DWORD dw, double nTime);
	bool ProcessOneFrame(void);
};

#endif

