#pragma once

#include <streams.h>
#include <shlwapi.h>
#include "../CSimpleFilter/CSimpleFilter.h"

#define UNPACK
#define USE_FSTREAMS

#include "wavpack.h"

#define ERRORLEN 80
#define MAX_ARRAY_SIZE 9216  

#define WAVE_FORMAT_IEEE_FLOAT 3

#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "shlwapi.lib")
#pragma comment(lib, "../lib/strmbase.lib")
#pragma comment(lib, "../lib/CSimpleFilter.lib")
#pragma comment(lib, "libwavpack.lib")


static const GUID CLSID_SourceWv =
{ 0x4786fc41, 0x7568, 0x4b2b, { 0x81, 0xe1, 0x85, 0xe9, 0x49, 0x0, 0xc7, 0x53 } };

class CSourceWv : public CSimplePushSource , public IFileSourceFilter
{
public:
   DECLARE_IUNKNOWN

   
   CSourceWv(LPUNKNOWN, HRESULT *);
   ~CSourceWv();

   
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   
   HRESULT OnConnectOutPin(CMediaType *, int *, REFERENCE_TIME *);
   HRESULT FillBuffer(IMediaSample *);

   
   STDMETHODIMP OnQueryInterface(REFIID riid, void ** ppv);
   HRESULT OnSeek(LONGLONG, LONGLONG);

   
   STDMETHODIMP Load(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

private:

   
   WavpackContext *m_pWvContext;
   int m_anOutbuffer[MAX_ARRAY_SIZE];
   WAVEFORMATEX m_outFormat;

   WCHAR m_awInputFileName[MAX_PATH];



   REFERENCE_TIME m_rtStop, m_rtCurrent;
   LONGLONG m_llTotalDuration;
};

