

#ifndef TTACODEC_H
#define TTACODEC_H

#define TTA_COPYRIGHT		"Copyright (c) 2004 Alexander Djourik. All rights reserved."

#define TTA_MYNAME			"ttaenc"
#define TTA_VERSION			"3.0"
#define TTA_BUILD			"20040404"

#define TTA_MAX_BPS			32
#define TTA_FRAME_TIME		1.04489795918367346939

#define TTA1_SIGN		0x31415454

#define TTA_MAX_ORDER		16

#ifdef _WIN32
#define __ATTRIBUTE_PACKED__
#else
#define __ATTRIBUTE_PACKED__	__attribute__((packed))
#endif

typedef struct {
	unsigned long k0;
	unsigned long k1;
	unsigned long sum0;
	unsigned long sum1;
} TTA_adapt;

typedef struct {
	long shift;
	long round;
	long error;
	long mutex;
	long qm[TTA_MAX_ORDER];
	long dx[TTA_MAX_ORDER];
	long dl[TTA_MAX_ORDER];
} TTA_fltst;

typedef struct {
	TTA_fltst fst;
	TTA_adapt rice;
	long last;
} TTA_channel_codec;

typedef struct {
	unsigned long bit_count;
	unsigned long bit_cache;
	unsigned char *bitpos;
	unsigned long crc32;
	unsigned long size;
	
	unsigned char *bit_buffer;
	unsigned char *BIT_BUFFER_END;
} TTA_bit_buffer;

typedef struct {
	TTA_channel_codec* enc;   
	TTA_channel_codec* tta;   
	TTA_bit_buffer *fbuf;     
	long* data;
	unsigned long data_len;

	
	unsigned long framelen;
	unsigned long srate;
	unsigned short num_chan;
	unsigned short bps;
	unsigned long byte_size;
	unsigned long is_float;
	unsigned short wavformat;
} TTA_codec;


#ifdef _WIN32
#pragma pack(push,1)
#endif

typedef struct {
    unsigned long TTAid;
    unsigned short AudioFormat;
    unsigned short NumChannels;
    unsigned short BitsPerSample;
    unsigned long SampleRate;
    unsigned long DataLength;
    unsigned long CRC32;
} __ATTRIBUTE_PACKED__ TTA_header;

typedef struct {
    unsigned char id[3];
    unsigned short version;
    unsigned char flags;
    unsigned char size[4];
} __ATTRIBUTE_PACKED__ TTA_id3v2_header;

#ifdef _WIN32
#pragma pack(pop)
#endif



#ifdef __cplusplus
extern "C" {
#endif



TTA_codec* tta_codec_encoder_new(long srate,
								 short num_chan,
								 short bps,
								 short format);

TTA_codec* tta_codec_decoder_new(long srate,
								 short num_chan,
								 short bps);

void tta_codec_free(TTA_codec* ttaenc);

unsigned long tta_codec_encoder_compress(TTA_codec* ttaenc,
										 unsigned char *src,
										 unsigned long len,
										 unsigned long *bytes_to_write);

unsigned char* tta_codec_encoder_get_frame(TTA_codec* ttaenc,
										   unsigned long *num_frames);

unsigned long tta_codec_encoder_finalize(TTA_codec* ttaenc);

unsigned long tta_codec_decoder_decompress(TTA_codec* ttadec,
										   unsigned char *src,
										   unsigned long len,
										   unsigned char *dst,
										   unsigned long dstlen);

void tta_codec_fill_header(TTA_codec* ttacodec,
						   TTA_header *hdr,
						   unsigned long data_len);


unsigned long tta_codec_get_frame_len(long srate);



#ifdef __cplusplus
}
#endif	



#endif	
