

#ifndef VALIB_SYNCSCAN_H
#define VALIB_SYNCSCAN_H

#include "defs.h"




#define SYNC_MPA_BE   8
#define SYNC_MPA_LE   9

#define SYNC_AC3_BE   10  
#define SYNC_AC3_LE   11

#define SYNC_DTS16_BE 12
#define SYNC_DTS16_LE 13
#define SYNC_DTS14_BE 14
#define SYNC_DTS14_LE 15

#define SYNC_SPDIF    16
#define SYNC_PS       17




#define SYNCMASK_MAD      0xff00

#define SYNCMASK_MPA      0x0300
#define SYNCMASK_MPA_BE   0x0100
#define SYNCMASK_MPA_LE   0x0200

#define SYNCMASK_AC3      0x0c00
#define SYNCMASK_AC3_BE   0x0400
#define SYNCMASK_AC3_LE   0x0800

#define SYNCMASK_DTS      0xf000
#define SYNCMASK_DTS16_BE 0x1000
#define SYNCMASK_DTS16_LE 0x2000
#define SYNCMASK_DTS14_BE 0x4000
#define SYNCMASK_DTS14_LE 0x8000

#define SYNCMASK_SPDIF    0x10000
#define SYNCMASK_PS       0x20000




class SyncScan
{
protected:
  typedef uint32_t synctbl_t;
  synctbl_t *synctable;

public:
  union
  {
    uint8_t  syncbuf[4];
    uint32_t syncword;
  };
  size_t count;

public:
  SyncScan(uint32_t syncword = 0, uint32_t syncmask = 0);
  ~SyncScan();

  
  

  bool   set  (int index, uint32_t syncword, uint32_t syncmask);
  bool   allow(int index, uint32_t syncword, uint32_t syncmask);
  bool   deny (int index, uint32_t syncword, uint32_t syncmask);

  bool   clear(int index);
  void   clear_all();

  bool   set_list(const uint32_t *_list, size_t _size);
  void   set_standard(uint32_t syncmask);

  
  

  void     reset();
  uint32_t get_sync() const;
  size_t   scan(uint8_t *buf, size_t size);

  
  

  uint32_t get_sync(uint8_t *buf) const;
  size_t   scan(uint8_t *syncword, uint8_t *buf, size_t size) const;
};

#endif
