/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.sed.task;

import java.io.IOException;

import blanco.sed.task.valueobject.BlancoSedProcessInput;

/**
 * ob`NX [BlancoSedBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.sed.task.BlancoSedBatchProcess -help
 * </code>
 */
public class BlancoSedBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoSedBatchProcess batchProcess = new BlancoSedBatchProcess();

        // ob`̈B
        final BlancoSedProcessInput input = new BlancoSedProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldInputProcessed = false;
        boolean isFieldOutputProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-input=")) {
                input.setInput(arg.substring(7));
                isFieldInputProcessed = true;
            } else if (arg.startsWith("-output=")) {
                input.setOutput(arg.substring(8));
                isFieldOutputProcessed = true;
            } else if (arg.startsWith("-script=")) {
                input.setScript(arg.substring(8));
            } else if (arg.startsWith("-scriptfile=")) {
                input.setScriptfile(arg.substring(12));
            } else if (arg.startsWith("-encoding=")) {
                input.setEncoding(arg.substring(10));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoSedBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldInputProcessed == false) {
            System.out.println("BlancoSedBatchProcess: JnsB̓p[^[input]̕K{tB[hl[input]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldOutputProcessed == false) {
            System.out.println("BlancoSedBatchProcess: JnsB̓p[^[input]̕K{tB[hl[output]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoSedProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoSedProcessC^tF[X blanco.sed.taskpbP[W BlancoSedProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoSedProcess process = new BlancoSedProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoSedProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoSedBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoSedBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoSedBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoSedBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoSedBatchProcess: Usage:");
        System.out.println("  java blanco.sed.task.BlancoSedBatchProcess -verbose=l1 -input=l2 -output=l3 -script=l4 -scriptfile=l5 -encoding=l6");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -input");
        System.out.println("      [̓t@Cw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -output");
        System.out.println("      [o̓t@Cw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -script");
        System.out.println("      [XNvgw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("    -scriptfile");
        System.out.println("      [XNvgt@Cw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("    -encoding");
        System.out.println("      [t@C̃GR[hw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[Windows-31J]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoSedProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getInput() == null) {
            throw new IllegalArgumentException("BlancoSedBatchProcess: JnsB̓p[^[input]̕K{tB[hl[input]ɒlݒ肳Ă܂B");
        }
        if (input.getOutput() == null) {
            throw new IllegalArgumentException("BlancoSedBatchProcess: JnsB̓p[^[input]̕K{tB[hl[output]ɒlݒ肳Ă܂B");
        }
    }
}
