/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sed;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import blanco.commons.util.BlancoNameUtil;

/**
 * sed ̂ꕔ@\̎ڎwNXB
 * 
 * @author IGA Tosiki
 */
public class BlancoSed {
    /**
     * sed ̃XNvg̋@\񋟂܂B
     * 
     * : { sed XNvgt@C̕Ƀ}b`ۂ̋𖢒B
     * 
     * @throws IOException
     */
    public static void process(final BufferedReader reader,
            final BufferedWriter writer, final BufferedReader readerScriptFile)
            throws IOException {
        final List<String> scriptList = new ArrayList<String>(1024);
        for (;;) {
            final String line = readerScriptFile.readLine();
            if (line == null) {
                break;
            }
            scriptList.add(line);
        }

        for (;;) {
            String line = reader.readLine();
            if (line == null) {
                break;
            }

            for (int indexScript = 0; indexScript < scriptList.size(); indexScript++) {
                line = process(line, scriptList.get(indexScript));
            }
            writer.write(line);
            writer.newLine();
        }
    }

    /**
     * sed ̃XNvg̋@\񋟂܂B
     * 
     * @param source
     *            ͕B
     * @param script
     *            sedXNvgBs/regexp/replacement/g ̂́B
     * @return u̕B
     */
    public static String process(final String source, final String script) {
        boolean isReplaceAll = false;
        final String[] tokens = BlancoNameUtil.splitString(script, '/');

        if (tokens.length < 1) {
            throw new IllegalArgumentException("sed: R}h܂B");
        }
        if (tokens.length < 2) {
            throw new IllegalArgumentException("sed: K\܂B");
        }
        if (tokens.length < 3) {
            throw new IllegalArgumentException("sed: u񂪂܂B");
        }

        final String cmd = tokens[0];
        if ("s".equals(cmd) == false) {
            throw new IllegalArgumentException("sed: sȊÕR}h[" + cmd
                    + "]͎󂯕t܂B");
        }

        final String regexp = tokens[1];

        final String replacement = tokens[2];

        if (tokens.length >= 4) {
            final String replaceAll = tokens[3];
            if ("g".equals(replaceAll)) {
                isReplaceAll = true;
            }
        }
        return replace(source, regexp, replacement, isReplaceAll);
    }

    /**
     * ^ꂽ regexp ̃}b`݁A}b`ꍇɂ͒uŒu܂B
     * 
     * @param source
     *            ͕B
     * @param regexp
     *            }b`ۂ̐K\B
     * @param replacement
     *            uB
     * @param isReplaceAll
     *            SĂu邩ǂB
     * @return u̕B}b`ꍇɂ̓}b` replacement ɒu܂B
     */
    public static String replace(final String source, final String regexp,
            final String replacement, final boolean isReplaceAll) {
        try {
            final Pattern pattern = Pattern.compile(regexp);
            final Matcher matcher = pattern.matcher(source);
            if (isReplaceAll) {
                return matcher.replaceAll(replacement);
            } else {
                return matcher.replaceFirst(replacement);
            }
        } catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("^ꂽK\p^[[" + regexp
                    + "]͖ł", ex);
        }
    }
}
