/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.api.eucalyptus;

import com.amazonaws.ec2.AmazonEC2;
import com.amazonaws.ec2.AmazonEC2Client;
import com.amazonaws.ec2.AmazonEC2Config;
import com.amazonaws.ec2.AmazonEC2Exception;
import com.amazonaws.ec2.model.Address;
import com.amazonaws.ec2.model.AllocateAddressRequest;
import com.amazonaws.ec2.model.AllocateAddressResponse;
import com.amazonaws.ec2.model.AssociateAddressRequest;
import com.amazonaws.ec2.model.AttachVolumeRequest;
import com.amazonaws.ec2.model.Attachment;
import com.amazonaws.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.ec2.model.AvailabilityZone;
import com.amazonaws.ec2.model.CreateKeyPairRequest;
import com.amazonaws.ec2.model.CreateKeyPairResponse;
import com.amazonaws.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.ec2.model.CreateSecurityGroupResponse;
import com.amazonaws.ec2.model.CreateSnapshotRequest;
import com.amazonaws.ec2.model.CreateVolumeRequest;
import com.amazonaws.ec2.model.DeleteKeyPairRequest;
import com.amazonaws.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.ec2.model.DeleteSnapshotRequest;
import com.amazonaws.ec2.model.DeleteVolumeRequest;
import com.amazonaws.ec2.model.DescribeAddressesRequest;
import com.amazonaws.ec2.model.DescribeAddressesResponse;
import com.amazonaws.ec2.model.DescribeAvailabilityZonesRequest;
import com.amazonaws.ec2.model.DescribeAvailabilityZonesResponse;
import com.amazonaws.ec2.model.DescribeImagesRequest;
import com.amazonaws.ec2.model.DescribeImagesResponse;
import com.amazonaws.ec2.model.DescribeInstancesRequest;
import com.amazonaws.ec2.model.DescribeInstancesResponse;
import com.amazonaws.ec2.model.DescribeKeyPairsRequest;
import com.amazonaws.ec2.model.DescribeKeyPairsResponse;
import com.amazonaws.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.ec2.model.DescribeSecurityGroupsResponse;
import com.amazonaws.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.ec2.model.DescribeSnapshotsResponse;
import com.amazonaws.ec2.model.DescribeVolumesRequest;
import com.amazonaws.ec2.model.DescribeVolumesResponse;
import com.amazonaws.ec2.model.DetachVolumeRequest;
import com.amazonaws.ec2.model.DisassociateAddressRequest;
import com.amazonaws.ec2.model.Image;
import com.amazonaws.ec2.model.IpPermission;
import com.amazonaws.ec2.model.KeyPair;
import com.amazonaws.ec2.model.Placement;
import com.amazonaws.ec2.model.RebootInstancesRequest;
import com.amazonaws.ec2.model.ReleaseAddressRequest;
import com.amazonaws.ec2.model.Reservation;
import com.amazonaws.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.ec2.model.RunInstancesRequest;
import com.amazonaws.ec2.model.RunningInstance;
import com.amazonaws.ec2.model.SecurityGroup;
import com.amazonaws.ec2.model.Snapshot;
import com.amazonaws.ec2.model.TerminateInstancesRequest;
import com.amazonaws.ec2.model.UserIdGroupPair;
import com.amazonaws.ec2.model.Volume;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import jp.co.intellilink.aws.api.AwsApiException;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2Address;
import jp.co.intellilink.aws.api.transport.EC2AssociateRequest;
import jp.co.intellilink.aws.api.transport.EC2AttachVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2Attachment;
import jp.co.intellilink.aws.api.transport.EC2AuthorizeRequest;
import jp.co.intellilink.aws.api.transport.EC2AvailabilityZone;
import jp.co.intellilink.aws.api.transport.EC2BundleInstance;
import jp.co.intellilink.aws.api.transport.EC2BundleInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2CancelBundleRequest;
import jp.co.intellilink.aws.api.transport.EC2ComfirmProductRequest;
import jp.co.intellilink.aws.api.transport.EC2ConsoleOutput;
import jp.co.intellilink.aws.api.transport.EC2CreateKeyPairRequest;
import jp.co.intellilink.aws.api.transport.EC2CreateSecurityGroupRequest;
import jp.co.intellilink.aws.api.transport.EC2CreateSnapshotRequest;
import jp.co.intellilink.aws.api.transport.EC2CreateVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2DeleteSecurityGroupRequest;
import jp.co.intellilink.aws.api.transport.EC2DeleteSnapshotRequest;
import jp.co.intellilink.aws.api.transport.EC2DeleteVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2DeregisterImageRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeAddressRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeAvailabilityZonesRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeBundleTasksRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeImageAttributeRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeImagesRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeKeyPairsRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeRegionsRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeSecurityGroupRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeSnapshotRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeVolumesRequest;
import jp.co.intellilink.aws.api.transport.EC2DetachVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2DisassociateAddressRequest;
import jp.co.intellilink.aws.api.transport.EC2GetConsoleOutputRequest;
import jp.co.intellilink.aws.api.transport.EC2Image;
import jp.co.intellilink.aws.api.transport.EC2ImageAttribute;
import jp.co.intellilink.aws.api.transport.EC2Instance;
import jp.co.intellilink.aws.api.transport.EC2KeyPair;
import jp.co.intellilink.aws.api.transport.EC2ModifyAttributeRequest;
import jp.co.intellilink.aws.api.transport.EC2Permission;
import jp.co.intellilink.aws.api.transport.EC2Product;
import jp.co.intellilink.aws.api.transport.EC2RebootInstancesRequest;
import jp.co.intellilink.aws.api.transport.EC2Region;
import jp.co.intellilink.aws.api.transport.EC2RegisterImageRequest;
import jp.co.intellilink.aws.api.transport.EC2ReleaseAddressRequest;
import jp.co.intellilink.aws.api.transport.EC2Reservation;
import jp.co.intellilink.aws.api.transport.EC2ResetImageAttributeRequest;
import jp.co.intellilink.aws.api.transport.EC2RevokeSecurityGroupIngressRequest;
import jp.co.intellilink.aws.api.transport.EC2RunInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2SecurityGroup;
import jp.co.intellilink.aws.api.transport.EC2Snapshot;
import jp.co.intellilink.aws.api.transport.EC2TerminateInstancesRequest;
import jp.co.intellilink.aws.api.transport.EC2Volume;

public class EC2Client
implements ElasticComputingCloudInterface {
    private static SimpleDateFormat sdf = null;
    private AmazonEC2 client;
    private String name;
    private String desc;
    private String url;

    public EC2Client() {
        if (sdf == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    public void configureUrl(String url) {
        this.url = url;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void configure(String accessKey, String secretKey) {
        AmazonEC2Config config = new AmazonEC2Config();
        config.setServiceURL(this.url);
        this.client = new AmazonEC2Client(accessKey, secretKey, config);
    }

    public EC2Address allocateAddress() {
        AllocateAddressResponse response = null;
        try {
            response = this.client.allocateAddress(new AllocateAddressRequest());
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        EC2Address rv = new EC2Address(response.getAllocateAddressResult().getPublicIp());
        return rv;
    }

    public EC2Address associateAddress(EC2AssociateRequest request) {
        try {
            this.client.associateAddress(new AssociateAddressRequest(request.getInstanceId(), request.getPublicIp()));
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return new EC2Address(request.getPublicIp());
    }

    public EC2Volume attachVolume(EC2AttachVolumeRequest request) {
        AttachVolumeRequest req = new AttachVolumeRequest();
        req.setVolumeId(request.getVolumeId());
        req.setInstanceId(request.getInstanceId());
        req.setDevice(request.getDevice());
        try {
            this.client.attachVolume(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public EC2SecurityGroup authorizeSecurityGroup(EC2AuthorizeRequest request) {
        AuthorizeSecurityGroupIngressRequest req = new AuthorizeSecurityGroupIngressRequest();
        req.setCidrIp(request.getCidrIp());
        req.setToPort(request.getToPort());
        req.setFromPort(request.getFromPort());
        req.setGroupName(request.getGroupName());
        req.setIpProtocol(request.getIpProtocol());
        req.setSourceSecurityGroupName(request.getSourceSecurityGroupName());
        req.setSourceSecurityGroupOwnerId(request.getSourceSecurityGroupOwnerId());
        req.setUserId(request.getUserId());
        try {
            this.client.authorizeSecurityGroupIngress(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public EC2BundleInstance bundleInstance(EC2BundleInstanceRequest request) {
        return null;
    }

    public EC2BundleInstance cancelBundleInstance(EC2CancelBundleRequest request) {
        return null;
    }

    public EC2Product comfirmProduct(EC2ComfirmProductRequest request) {
        return null;
    }

    public EC2KeyPair createKeyPair(EC2CreateKeyPairRequest request) {
        CreateKeyPairResponse response = null;
        try {
            response = this.client.createKeyPair(new CreateKeyPairRequest(request.getKeyName()));
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        KeyPair result = response.getCreateKeyPairResult().getKeyPair();
        EC2KeyPair rv = new EC2KeyPair(result.getKeyName(), result.getKeyFingerprint(), result.getKeyMaterial());
        return rv;
    }

    public EC2SecurityGroup createSecurityGroup(EC2CreateSecurityGroupRequest request) {
        CreateSecurityGroupRequest req = new CreateSecurityGroupRequest(request.getName(), request.getDescription());
        EC2SecurityGroup ret = null;
        try {
            CreateSecurityGroupResponse response = this.client.createSecurityGroup(req);
            if (response != null) {
                ret = new EC2SecurityGroup(req.getGroupName(), req.getGroupDescription());
            }
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return ret;
    }

    public EC2Snapshot createSnapshot(EC2CreateSnapshotRequest request) {
        CreateSnapshotRequest req = new CreateSnapshotRequest();
        req.setVolumeId(request.getVolumeId());
        try {
            this.client.createSnapshot(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public EC2Volume createVolume(EC2CreateVolumeRequest request) {
        CreateVolumeRequest req = new CreateVolumeRequest();
        req.setAvailabilityZone(request.getAvailabilityZone());
        req.setSize(request.getSize());
        req.setSnapshotId(request.getSnapshotId());
        try {
            this.client.createVolume(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public EC2KeyPair deleteKeyPair(EC2KeyPair request) {
        try {
            this.client.deleteKeyPair(new DeleteKeyPairRequest(request.getKeyName()));
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public EC2SecurityGroup deleteSecurityGroup(EC2DeleteSecurityGroupRequest request) {
        DeleteSecurityGroupRequest req = new DeleteSecurityGroupRequest();
        req.setGroupName(request.getGroupName());
        try {
            this.client.deleteSecurityGroup(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public EC2Snapshot deleteSnapshot(EC2DeleteSnapshotRequest request) {
        DeleteSnapshotRequest req = new DeleteSnapshotRequest();
        req.setSnapshotId(request.getSnapshotId());
        try {
            this.client.deleteSnapshot(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public EC2Volume deleteVolume(EC2DeleteVolumeRequest request) {
        DeleteVolumeRequest req = new DeleteVolumeRequest();
        req.setVolumeId(request.getVolumeId());
        try {
            this.client.deleteVolume(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public EC2Image deregisterImage(EC2DeregisterImageRequest request) {
        return null;
    }

    public List<EC2Address> describeAddress(EC2DescribeAddressRequest request) {
        DescribeAddressesResponse response = null;
        try {
            response = this.client.describeAddresses(new DescribeAddressesRequest(request.getPublicIp()));
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        List addresses = response.getDescribeAddressesResult().getAddress();
        ArrayList<EC2Address> rv = new ArrayList<EC2Address>();
        for (Address address : addresses) {
            rv.add(new EC2Address(address.getPublicIp(), address.getInstanceId()));
        }
        return rv;
    }

    public List<EC2AvailabilityZone> describeAvailabilityZones(EC2DescribeAvailabilityZonesRequest request) {
        DescribeAvailabilityZonesResponse response = null;
        try {
            response = this.client.describeAvailabilityZones(new DescribeAvailabilityZonesRequest());
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        List result = response.getDescribeAvailabilityZonesResult().getAvailabilityZone();
        ArrayList<EC2AvailabilityZone> rv = new ArrayList<EC2AvailabilityZone>();
        for (AvailabilityZone zone : result) {
            EC2AvailabilityZone z = new EC2AvailabilityZone();
            z.setRegionName(zone.getRegionName());
            z.setZoneName(zone.getZoneName());
            z.setZoneState(zone.getZoneState());
            rv.add(z);
        }
        return rv;
    }

    public List<EC2BundleInstance> describeBundleTasks(EC2DescribeBundleTasksRequest request) {
        return null;
    }

    public List<EC2ImageAttribute> describeImageAttribute(EC2DescribeImageAttributeRequest request) {
        return null;
    }

    public List<EC2Image> describeImages(EC2DescribeImagesRequest request) {
        DescribeImagesRequest req = new DescribeImagesRequest();
        req.setExecutableBy(request.getExecutableBy());
        req.setImageId(request.getImageId());
        req.setOwner(request.getOwner());
        DescribeImagesResponse response = null;
        try {
            response = this.client.describeImages(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        List images = response.getDescribeImagesResult().getImage();
        ArrayList<EC2Image> rv = new ArrayList<EC2Image>();
        for (Image image : images) {
            rv.add(this.createEC2Image(image));
        }
        return rv;
    }

    private EC2Image createEC2Image(Image src) {
        EC2Image dest = new EC2Image();
        dest.setArchitecture(src.getArchitecture());
        dest.setImageId(src.getImageId());
        dest.setImageLocation(src.getImageLocation());
        dest.setImageOwnerId(src.getImageOwnerAlias());
        dest.setImageType(src.getImageType());
        dest.setKernelId(src.getKernelId());
        dest.setRamdiskId(src.getRamdiskId());
        dest.setPlatform(src.getPlatform());
        return dest;
    }

    public List<EC2Instance> describeInstance(EC2DescribeInstanceRequest request) {
        DescribeInstancesResponse response = null;
        try {
            response = this.client.describeInstances(new DescribeInstancesRequest());
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        List reservations = response.getDescribeInstancesResult().getReservation();
        ArrayList<EC2Instance> rv = new ArrayList<EC2Instance>();
        for (Reservation reservation : reservations) {
            rv.addAll(this.createEC2InstanceList(reservation));
        }
        return rv;
    }

    private List<EC2Instance> createEC2InstanceList(Reservation reservation) {
        ArrayList<EC2Instance> rv = new ArrayList<EC2Instance>();
        List instances = reservation.getRunningInstance();
        for (RunningInstance instance : instances) {
            EC2Instance i = new EC2Instance();
            i.setReservationId(reservation.getReservationId());
            i.setDnsName(instance.getPublicDnsName());
            i.setId(instance.getInstanceId());
            i.setImageId(instance.getImageId());
            i.setInstanceState(instance.getInstanceState().getCode());
            i.setInstanceType(instance.getInstanceType());
            i.setKeyName(instance.getKeyName());
            try {
                i.setLaunchTime(sdf.parse(instance.getLaunchTime()));
            }
            catch (ParseException e) {
                e.printStackTrace();
                i.setLaunchTime(new Date());
            }
            i.setZone(instance.getPlacement().getAvailabilityZone());
            i.setPrivateDnsName(instance.getPrivateDnsName());
            if (instance.getStateReason() != null) {
                i.setReason(instance.getStateReason().getMessage());
            }
            for (String group : reservation.getGroupName()) {
                i.addGroup(new EC2SecurityGroup(group, ""));
            }
            rv.add(i);
        }
        return rv;
    }

    public List<EC2KeyPair> describeKeyPairs(EC2DescribeKeyPairsRequest request) {
        DescribeKeyPairsResponse response = null;
        try {
            response = this.client.describeKeyPairs(new DescribeKeyPairsRequest());
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        List result = response.getDescribeKeyPairsResult().getKeyPair();
        ArrayList<EC2KeyPair> rv = new ArrayList<EC2KeyPair>();
        for (KeyPair k : result) {
            EC2KeyPair key = new EC2KeyPair(k.getKeyName(), k.getKeyFingerprint(), k.getKeyMaterial());
            rv.add(key);
        }
        return rv;
    }

    public List<EC2Region> describeRegions(EC2DescribeRegionsRequest request) {
        return null;
    }

    public List<EC2SecurityGroup> describeSecurityGroups(EC2DescribeSecurityGroupRequest request) {
        ArrayList<EC2SecurityGroup> ret = new ArrayList<EC2SecurityGroup>();
        try {
            DescribeSecurityGroupsResponse response = this.client.describeSecurityGroups(new DescribeSecurityGroupsRequest());
            List groups = response.getDescribeSecurityGroupsResult().getSecurityGroup();
            for (SecurityGroup group : groups) {
                EC2SecurityGroup g = new EC2SecurityGroup(group.getGroupName(), group.getGroupDescription());
                for (IpPermission permission : group.getIpPermission()) {
                    EC2Permission p = new EC2Permission();
                    p.setCidrIp(this.extractIpRange(permission.getIpRange()).toString());
                    p.setFromPort(permission.getFromPort());
                    p.setToPort(permission.getToPort());
                    p.setIpProtocol(permission.getIpProtocol());
                    List userIdGroupPair = permission.getUserIdGroupPair();
                    for (UserIdGroupPair pair : userIdGroupPair) {
                        p.addPair(pair.getUserId(), pair.getGroupName());
                        pair.getGroupName();
                        pair.getUserId();
                    }
                    g.addPermission(p);
                }
                ret.add(g);
            }
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return ret;
    }

    private StringBuilder extractIpRange(List<String> ipRanges) {
        if (ipRanges == null || ipRanges.isEmpty()) {
            return new StringBuilder();
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipRanges) {
            builder.append(ip);
            builder.append(",");
        }
        builder.deleteCharAt(builder.lastIndexOf(","));
        return builder;
    }

    public List<EC2Snapshot> describeSnapshot(EC2DescribeSnapshotRequest request) {
        DescribeSnapshotsRequest req = new DescribeSnapshotsRequest();
        req.setOwner(request.getOwner());
        req.setRestorableBy(request.getRestoableBy());
        req.setSnapshotId(request.getSnapshotId());
        List<EC2Snapshot> ret = null;
        try {
            DescribeSnapshotsResponse response = this.client.describeSnapshots(req);
            ret = this.createSnapshotList(response.getDescribeSnapshotsResult().getSnapshot());
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return ret;
    }

    private List<EC2Snapshot> createSnapshotList(List<Snapshot> snapshots) {
        ArrayList<EC2Snapshot> ret = new ArrayList<EC2Snapshot>();
        for (Snapshot s : snapshots) {
            EC2Snapshot snap = new EC2Snapshot();
            snap.setDescription(s.getDescription());
            snap.setOwnerAlias(s.getOwnerAlias());
            snap.setOwnerId(s.getOwnerId());
            snap.setProgress(s.getProgress());
            snap.setSnapshotId(s.getSnapshotId());
            snap.setStartTime(s.getStartTime());
            snap.setStatus(s.getStatus());
            snap.setVolumeId(s.getVolumeId());
            snap.setVolumeSize(s.getVolumeSize());
            ret.add(snap);
        }
        return ret;
    }

    public List<EC2Volume> describeVolumes(EC2DescribeVolumesRequest request) {
        DescribeVolumesRequest req = new DescribeVolumesRequest();
        req.setVolumeId(request.getVolumeIds());
        ArrayList<EC2Volume> ret = new ArrayList();
        try {
            ret = this.createEC2VolumeList(this.client.describeVolumes(req));
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return ret;
    }

    private List<EC2Volume> createEC2VolumeList(DescribeVolumesResponse response) {
        ArrayList<EC2Volume> ret = new ArrayList<EC2Volume>();
        for (Volume volume : response.getDescribeVolumesResult().getVolume()) {
            EC2Volume v = new EC2Volume();
            v.setVolumeId(volume.getVolumeId());
            v.setSize(volume.getSize());
            v.setCreateTime(volume.getCreateTime());
            v.setSnapshotId(volume.getSnapshotId());
            v.setAvailabilityZone(volume.getAvailabilityZone());
            v.setStatus(volume.getStatus());
            ArrayList<EC2Attachment> attachments = new ArrayList<EC2Attachment>();
            for (Attachment attachment : volume.getAttachment()) {
                EC2Attachment a = new EC2Attachment();
                a.setVolumeId(attachment.getVolumeId());
                a.setInstanceId(attachment.getInstanceId());
                a.setStatus(attachment.getStatus());
                a.setDevice(attachment.getDevice());
                a.setAttachTime(attachment.getAttachTime());
                a.setDeleteOnTermination(attachment.isDeleteOnTermination());
                attachments.add(a);
            }
            v.setAttachment(attachments);
            ret.add(v);
        }
        return ret;
    }

    public List<EC2Volume> detachVolume(EC2DetachVolumeRequest request) {
        DetachVolumeRequest req = new DetachVolumeRequest();
        req.setDevice(request.getDevice());
        req.setForce(Boolean.valueOf(request.isForce()));
        req.setInstanceId(request.getInstanceId());
        req.setVolumeId(request.getVolumeId());
        try {
            this.client.detachVolume(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public List<EC2Address> disassociateAddress(EC2DisassociateAddressRequest request) {
        try {
            this.client.disassociateAddress(new DisassociateAddressRequest(request.getPublicIp()));
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public List<EC2ConsoleOutput> getConsoleOutput(EC2GetConsoleOutputRequest reqeust) {
        return null;
    }

    public List<EC2ImageAttribute> modifyImageAttribute(EC2ModifyAttributeRequest request) {
        return null;
    }

    public List<EC2Instance> rebootInstances(EC2RebootInstancesRequest request) {
        RebootInstancesRequest req = new RebootInstancesRequest();
        req.setInstanceId(req.getInstanceId());
        try {
            this.client.rebootInstances(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public List<EC2Image> registerImage(EC2RegisterImageRequest request) {
        return null;
    }

    public List<EC2Address> releaseAddress(EC2ReleaseAddressRequest request) {
        try {
            this.client.releaseAddress(new ReleaseAddressRequest(request.getPublicIp()));
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public List<EC2Image> resetImageAttribute(EC2ResetImageAttributeRequest request) {
        return null;
    }

    public List<EC2SecurityGroup> revokeSecurityGroupIngress(EC2RevokeSecurityGroupIngressRequest request) {
        RevokeSecurityGroupIngressRequest req = new RevokeSecurityGroupIngressRequest();
        req.setGroupName(request.getGroupName());
        req.setFromPort(request.getFromPort());
        req.setToPort(request.getToPort());
        req.setIpProtocol(request.getIpProtocol());
        req.setCidrIp(request.getCidrIp());
        req.setSourceSecurityGroupName(request.getSourceSecurityGroupName());
        req.setSourceSecurityGroupOwnerId(request.getSourceSecurityGroupOwnerId());
        try {
            this.client.revokeSecurityGroupIngress(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public EC2Reservation runInstances(EC2RunInstanceRequest request) {
        RunInstancesRequest req = new RunInstancesRequest();
        req.setAdditionalInfo(request.getAdditionalInfo());
        req.setImageId(request.getImageId());
        req.setInstanceType(request.getInstanceType());
        req.setKernelId(request.getKernelId());
        req.setKeyName(request.getKeyName());
        req.setMaxCount(request.getMaxCount());
        req.setMinCount(request.getMinCount());
        Placement placement = new Placement();
        placement.setAvailabilityZone(request.getAvailabilityZone());
        req.setPlacement(placement);
        req.setRamdiskId(request.getRamdiskId());
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(request.getGroupId());
        req.setSecurityGroup(groups);
        try {
            this.client.runInstances(req);
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public List<EC2Instance> terminateInstances(EC2TerminateInstancesRequest request) {
        try {
            this.client.terminateInstances(new TerminateInstancesRequest(request.getInstanceId()));
        }
        catch (AmazonEC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }
}

