/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.transport.EC2AvailabilityZone;
import jp.co.intellilink.aws.api.transport.EC2Snapshot;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CreateVolumeWizardPage
extends WizardPage {
    private static final String[][] FROM = new String[][]{{"Size(GB)", "size"}, {"Snapshot", "snapshot"}};
    private final IPreferenceStore store;
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private ComboFieldEditor zoneCombo;
    private String[][] zones;
    private RadioGroupFieldEditor fromRadio;
    private IntegerFieldEditor sizeEditor;
    private ComboFieldEditor snapshotCombo;
    private String[][] snapshots;

    protected CreateVolumeWizardPage(IPreferenceStore store) {
        super("Create Volume");
        this.setTitle("New Volume");
        this.setDescription("Please input volume setting.");
        this.store = store;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        final Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        this.zoneCombo = new ComboFieldEditor("zone", "Availability Zones", this.zones, composite);
        this.zoneCombo.setPreferenceStore(this.store);
        this.zoneCombo.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                CreateVolumeWizardPage.this.zoneCombo.store();
            }
        });
        this.editors.add((FieldEditor)this.zoneCombo);
        this.fromRadio = new RadioGroupFieldEditor("from", "Create New Volume From", 2, FROM, composite);
        this.fromRadio.setPreferenceStore(this.store);
        this.fromRadio.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("size".equals(event.getNewValue())) {
                    CreateVolumeWizardPage.this.sizeEditor.setEnabled(true, composite);
                    CreateVolumeWizardPage.this.snapshotCombo.setEnabled(false, composite);
                } else if ("snapshot".equals(event.getNewValue())) {
                    CreateVolumeWizardPage.this.sizeEditor.setEnabled(false, composite);
                    CreateVolumeWizardPage.this.snapshotCombo.setEnabled(true, composite);
                }
                CreateVolumeWizardPage.this.fromRadio.store();
            }
        });
        this.editors.add((FieldEditor)this.fromRadio);
        this.sizeEditor = new IntegerFieldEditor("size", "Size(GB)", composite);
        this.sizeEditor.setPreferenceStore(this.store);
        this.sizeEditor.setValidRange(1, 999);
        this.sizeEditor.setTextLimit(3);
        this.sizeEditor.setEnabled(false, composite);
        this.sizeEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                try {
                    if (1 <= CreateVolumeWizardPage.this.sizeEditor.getIntValue() && CreateVolumeWizardPage.this.sizeEditor.getIntValue() < 1000) {
                        CreateVolumeWizardPage.this.sizeEditor.setErrorMessage(null);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                CreateVolumeWizardPage.this.sizeEditor.setErrorMessage("Allowed Integer Only (1 - 999)");
            }
        });
        this.editors.add((FieldEditor)this.sizeEditor);
        this.snapshotCombo = new ComboFieldEditor("snapshot", "Snapshot", this.snapshots, composite);
        this.snapshotCombo.setPreferenceStore(this.store);
        this.snapshotCombo.setEnabled(false, composite);
        this.editors.add((FieldEditor)this.snapshotCombo);
        this.setControl((Control)parent);
    }

    public void setZones(List<EC2AvailabilityZone> zones) {
        this.zones = new String[zones.size()][2];
        int i = 0;
        for (EC2AvailabilityZone zone : zones) {
            this.zones[i][0] = zone.getZoneName();
            this.zones[i][1] = zone.getZoneName();
            ++i;
        }
    }

    public void setSnapshots(List<EC2Snapshot> snapshots) {
        this.snapshots = new String[snapshots.size()][2];
        int i = 0;
        for (EC2Snapshot snap : snapshots) {
            this.snapshots[i][0] = snap.getSnapshotId();
            this.snapshots[i][1] = snap.getSnapshotId();
            ++i;
        }
    }

    public boolean onFinish() {
        block8: {
            if (this.store.getString("zone").isEmpty()) {
                return false;
            }
            if (this.store.getString("from").isEmpty()) {
                return false;
            }
            if ("size".equals(this.store.getString("from"))) {
                try {
                    if (1 <= this.sizeEditor.getIntValue() && this.sizeEditor.getIntValue() < 1000) {
                        this.sizeEditor.store();
                        break block8;
                    }
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if ("snapshot".equals(this.store.getString("from"))) {
                this.snapshotCombo.store();
                if (this.store.getString("snapshot").isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }
}

