/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.CreateSnapshotAction;
import jp.co.intellilink.aws.ui.action.CreateVolumeAction;
import jp.co.intellilink.aws.ui.action.DeleteVolumeAction;
import jp.co.intellilink.aws.ui.action.DescribeVolumesAction;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.VolumeLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class VolumeView
extends ViewPart {
    private ActionCallbackHandler handler;
    private DescribeVolumesAction describeVolumesAction;
    private CreateVolumeAction createVolumeAction;
    private DeleteVolumeAction deleteVolumeAction;
    private CreateSnapshotAction createSnapshotAction;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        TableViewer viewer = new TableViewer(parent);
        Table tree = viewer.getTable();
        TableColumn volumeId = new TableColumn(tree, 0);
        volumeId.setText("Volume ID");
        volumeId.setWidth(120);
        TableColumn status = new TableColumn(tree, 0);
        status.setText("Status");
        status.setWidth(90);
        TableColumn size = new TableColumn(tree, 0);
        size.setText("Size(GB)");
        size.setWidth(70);
        TableColumn snapshotId = new TableColumn(tree, 0);
        snapshotId.setText("Parent Snapshot");
        snapshotId.setWidth(130);
        TableColumn instanceId = new TableColumn(tree, 0);
        instanceId.setText("Instance Id");
        instanceId.setWidth(100);
        TableColumn device = new TableColumn(tree, 0);
        device.setText("Device");
        device.setWidth(70);
        TableColumn availabilityZone = new TableColumn(tree, 0);
        availabilityZone.setText("Availability Zone");
        availabilityZone.setWidth(140);
        TableColumn createTime = new TableColumn(tree, 0);
        createTime.setText("Create Time");
        createTime.setWidth(90);
        tree.setHeaderVisible(true);
        tree.pack(false);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new VolumeLabelProvider());
        this.handler = new ActionCallbackHandler((Viewer)viewer);
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        this.describeVolumesAction = new DescribeVolumesAction(this.handler);
        this.createVolumeAction = new CreateVolumeAction(this.handler);
        this.deleteVolumeAction = new DeleteVolumeAction(this.handler);
        this.createSnapshotAction = new CreateSnapshotAction(null);
        manager.add((IAction)this.describeVolumesAction);
        manager.add((IAction)this.createVolumeAction);
        manager.add((IAction)this.deleteVolumeAction);
        manager.add((IAction)this.createSnapshotAction);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)VolumeView.this.describeVolumesAction);
                manager.add((IAction)VolumeView.this.createVolumeAction);
                manager.add((IAction)VolumeView.this.deleteVolumeAction);
                manager.add((IAction)VolumeView.this.createSnapshotAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.deleteVolumeAction);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.createSnapshotAction);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    public void setFocus() {
        if (Activator.getDefault().getProvider().canGetEC2()) {
            this.describeVolumesAction.run();
        }
    }
}

