/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2RebootInstancesRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.model.InstanceModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class RebootInstanceJob
extends Job {
    private ActionCallbackHandler handler;
    private List<InstanceModel> models;

    public RebootInstanceJob(String name, ActionCallbackHandler handler, List<InstanceModel> models) {
        super(name);
        this.handler = handler;
        this.models = models;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Delete Volumes.", 10);
        monitor.setTaskName("Delete Volumes");
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        ElasticComputingCloudInterface client = null;
        monitor.worked(30);
        monitor.setTaskName("Request Generating...");
        final ArrayList items = new ArrayList();
        try {
            client = provider.getEC2();
            ArrayList<String> instanceId = new ArrayList<String>();
            for (InstanceModel instance : this.models) {
                instanceId.add(instance.getInstanceId());
            }
            EC2RebootInstancesRequest request = new EC2RebootInstancesRequest(instanceId);
            client.rebootInstances(request);
            items.addAll(client.describeInstance(new EC2DescribeInstanceRequest()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        if (this.handler != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    RebootInstanceJob.this.handler.onDescribeInstancesExecuted(items);
                }
            });
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

