/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.action;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2AvailabilityZone;
import jp.co.intellilink.aws.api.transport.EC2DescribeAvailabilityZonesRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeKeyPairsRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeSecurityGroupRequest;
import jp.co.intellilink.aws.api.transport.EC2KeyPair;
import jp.co.intellilink.aws.api.transport.EC2RunInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2SecurityGroup;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.CallbackAction;
import jp.co.intellilink.aws.ui.model.ImageModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.Messages;
import jp.co.intellilink.aws.ui.wizard.RunInstanceWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RunInstanceAction
extends CallbackAction
implements ISelectionChangedListener {
    private ImageModel model;

    public RunInstanceAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("RunInstanceAction.0"));
        this.setEnabled(false);
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/monitor_add.png"));
    }

    public void run() {
        super.run();
        Job job = new Job(Messages.getString("RunInstanceAction.2")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(String.valueOf(RunInstanceAction.this.model.getImageId()) + Messages.getString("RunInstanceAction.3"), 10);
                monitor.setTaskName(Messages.getString("RunInstanceAction.4"));
                EC2ServiceProvider provider = Activator.getDefault().getProvider();
                monitor.worked(2);
                final ArrayList<String> availabilityZones = new ArrayList<String>();
                final ArrayList<String> keys = new ArrayList<String>();
                final ArrayList<String> groups = new ArrayList<String>();
                try {
                    ElasticComputingCloudInterface ec2 = provider.getEC2();
                    monitor.setTaskName(Messages.getString("RunInstanceAction.5"));
                    EC2DescribeAvailabilityZonesRequest zr = new EC2DescribeAvailabilityZonesRequest();
                    List zones = ec2.describeAvailabilityZones(zr);
                    for (EC2AvailabilityZone zt : zones) {
                        availabilityZones.add(zt.getZoneName());
                    }
                    monitor.worked(1);
                    monitor.setTaskName(Messages.getString("RunInstanceAction.6"));
                    EC2DescribeKeyPairsRequest keyRequest = new EC2DescribeKeyPairsRequest();
                    List keyPairs = ec2.describeKeyPairs(keyRequest);
                    for (EC2KeyPair kt : keyPairs) {
                        keys.add(kt.getKeyName());
                    }
                    monitor.worked(1);
                    monitor.setTaskName(Messages.getString("RunInstanceAction.7"));
                    EC2DescribeSecurityGroupRequest groupRequest = new EC2DescribeSecurityGroupRequest();
                    List securityGroups = ec2.describeSecurityGroups(groupRequest);
                    for (EC2SecurityGroup gt : securityGroups) {
                        groups.add(gt.getName());
                    }
                    final PreferenceStore store = new PreferenceStore();
                    store.setValue("imageId", RunInstanceAction.this.model.getImageId());
                    if (RunInstanceAction.this.model.getKernel() != null) {
                        store.setValue("kernelId", RunInstanceAction.this.model.getKernel().getImageId());
                    }
                    if (RunInstanceAction.this.model.getRamdisk() != null) {
                        store.setValue("ramdiskId", RunInstanceAction.this.model.getRamdisk().getImageId());
                    }
                    store.setValue("min", 1);
                    store.setValue("max", 1);
                    monitor.setTaskName(Messages.getString("RunInstanceAction.13"));
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            RunInstanceWizard wizard = new RunInstanceWizard((IPreferenceStore)store, groups, availabilityZones, keys);
                            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                            dialog.open();
                            int code = dialog.getReturnCode();
                            store.setValue("result", code);
                        }
                    });
                    if (store.getInt("result") == 0) {
                        monitor.setTaskName(Messages.getString("RunInstanceAction.16"));
                        monitor.worked(3);
                        EC2RunInstanceRequest request = new EC2RunInstanceRequest();
                        request.setImageId(store.getString("imageId"));
                        if (!store.getString("kernelId").equals("")) {
                            request.setKernelId(store.getString("kernelId"));
                        }
                        if (!store.getString("ramdiskId").equals("")) {
                            request.setRamdiskId(store.getString("ramdiskId"));
                        }
                        request.setInstanceType(store.getString("type"));
                        request.setMinCount(store.getInt("min"));
                        request.setMaxCount(store.getInt("max"));
                        request.setKeyName(store.getString("key"));
                        if (!store.getString("additinonalIndo").isEmpty()) {
                            request.setAdditionalInfo(store.getString("additinonalIndo"));
                        }
                        request.setAvailabilityZone(store.getString("availabilityZone"));
                        request.setGroupId(store.getString("securityGroup"));
                        ec2.runInstances(request);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("jp.co.intellilink.aws.ui.view.instances");
                                }
                                catch (PartInitException e) {
                                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("RunInstanceAction.32"), (String)e.getMessage());
                                }
                            }
                        });
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("RunInstanceAction.33"), (String)e.getMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof ImageModel) {
            this.model = (ImageModel)selection.getFirstElement();
            if ("machine".equals(this.model.getType())) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }
}

