/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.action;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeImagesRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.CallbackAction;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DescribeImagesAction
extends CallbackAction {
    public DescribeImagesAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("DescribeImagesAction.0"));
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/refresh.png"));
    }

    public void run() {
        super.run();
        Job job = new Job(Messages.getString("DescribeImagesAction.2")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("DescribeImagesAction.3"), 10);
                monitor.setTaskName(Messages.getString("DescribeImagesAction.4"));
                EC2ServiceProvider provider = Activator.getDefault().getProvider();
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    monitor.setTaskName(Messages.getString("DescribeImagesAction.5"));
                    ElasticComputingCloudInterface portType = provider.getEC2();
                    final List responseType = portType.describeImages(new EC2DescribeImagesRequest());
                    monitor.worked(8);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.setTaskName(Messages.getString("DescribeImagesAction.6"));
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DescribeImagesAction.this.getHandler().onDescribeImagesExecuted(responseType);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("DescribeImagesAction.7"), (String)e.getMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }
}

