/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.action;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeSecurityGroupRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.CallbackAction;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.Messages;
import jp.co.intellilink.aws.ui.wizard.CreateKeyPairWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddGroupRuleAction
extends CallbackAction {
    public AddGroupRuleAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("AddGroupRuleAction.0"));
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/key_add.png"));
    }

    public void run() {
        super.run();
        PreferenceStore store = new PreferenceStore();
        CreateKeyPairWizard wizard = new CreateKeyPairWizard((IPreferenceStore)store);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Job job = new Job(Messages.getString("AddGroupRuleAction.2")){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(Messages.getString("AddGroupRuleAction.3"), 10);
                        monitor.setTaskName(Messages.getString("AddGroupRuleAction.4"));
                        EC2ServiceProvider provider = Activator.getDefault().getProvider();
                        monitor.worked(2);
                        ElasticComputingCloudInterface ec2 = provider.getEC2();
                        monitor.setTaskName(Messages.getString("AddGroupRuleAction.1"));
                        EC2DescribeSecurityGroupRequest arg0 = new EC2DescribeSecurityGroupRequest();
                        List groups = ec2.describeSecurityGroups(arg0);
                        AddGroupRuleAction.this.getHandler().onDescribeSecurityGroupsExecuted(groups);
                        monitor.worked(2);
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("AddGroupRuleAction.6"), (String)e.getMessage());
                        return Status.CANCEL_STATUS;
                    }
                }
            };
            job.schedule();
        }
    }
}

