/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

public class AWSServiceProvider {
    private static final String EC2CLIENT = "jp.co.intellilink.aws.api.ec2client";
    private Map<String, ElasticComputingCloudInterface> ec2map = new HashMap<String, ElasticComputingCloudInterface>();
    private static AWSServiceProvider instance;

    public static final AWSServiceProvider getInstance() {
        if (instance == null) {
            instance = new AWSServiceProvider();
        }
        return instance;
    }

    private void loadEC2Interface() {
        IExtension[] extensions;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EC2CLIENT);
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                try {
                    Object object = elem.createExecutableExtension("class");
                    ElasticComputingCloudInterface ec2 = (ElasticComputingCloudInterface)object;
                    ec2.setName(elem.getAttribute("name"));
                    ec2.setDescription(elem.getAttribute("desc"));
                    this.ec2map.put(ec2.getName(), ec2);
                }
                catch (InvalidRegistryObjectException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
    }

    public ElasticComputingCloudInterface getEC2Interface(String name) {
        if (this.ec2map.isEmpty()) {
            this.loadEC2Interface();
        }
        return this.ec2map.get(name);
    }

    public String[][] getEC2Instances() {
        if (this.ec2map.isEmpty()) {
            this.loadEC2Interface();
        }
        String[][] rv = new String[this.ec2map.keySet().size()][2];
        Collection<ElasticComputingCloudInterface> values = this.ec2map.values();
        int i = 0;
        for (ElasticComputingCloudInterface ec2 : values) {
            rv[i][1] = ec2.getName();
            rv[i][0] = String.valueOf(ec2.getName()) + " --- " + ec2.getDescription();
            ++i;
        }
        return rv;
    }
}

