/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.wizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AttachVolumeDeviceSettingPage
extends WizardPage {
    private final IPreferenceStore store;
    private List<String> usedDevice;
    private ComboFieldEditor deviceComboEditor;
    private static final List<String> ALL_DEVICE;

    static {
        char start = 'b';
        ArrayList<String> allDevice = new ArrayList<String>();
        int i = 0;
        while (i <= 24) {
            allDevice.add("/dev/sd" + String.valueOf(start));
            start = (char)(start + '\u0001');
            ++i;
        }
        ALL_DEVICE = allDevice;
    }

    protected AttachVolumeDeviceSettingPage(String pageName, IPreferenceStore store, List<String> usedDevice) {
        super(pageName);
        this.store = store;
        this.usedDevice = usedDevice;
        this.setTitle("Attach Volume");
        this.setDescription("Please select device for attaching volume.");
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        this.deviceComboEditor = new ComboFieldEditor("device", "Device", this.createDevices(), composite);
        this.deviceComboEditor.setPreferenceStore(this.store);
        this.setControl((Control)parent);
    }

    private String[][] createDevices() {
        ArrayList<String> devices = new ArrayList<String>(ALL_DEVICE);
        devices.removeAll(this.usedDevice);
        String[][] ret = new String[devices.size()][2];
        int count = 0;
        Iterator iterator = devices.iterator();
        while (iterator.hasNext()) {
            String device;
            ret[count][0] = device = (String)iterator.next();
            ret[count][1] = device;
            ++count;
        }
        return ret;
    }

    public void onFinish() {
        this.deviceComboEditor.store();
    }
}

