/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DetachVolumeRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DetachVolumeJob
extends Job {
    private String volumeId;

    public DetachVolumeJob(String name, String volumeId) {
        super(name);
        this.volumeId = volumeId;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("AddIpPermission", 0);
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        monitor.worked(30);
        monitor.setTaskName("Add Ip Permission...");
        try {
            ElasticComputingCloudInterface client = provider.getEC2();
            monitor.worked(60);
            EC2DetachVolumeRequest request = new EC2DetachVolumeRequest();
            request.setVolumeId(this.volumeId);
            client.detachVolume(request);
            monitor.worked(90);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

