/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DeleteSecurityGroupRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.model.SecurityGroupModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DeleteSecurityGroupJob
extends Job {
    private List<SecurityGroupModel> models;
    private ActionCallbackHandler handler;

    public DeleteSecurityGroupJob(String name, ActionCallbackHandler handler, List<SecurityGroupModel> models) {
        super(name);
        this.handler = handler;
        this.models = models;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Delete Security Groups.", 10);
        monitor.setTaskName("Delete Security Groups");
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        ElasticComputingCloudInterface client = null;
        final ArrayList ret = new ArrayList();
        try {
            client = provider.getEC2();
            for (SecurityGroupModel model : this.models) {
                EC2DeleteSecurityGroupRequest request = new EC2DeleteSecurityGroupRequest();
                request.setGroupName(model.getName());
                client.deleteSecurityGroup(request);
                ret.addAll(client.describeSecurityGroups(null));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        if (this.handler != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DeleteSecurityGroupJob.this.handler.onDescribeSecurityGroupsExecuted(ret);
                }
            });
        }
        return Status.OK_STATUS;
    }
}

