/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.ArrayList;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2CreateSnapshotRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeSnapshotRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.model.VolumeModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class CreateSnapshotJob
extends Job {
    private ActionCallbackHandler handler;
    private VolumeModel volume;

    public CreateSnapshotJob(String name, ActionCallbackHandler handler, VolumeModel volume) {
        super(name);
        this.handler = handler;
        this.volume = volume;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Create Snapshot.", 10);
        monitor.setTaskName("Create Snapshot");
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        ElasticComputingCloudInterface client = null;
        monitor.worked(30);
        final ArrayList snapshots = new ArrayList();
        try {
            client = provider.getEC2();
            EC2CreateSnapshotRequest request = new EC2CreateSnapshotRequest();
            request.setVolumeId(this.volume.getVolumeId());
            client.createSnapshot(request);
            monitor.worked(80);
            snapshots.addAll(client.describeSnapshot(new EC2DescribeSnapshotRequest()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        monitor.worked(90);
        if (this.handler != null && snapshots != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    CreateSnapshotJob.this.handler.onDescribeSnapshots(snapshots);
                }
            });
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

