/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.action;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2KeyPair;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.CallbackAction;
import jp.co.intellilink.aws.ui.model.KeyPairModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteKeyPairAction
extends CallbackAction
implements ISelectionChangedListener {
    private KeyPairModel model;

    public DeleteKeyPairAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("DeleteKeyPairAction.0"));
        this.setEnabled(false);
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/key_delete.png"));
    }

    public void run() {
        super.run();
        Job job = new Job(Messages.getString("DeleteKeyPairAction.2")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(String.valueOf(DeleteKeyPairAction.this.model.getKeyName()) + Messages.getString("DeleteKeyPairAction.3"), 10);
                monitor.setTaskName(Messages.getString("DeleteKeyPairAction.4"));
                EC2ServiceProvider provider = Activator.getDefault().getProvider();
                monitor.worked(2);
                try {
                    ElasticComputingCloudInterface ec2 = provider.getEC2();
                    monitor.setTaskName(Messages.getString("DeleteKeyPairAction.5"));
                    EC2KeyPair dt = new EC2KeyPair(DeleteKeyPairAction.this.model.getKeyName(), DeleteKeyPairAction.this.model.getKeyFingerprint(), null);
                    dt.setKeyName(DeleteKeyPairAction.this.model.getKeyName());
                    ec2.deleteKeyPair(dt);
                    monitor.worked(5);
                    monitor.setTaskName(Messages.getString("DeleteKeyPairAction.6"));
                    final List describeKeyPairs = ec2.describeKeyPairs(null);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DeleteKeyPairAction.this.getHandler().onDescribeKeyPairsExecuted(describeKeyPairs);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("DeleteKeyPairAction.7"), (String)e.getMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof KeyPairModel) {
            this.model = (KeyPairModel)selection.getFirstElement();
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

