/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.action;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeAvailabilityZonesRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeSnapshotRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.CallbackAction;
import jp.co.intellilink.aws.ui.job.CreateVolumeJob;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.wizard.CreateVolumeWizard;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public class CreateVolumeAction
extends CallbackAction {
    public CreateVolumeAction(ActionCallbackHandler handler) {
        super(handler, "Create New Volume");
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/ebs_add.png"));
    }

    public void run() {
        super.run();
        PreferenceStore store = new PreferenceStore();
        List zones = null;
        List snapshots = null;
        try {
            ElasticComputingCloudInterface client = Activator.getDefault().getProvider().getEC2();
            zones = client.describeAvailabilityZones(new EC2DescribeAvailabilityZonesRequest());
            snapshots = client.describeSnapshot(new EC2DescribeSnapshotRequest());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
        CreateVolumeWizard wizard = new CreateVolumeWizard((IPreferenceStore)store, zones, snapshots);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            CreateVolumeJob job = new CreateVolumeJob((IPreferenceStore)store, this.getHandler());
            job.schedule();
        }
    }
}

