/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.action;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2CreateKeyPairRequest;
import jp.co.intellilink.aws.api.transport.EC2KeyPair;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.CallbackAction;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.Messages;
import jp.co.intellilink.aws.ui.wizard.CreateKeyPairWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateKeypairAction
extends CallbackAction {
    public CreateKeypairAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("CreateKeypairAction.0"));
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/key_add.png"));
    }

    public void run() {
        super.run();
        PreferenceStore store = new PreferenceStore();
        CreateKeyPairWizard wizard = new CreateKeyPairWizard((IPreferenceStore)store);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Job job = new Job(Messages.getString("CreateKeypairAction.2"), (IPreferenceStore)store){
                private final /* synthetic */ IPreferenceStore val$store;
                {
                    this.val$store = iPreferenceStore;
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString("CreateKeypairAction.3"), 10);
                    monitor.setTaskName(Messages.getString("CreateKeypairAction.4"));
                    EC2ServiceProvider provider = Activator.getDefault().getProvider();
                    monitor.worked(2);
                    try {
                        ElasticComputingCloudInterface ec2 = provider.getEC2();
                        monitor.setTaskName(Messages.getString("CreateKeypairAction.5"));
                        EC2CreateKeyPairRequest request = new EC2CreateKeyPairRequest();
                        request.setKeyName(this.val$store.getString("keyname"));
                        EC2KeyPair keyPair = ec2.createKeyPair(request);
                        String material = keyPair.getKeyMaterial();
                        monitor.worked(5);
                        String file = this.val$store.getString("keyFile");
                        monitor.setTaskName(Messages.getString("CreateKeypairAction.8"));
                        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(file)));
                        writer.write(material);
                        writer.flush();
                        writer.close();
                        monitor.setTaskName(Messages.getString("CreateKeypairAction.9"));
                        final List keyPairs = ec2.describeKeyPairs(null);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                CreateKeypairAction.this.getHandler().onDescribeKeyPairsExecuted(keyPairs);
                            }
                        });
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("CreateKeypairAction.10"), (String)e.getMessage());
                        return Status.CANCEL_STATUS;
                    }
                    catch (IOException e) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("CreateKeypairAction.11"), (String)e.getMessage());
                        return Status.CANCEL_STATUS;
                    }
                }
            };
            job.schedule();
        }
    }
}

