/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.zipcode;

import fuku.eb4j.util.HexUtil;
import fuku.xml2eb.util.FontUtil;
import java.awt.Font;
import java.awt.image.BufferedImage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipCodeUtil {
    private static final Log _log = LogFactory.getLog(ZipCodeUtil.class);
    private static final Font[] LOGICAL_FONT = new Font[]{new Font("SansSerif", 0, 1), new Font("Serif", 0, 1), new Font("Monospaced", 0, 1), new Font("Dialog", 0, 1), new Font("DialogInput", 0, 1)};

    private ZipCodeUtil() {
    }

    public static BufferedImage toImage(int codePoint) {
        String type = FontUtil.getFontType((int)codePoint);
        Font font = ZipCodeUtil.getFont(codePoint);
        BufferedImage img = null;
        if (font.canDisplay(codePoint)) {
            img = "narrow".equals(type) ? FontUtil.charToImage((int)codePoint, (int)8, (int)16, (Font)font) : FontUtil.charToImage((int)codePoint, (int)16, (int)16, (Font)font);
        } else {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
            String code = "U+" + HexUtil.toHexString((int)codePoint, (int)6);
            _log.warn((Object)("unavailable display font: [" + code + "]" + " " + unicodeBlock.toString()));
            codePoint = 63;
            font = ZipCodeUtil.getFont(codePoint);
            img = "narrow".equals(type) ? FontUtil.charToImage((int)codePoint, (int)8, (int)16, (Font)font) : FontUtil.charToImage((int)codePoint, (int)16, (int)16, (Font)font);
        }
        return img;
    }

    private static Font getFont(int codePoint) {
        int len = LOGICAL_FONT.length;
        for (int i = 0; i < len; ++i) {
            if (!LOGICAL_FONT[i].canDisplay(codePoint)) continue;
            return LOGICAL_FONT[i];
        }
        return LOGICAL_FONT[0];
    }

    public static String toFullwidth(String str, String ref) {
        if (str == null) {
            return null;
        }
        int refIdx = 0;
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int ch1 = str.charAt(i);
            if (Character.isHighSurrogate((char)ch1) || Character.isLowSurrogate((char)ch1)) {
                buf.append((char)ch1);
                continue;
            }
            block0 : switch (ch1) {
                case 45: {
                    int[] idx = new int[]{ref.indexOf("\u301c", refIdx), ref.indexOf("\u2212", refIdx), ref.indexOf("\u30fc", refIdx)};
                    int x = -1;
                    int n = idx.length;
                    for (int j = 0; j < n; ++j) {
                        if (idx[j] == -1) continue;
                        if (x == -1) {
                            x = j;
                            continue;
                        }
                        if (idx[j] >= idx[x]) continue;
                        x = j;
                    }
                    switch (x) {
                        case 0: {
                            ch1 = 12316;
                            refIdx = idx[x] + 1;
                            break block0;
                        }
                        case 1: {
                            ch1 = 8722;
                            refIdx = idx[x] + 1;
                            break block0;
                        }
                        case 2: {
                            ch1 = 12540;
                            refIdx = idx[x] + 1;
                            break block0;
                        }
                    }
                    refIdx = ref.length();
                    break;
                }
                case 40: {
                    ch1 = 65288;
                    break;
                }
                case 41: {
                    ch1 = 65289;
                    break;
                }
                case 65380: {
                    ch1 = 12289;
                    break;
                }
                case 65383: 
                case 65384: 
                case 65385: 
                case 65386: 
                case 65387: {
                    ch1 = (char)(12449 + (ch1 - 65383) * 2);
                    break;
                }
                case 65388: 
                case 65389: 
                case 65390: {
                    ch1 = (char)(12515 + (ch1 - 65388) * 2);
                    break;
                }
                case 65391: {
                    ch1 = 12483;
                    break;
                }
                case 65393: 
                case 65394: 
                case 65395: 
                case 65396: 
                case 65397: {
                    ch1 = (char)(12450 + (ch1 - 65393) * 2);
                    break;
                }
                case 65398: 
                case 65399: 
                case 65400: 
                case 65401: 
                case 65402: 
                case 65403: 
                case 65404: 
                case 65405: 
                case 65406: 
                case 65407: 
                case 65408: 
                case 65409: {
                    ch1 = (char)(12459 + (ch1 - 65398) * 2);
                    break;
                }
                case 65410: 
                case 65411: 
                case 65412: {
                    ch1 = (char)(12484 + (ch1 - 65410) * 2);
                    break;
                }
                case 65413: 
                case 65414: 
                case 65415: 
                case 65416: 
                case 65417: {
                    ch1 = (char)(12490 + ch1 - 65413);
                    break;
                }
                case 65418: 
                case 65419: 
                case 65420: 
                case 65421: 
                case 65422: {
                    ch1 = (char)(12495 + (ch1 - 65418) * 3);
                    break;
                }
                case 65423: 
                case 65424: 
                case 65425: 
                case 65426: 
                case 65427: {
                    ch1 = (char)(12510 + ch1 - 65423);
                    break;
                }
                case 65428: 
                case 65429: 
                case 65430: {
                    ch1 = (char)(12516 + (ch1 - 65428) * 2);
                    break;
                }
                case 65431: 
                case 65432: 
                case 65433: 
                case 65434: 
                case 65435: {
                    ch1 = (char)(12521 + ch1 - 65431);
                    break;
                }
                case 65436: {
                    ch1 = 12527;
                    break;
                }
                case 65382: {
                    ch1 = 12530;
                    break;
                }
                case 65437: {
                    ch1 = 12531;
                    break;
                }
                case 65392: {
                    ch1 = 12540;
                    break;
                }
                case 65438: {
                    ch1 = 12443;
                    break;
                }
                case 65439: {
                    ch1 = 12444;
                    break;
                }
                default: {
                    if (ch1 < 33 || ch1 > 126) break;
                    ch1 = (char)(ch1 + 65248);
                }
            }
            if (i + 1 == len) {
                buf.append((char)ch1);
                continue;
            }
            char ch2 = str.charAt(i + 1);
            if (Character.isHighSurrogate(ch2) || Character.isLowSurrogate(ch2)) {
                buf.append((char)ch1);
                buf.append(ch2);
                ++i;
                continue;
            }
            if (ch2 == '\uff9e') {
                switch (ch1) {
                    case 12454: {
                        ch1 = 12532;
                        ++i;
                        break;
                    }
                    case 12459: 
                    case 12461: 
                    case 12463: 
                    case 12465: 
                    case 12467: 
                    case 12469: 
                    case 12471: 
                    case 12473: 
                    case 12475: 
                    case 12477: 
                    case 12479: 
                    case 12481: 
                    case 12484: 
                    case 12486: 
                    case 12488: 
                    case 12495: 
                    case 12498: 
                    case 12501: 
                    case 12504: 
                    case 12507: {
                        ch1 = (char)(ch1 + 1);
                        ++i;
                        break;
                    }
                    case 12527: {
                        ch1 = 12535;
                        ++i;
                        break;
                    }
                    case 12530: {
                        ch1 = 12538;
                        ++i;
                        break;
                    }
                }
            } else if (ch2 == '\uff9f') {
                switch (ch1) {
                    case 12495: 
                    case 12498: 
                    case 12501: 
                    case 12504: 
                    case 12507: {
                        ch1 = (char)(ch1 + 2);
                        ++i;
                        break;
                    }
                }
            }
            buf.append((char)ch1);
        }
        return buf.toString();
    }
}

