/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.zipcode;

import fuku.eb4j.util.HexUtil;
import fuku.xml2eb.converter.zipcode.ZipCodeJigyosyo;
import fuku.xml2eb.converter.zipcode.ZipCodeKen;
import fuku.xml2eb.converter.zipcode.ZipCodeUtil;
import fuku.xml2eb.util.FontUtil;
import fuku.xml2eb.util.WordUtil;
import fuku.xml2eb.util.XmlUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ZipCode2Xml {
    private static final String _PROGRAM = ZipCode2Xml.class.getName();
    private static final String GAIJI_DIR = "gaiji";
    private static final String BOOK_XML = "book.xml";
    private static final String BOOK_TITLE1 = "\u90f5\u4fbf\u756a\u53f7";
    private static final String BOOK_TITLE2 = "\u90f5\u4fbf\u756a\u53f7(\u4e8b\u696d\u6240\u7b49\u500b\u5225)";
    private static final String BOOK_DIR1 = "zipcode";
    private static final String BOOK_DIR2 = "jigyosyo";
    private static final String BOOK_TYPE = "0x" + HexUtil.toHexString((int)96, (int)2);
    private Log _log = LogFactory.getLog(this.getClass());
    private File _basedir = null;
    private ZipCodeKen _ken = null;
    private ZipCodeJigyosyo _jigyosyo = null;
    private Map<String, String> _gaijiMap = null;
    private Map<String, String> _kenGaijiMap = null;
    private Map<String, String> _jigyosyoGaijiMap = null;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("java " + _PROGRAM + " [zipcode-directory]");
        } else {
            new ZipCode2Xml(args[0]).convert();
        }
    }

    public ZipCode2Xml(String path) {
        this(new File(path));
    }

    public ZipCode2Xml(File dir) {
        this._basedir = dir;
    }

    public void convert() throws ParserConfigurationException, IOException {
        File file = new File(this._basedir, "KEN_ALL.CSV");
        this._ken = new ZipCodeKen(file);
        file = new File(this._basedir, "JIGYOSYO.CSV");
        this._jigyosyo = new ZipCodeJigyosyo(file);
        this._kenGaijiMap = new TreeMap<String, String>();
        this._jigyosyoGaijiMap = new TreeMap<String, String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element book = doc.createElement("book");
        doc.appendChild(book);
        this._log.info((Object)"create zipcode subbook...");
        this._gaijiMap = this._kenGaijiMap;
        Element subbook = this._appendElement(book, "subbook");
        subbook.setAttribute("title", BOOK_TITLE1);
        subbook.setAttribute("dir", BOOK_DIR1);
        subbook.setAttribute("type", BOOK_TYPE);
        Element content = this._appendElement(subbook, "content");
        this._makeKenItemNode(content);
        this._makeKenMenuNode(content);
        this._makeKenCopyrightNode(content);
        this._makeFontNode(subbook);
        this._log.info((Object)"create jigyosyo subbook...");
        this._gaijiMap = this._jigyosyoGaijiMap;
        subbook = this._appendElement(book, "subbook");
        subbook.setAttribute("title", BOOK_TITLE2);
        subbook.setAttribute("dir", BOOK_DIR2);
        subbook.setAttribute("type", BOOK_TYPE);
        content = this._appendElement(subbook, "content");
        this._makeJigyosyoItemNode(content);
        this._makeJigyosyoMenuNode(content);
        this._makeJigyosyoCopyrightNode(content);
        this._makeFontNode(subbook);
        file = new File(this._basedir, BOOK_XML);
        this._log.info((Object)("write file: " + file.getPath()));
        XmlUtil.write((Document)doc, (File)file);
    }

    private void _makeKenItemNode(Element content) {
        Map<String, List<ZipCodeKen.Item>> map = this._ken.getZipcodeMap();
        for (Map.Entry<String, List<ZipCodeKen.Item>> entry : map.entrySet()) {
            String zipcode = entry.getKey();
            List<ZipCodeKen.Item> itemList = entry.getValue();
            Element itemElem = this._appendItem(content, "ZIPCODE:" + zipcode);
            Element headElem = this._appendElement(itemElem, "head");
            this._appendRawText(headElem, "\u3012" + zipcode);
            Element wordElem = this._appendElement(itemElem, "word");
            this._appendRawText(wordElem, zipcode);
            Element bodyElem = this._appendElement(itemElem, "body");
            Element keyElem = this._appendElement(bodyElem, "key");
            this._appendRawText(keyElem, "\u3012" + zipcode);
            this._appendNewLine(bodyElem);
            int n = itemList.size();
            for (int i = 0; i < n; ++i) {
                ZipCodeKen.Item item = itemList.get(i);
                String addr1 = item.getPrefecture() + item.getCity();
                String addr2 = item.getCity();
                if (!item.isException()) {
                    addr1 = addr1 + item.getTown();
                    addr2 = addr2 + item.getTown();
                }
                wordElem = this._appendElement(itemElem, "word");
                this._appendRawText(wordElem, addr1);
                wordElem = this._appendElement(itemElem, "word");
                this._appendRawText(wordElem, addr2);
                this._appendNewLine(bodyElem);
                this._appendRawText(bodyElem, "\u4f4f\u6240\uff1a");
                this._appendRawText(bodyElem, item.getPrefecture());
                this._appendRawText(bodyElem, " " + item.getCity());
                if (item.getTown() != null) {
                    if (item.isException()) {
                        this._appendRawText(bodyElem, " (" + item.getTown() + ")");
                    } else {
                        this._appendRawText(bodyElem, " " + item.getTown());
                    }
                    if (item.getArea() != null) {
                        this._appendRawText(bodyElem, " (" + item.getArea() + ")");
                    }
                }
                this._appendNewLine(bodyElem);
                this._appendRawText(bodyElem, "\u30ab\u30ca\uff1a");
                this._appendRawText(bodyElem, item.getKanaPrefecture());
                this._appendRawText(bodyElem, "-" + item.getKanaCity());
                if (item.getKanaTown() != null) {
                    this._appendRawText(bodyElem, "-" + item.getKanaTown());
                    if (item.getKanaArea() != null) {
                        this._appendRawText(bodyElem, " (" + item.getKanaArea() + ")");
                    }
                }
                this._appendNewLine(bodyElem);
            }
        }
    }

    private void _makeJigyosyoItemNode(Element content) {
        Map<String, List<ZipCodeJigyosyo.Item>> map = this._jigyosyo.getZipcodeMap();
        for (Map.Entry<String, List<ZipCodeJigyosyo.Item>> entry : map.entrySet()) {
            String zipcode = entry.getKey();
            List<ZipCodeJigyosyo.Item> itemList = entry.getValue();
            Element itemElem = this._appendItem(content, "ZIPCODE:" + zipcode);
            Element headElem = this._appendElement(itemElem, "head");
            this._appendRawText(headElem, "\u3012" + zipcode);
            Element wordElem = this._appendElement(itemElem, "word");
            this._appendRawText(wordElem, zipcode);
            Element bodyElem = this._appendElement(itemElem, "body");
            Element keyElem = this._appendElement(bodyElem, "key");
            this._appendRawText(keyElem, "\u3012" + zipcode);
            this._appendNewLine(bodyElem);
            int n = itemList.size();
            for (int i = 0; i < n; ++i) {
                ZipCodeJigyosyo.Item item = itemList.get(i);
                this._appendNewLine(bodyElem);
                this._appendRawText(bodyElem, "\u540d\u79f0\uff1a");
                this._appendRawText(bodyElem, item.getName());
                if (item.getIndex() > 0) {
                    this._appendRawText(bodyElem, " [" + item.getIndex() + "]");
                }
                this._appendNewLine(bodyElem);
                this._appendRawText(bodyElem, "\u30ab\u30ca\uff1a");
                this._appendRawText(bodyElem, item.getKanaName());
                this._appendNewLine(bodyElem);
                this._appendRawText(bodyElem, "\u4f4f\u6240\uff1a");
                this._appendRawText(bodyElem, item.getPrefecture());
                this._appendRawText(bodyElem, " " + item.getCity());
                this._appendRawText(bodyElem, " " + item.getTown());
                this._appendRawText(bodyElem, item.getArea());
                this._appendNewLine(bodyElem);
                this._appendRawText(bodyElem, "\u53d6\u6271\u90f5\u4fbf\u5c40\uff1a");
                this._appendRawText(bodyElem, item.getPostOffice());
                List<ZipCodeJigyosyo.Item> aliasList = this._jigyosyo.getItemList(item);
                int len = aliasList.size();
                for (int j = 0; j < len; ++j) {
                    this._appendNewLine(bodyElem);
                    item = aliasList.get(j);
                    this._appendRawText(bodyElem, "\u2192 ");
                    String refid = item.getZipcode();
                    Element refElem = this._appendIdReference(bodyElem, "ZIPCODE:" + refid);
                    this._appendRawText(refElem, "\u3012" + refid);
                }
                this._appendNewLine(bodyElem);
            }
        }
    }

    private void _makeKenMenuNode(Element content) {
        Element menu = this._appendElement(content, "menu");
        Element layerElem = this._appendLayer(menu, "INDEX:top");
        Map<String, Map<String, List<ZipCodeKen.Item>>> map = this._ken.getAddressMap();
        for (Map.Entry<String, Map<String, List<ZipCodeKen.Item>>> entry : map.entrySet()) {
            String key = entry.getKey();
            Map<String, List<ZipCodeKen.Item>> map1 = entry.getValue();
            this._appendRawText(layerElem, "\u21d2 ");
            Element refElem = this._appendIdReference(layerElem, "INDEX:" + key);
            this._appendRawText(refElem, key);
            this._appendNewLine(layerElem);
            Element layerElem1 = this._appendLayer(menu, "INDEX:" + key);
            refElem = this._appendIdReference(layerElem1, "INDEX:top");
            this._appendRawText(refElem, "\u4e00\u89a7");
            this._appendRawText(layerElem1, " > " + key);
            this._appendNewLine(layerElem1);
            for (Map.Entry<String, List<ZipCodeKen.Item>> entry1 : map1.entrySet()) {
                String key1 = entry1.getKey();
                List<ZipCodeKen.Item> list = entry1.getValue();
                if (list.size() == 1 && list.get(0).isException()) {
                    ZipCodeKen.Item item = list.get(0);
                    this._appendRawText(layerElem1, "\u2192 ");
                    refElem = this._appendIdReference(layerElem1, "ZIPCODE:" + item.getZipcode());
                    this._appendRawText(refElem, key1);
                    if (item.isException()) {
                        this._appendRawText(refElem, " (" + item.getTown() + ")");
                    } else {
                        this._appendRawText(refElem, item.getTown());
                    }
                    if (item.getArea() != null) {
                        this._appendRawText(refElem, " (" + item.getArea() + ")");
                    }
                    this._appendNewLine(layerElem1);
                    continue;
                }
                this._appendRawText(layerElem1, "\u21d2 ");
                refElem = this._appendIdReference(layerElem1, "INDEX:" + key + ":" + key1);
                this._appendRawText(refElem, key1);
                this._appendNewLine(layerElem1);
                Element layerElem2 = this._appendLayer(menu, "INDEX:" + key + ":" + key1);
                refElem = this._appendIdReference(layerElem2, "INDEX:top");
                this._appendRawText(refElem, "\u4e00\u89a7");
                this._appendRawText(layerElem2, " > ");
                refElem = this._appendIdReference(layerElem2, "INDEX:" + key);
                this._appendRawText(refElem, key);
                this._appendRawText(layerElem2, " > " + key1);
                this._appendNewLine(layerElem2);
                ZipCodeKen.Item other = null;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    ZipCodeKen.Item item = list.get(i);
                    if (item.getTown() == null) {
                        other = item;
                        continue;
                    }
                    this._appendRawText(layerElem2, "\u2192 ");
                    refElem = this._appendIdReference(layerElem2, "ZIPCODE:" + item.getZipcode());
                    if (item.isException()) {
                        this._appendRawText(refElem, "(" + item.getTown() + ")");
                    } else {
                        this._appendRawText(refElem, item.getTown());
                    }
                    if (item.getArea() != null) {
                        this._appendRawText(refElem, " (" + item.getArea() + ")");
                    }
                    this._appendNewLine(layerElem2);
                }
                if (other == null) continue;
                this._appendRawText(layerElem2, "\u2192 ");
                refElem = this._appendIdReference(layerElem2, "ZIPCODE:" + other.getZipcode());
                this._appendRawText(refElem, "(\u4e0a\u8a18\u4ee5\u5916)");
                this._appendNewLine(layerElem2);
            }
        }
    }

    private void _makeJigyosyoMenuNode(Element content) {
        Element menu = this._appendElement(content, "menu");
        Element layerElem = this._appendLayer(menu, "INDEX:top");
        Map<String, Map<String, List<ZipCodeJigyosyo.Item>>> map = this._jigyosyo.getAddressMap();
        for (Map.Entry<String, Map<String, List<ZipCodeJigyosyo.Item>>> entry : map.entrySet()) {
            String key = entry.getKey();
            Map<String, List<ZipCodeJigyosyo.Item>> map1 = entry.getValue();
            this._appendRawText(layerElem, "\u21d2 ");
            Element refElem = this._appendIdReference(layerElem, "INDEX:" + key);
            this._appendRawText(refElem, key);
            this._appendNewLine(layerElem);
            Element layerElem1 = this._appendLayer(menu, "INDEX:" + key);
            refElem = this._appendIdReference(layerElem1, "INDEX:top");
            this._appendRawText(refElem, "\u4e00\u89a7");
            this._appendRawText(layerElem1, " > " + key);
            this._appendNewLine(layerElem1);
            for (Map.Entry<String, List<ZipCodeJigyosyo.Item>> entry1 : map1.entrySet()) {
                String key1 = entry1.getKey();
                List<ZipCodeJigyosyo.Item> list = entry1.getValue();
                this._appendRawText(layerElem1, "\u21d2 ");
                refElem = this._appendIdReference(layerElem1, "INDEX:" + key + ":" + key1);
                this._appendRawText(refElem, key1);
                this._appendNewLine(layerElem1);
                Element layerElem2 = this._appendLayer(menu, "INDEX:" + key + ":" + key1);
                refElem = this._appendIdReference(layerElem2, "INDEX:top");
                this._appendRawText(refElem, "\u4e00\u89a7");
                this._appendRawText(layerElem2, " > ");
                refElem = this._appendIdReference(layerElem2, "INDEX:" + key);
                this._appendRawText(refElem, key);
                this._appendRawText(layerElem2, " > " + key1);
                this._appendNewLine(layerElem2);
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    ZipCodeJigyosyo.Item item = list.get(i);
                    this._appendRawText(layerElem2, "\u2192 ");
                    refElem = this._appendIdReference(layerElem2, "ZIPCODE:" + item.getZipcode());
                    this._appendRawText(refElem, item.getName());
                    if (item.getIndex() > 0) {
                        this._appendRawText(refElem, " [" + item.getIndex() + "]");
                    }
                    this._appendNewLine(layerElem2);
                }
            }
        }
    }

    private void _makeKenCopyrightNode(Element content) {
        Element copyright = this._appendElement(content, "copyright");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String[] lines = new String[]{"\u90f5\u4fbf\u756a\u53f7\u30c7\u30fc\u30bf JIS X4081\u7248", "", "\u30aa\u30ea\u30b8\u30ca\u30eb\u306e\u30c7\u30fc\u30bf\u306fhttp://www.post.japanpost.jp/zipcode/dl/kogaki.html\u304b\u3089\u5165\u624b\u3067\u304d\u307e\u3059\u3002", "\u3053\u306e\u30c7\u30fc\u30bf\u306f" + fmt.format(this._ken.getDate()) + "\u306e\u60c5\u5831\u306b\u57fa\u3065\u3044\u3066\u4f5c\u6210\u3055\u308c\u3066\u3044\u307e\u3059\u3002"};
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            this._appendRawText(copyright, lines[i]);
            this._appendNewLine(copyright);
        }
    }

    private void _makeJigyosyoCopyrightNode(Element content) {
        Element copyright = this._appendElement(content, "copyright");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String[] lines = new String[]{"\u90f5\u4fbf\u756a\u53f7\u30c7\u30fc\u30bf JIS X4081\u7248", "", "\u30aa\u30ea\u30b8\u30ca\u30eb\u306e\u30c7\u30fc\u30bf\u306fhttp://www.post.japanpost.jp/zipcode/dl/jigyosyo/index.html\u304b\u3089\u5165\u624b\u3067\u304d\u307e\u3059\u3002", "\u3053\u306e\u30c7\u30fc\u30bf\u306f" + fmt.format(this._jigyosyo.getDate()) + "\u306e\u60c5\u5831\u306b\u57fa\u3065\u3044\u3066\u4f5c\u6210\u3055\u308c\u3066\u3044\u307e\u3059\u3002"};
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            this._appendRawText(copyright, lines[i]);
            this._appendNewLine(copyright);
        }
    }

    private void _makeFontNode(Element subbook) {
        if (this._gaijiMap.isEmpty()) {
            return;
        }
        Element font = this._appendElement(subbook, "font");
        File gaiji = new File(this._basedir, GAIJI_DIR);
        for (Map.Entry<String, String> entry : this._gaijiMap.entrySet()) {
            String name = entry.getKey();
            String type = entry.getValue();
            File file = new File(gaiji, name + ".xbm");
            if (!file.exists()) {
                this._log.error((Object)("file not found: " + file.getPath()));
            }
            String path = FilenameUtils.concat((String)GAIJI_DIR, (String)file.getName());
            Element charElem = this._appendElement(font, "char");
            charElem.setAttribute("name", name);
            charElem.setAttribute("type", type);
            Element dataElem = this._appendElement(charElem, "data");
            dataElem.setAttribute("size", "16");
            dataElem.setAttribute("src", path);
        }
    }

    private void _appendRawText(Node node, String str) {
        if (str != null && str.trim().length() > 0) {
            Text text = node.getOwnerDocument().createTextNode(str);
            node.appendChild(text);
            this._checkCharacter(text);
        }
    }

    private Element _appendElement(Node node, String tag) {
        Element elem = node.getOwnerDocument().createElement(tag);
        return (Element)node.appendChild(elem);
    }

    private Element _appendNewLine(Node node) {
        return this._appendElement(node, "br");
    }

    private Element _appendItem(Node node, String id) {
        Element elem = this._appendElement(node, "item");
        elem.setAttribute("id", id);
        return elem;
    }

    private Element _appendIdReference(Node node, String id) {
        Element elem = this._appendElement(node, "ref");
        elem.setAttribute("id", id);
        return elem;
    }

    private Element _appendLayer(Node node, String id) {
        Element elem = this._appendElement(node, "layer");
        elem.setAttribute("id", id);
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkCharacter(Node node) {
        if (node.getNodeType() == 3) {
            Text text = (Text)node;
            String str = text.getNodeValue();
            int len = str.length();
            int idx = 0;
            while (idx < len) {
                String type;
                File file;
                int codePoint = str.codePointAt(idx);
                int cnt = Character.charCount(codePoint);
                if (WordUtil.isValidChar((int)codePoint)) {
                    idx += cnt;
                    continue;
                }
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
                String hex = HexUtil.toHexString((int)codePoint, (int)6);
                String name = "U" + hex;
                File dir = new File(this._basedir, GAIJI_DIR);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!(file = new File(dir, name + ".xbm")).exists()) {
                    String s = String.valueOf(Character.toChars(codePoint));
                    this._log.info((Object)("unsupported character: [U+" + hex + "]" + " '" + s + "'" + " " + unicodeBlock.toString()));
                    BufferedImage img = ZipCodeUtil.toImage(codePoint);
                    try {
                        FontUtil.writeXbm((BufferedImage)img, (File)file);
                    }
                    catch (IOException e) {
                        this._log.error((Object)e.getMessage(), (Throwable)e);
                        file.delete();
                    }
                    finally {
                        if (img != null) {
                            img.flush();
                        }
                    }
                }
                if ((type = this._gaijiMap.get(name)) == null) {
                    type = FontUtil.getFontType((int)codePoint);
                    this._gaijiMap.put(name, type);
                }
                Node parent = text.getParentNode();
                text = text.splitText(idx);
                text.deleteData(0, cnt);
                Element elem = text.getOwnerDocument().createElement("char");
                elem.setAttribute("name", name);
                elem.setAttribute("type", type);
                parent.insertBefore(elem, text);
                str = text.getNodeValue();
                len = str.length();
                idx = 0;
            }
        }
        if (node.hasChildNodes()) {
            NodeList nlist = node.getChildNodes();
            int len = nlist.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nlist.item(i);
                this._checkCharacter(child);
                int n = nlist.getLength();
                if (len >= n) continue;
                i += n - len;
                len = n;
            }
        }
    }
}

