/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.hook;

import fuku.eb4j.EBException;
import fuku.eb4j.SubAppendix;
import fuku.eb4j.SubBook;
import fuku.eb4j.hook.HookAdapter;
import fuku.eb4j.util.ByteUtil;
import fuku.eb4j.util.HexUtil;
import org.apache.commons.lang.StringUtils;

public class DefaultHook
extends HookAdapter<String> {
    private int _maxLine = 500;
    private boolean _narrow = false;
    private int _line = 0;
    private StringBuilder _buf = new StringBuilder(2048);
    private SubAppendix _appendix = null;

    public DefaultHook(SubBook sub) {
        this(sub, 500);
    }

    public DefaultHook(SubBook sub, int maxLine) {
        this._appendix = sub.getSubAppendix();
        this._maxLine = maxLine;
    }

    @Override
    public void clear() {
        this._buf.delete(0, this._buf.length());
        this._narrow = false;
        this._line = 0;
    }

    @Override
    public String getObject() {
        return this._buf.toString();
    }

    @Override
    public boolean isMoreInput() {
        return this._line < this._maxLine;
    }

    @Override
    public void append(String str) {
        if (this._narrow) {
            str = ByteUtil.wideToNarrow(str);
        }
        this._buf.append(str);
    }

    @Override
    public void append(int code) {
        String str = null;
        if (this._narrow) {
            if (this._appendix != null) {
                try {
                    str = this._appendix.getNarrowFontAlt(code);
                }
                catch (EBException e) {
                    // empty catch block
                }
            }
            if (StringUtils.isBlank(str)) {
                str = "[GAIJI=n" + HexUtil.toHexString(code) + "]";
            }
        } else {
            if (this._appendix != null) {
                try {
                    str = this._appendix.getWideFontAlt(code);
                }
                catch (EBException eBException) {
                    // empty catch block
                }
            }
            if (StringUtils.isBlank(str)) {
                str = "[GAIJI=w" + HexUtil.toHexString(code) + "]";
            }
        }
        this._buf.append(str);
    }

    @Override
    public void beginNarrow() {
        this._narrow = true;
    }

    @Override
    public void endNarrow() {
        this._narrow = false;
    }

    @Override
    public void newLine() {
        this._buf.append('\n');
        ++this._line;
    }
}

