/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.xml2eb.converter.wdic.Wdic;
import fuku.xml2eb.converter.wdic.WdicUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WdicItem
implements Comparable<WdicItem> {
    private Wdic _wdic = null;
    private String _head = null;
    private int _idx = 0;
    private List<String> _yomi = null;
    private Map<String, String> _spell = null;
    private Map<String, String> _pron = null;
    private List<String> _speech = null;
    private List<String> _body = null;
    private List<String> _dir = null;

    public WdicItem(Wdic wdic, String head, int idx) {
        this._wdic = wdic;
        this._head = WdicUtil.unescape(head);
        this._idx = idx;
        this._yomi = new ArrayList<String>();
        this._spell = new LinkedHashMap<String, String>();
        this._pron = new LinkedHashMap<String, String>();
        this._speech = new ArrayList<String>();
        this._body = new ArrayList<String>();
        this._dir = new ArrayList<String>();
    }

    public Wdic getWdic() {
        return this._wdic;
    }

    public String getHead() {
        return this._head;
    }

    public int getIndex() {
        return this._idx;
    }

    public List<String> getYomi() {
        return new ArrayList<String>(this._yomi);
    }

    public void addYomi(String yomi) {
        if (StringUtils.isNotBlank((String)yomi)) {
            this._yomi.add(yomi);
        }
    }

    public Map<String, String> getSpell() {
        return new LinkedHashMap<String, String>(this._spell);
    }

    public void addSpell(String lang, String spell) {
        if (StringUtils.isNotBlank((String)spell)) {
            this._spell.put(lang, spell);
        }
    }

    public Map<String, String> getPronounce() {
        return new LinkedHashMap<String, String>(this._pron);
    }

    public void addPronounce(String lang, String pronounce) {
        if (StringUtils.isNotBlank((String)pronounce)) {
            this._pron.put(lang, pronounce);
        }
    }

    public List<String> getSpeech() {
        return new ArrayList<String>(this._speech);
    }

    public void addSpeech(String speech) {
        if (StringUtils.isNotBlank((String)speech)) {
            String[] pos = speech.split(",");
            int n = pos.length;
            for (int i = 0; i < n; ++i) {
                this._speech.add(pos[i].trim());
            }
        }
    }

    public List<String> getBody() {
        return new ArrayList<String>(this._body);
    }

    public void addBody(String body) {
        if (StringUtils.isNotBlank((String)body)) {
            this._body.add(body);
        }
    }

    public List<String> getDir() {
        return new ArrayList<String>(this._dir);
    }

    public void addDir(String dir) {
        if (StringUtils.isNotBlank((String)dir)) {
            this._dir.add(dir);
        }
    }

    public boolean isAlias() {
        String str;
        return this._body.size() == 1 && (str = this._body.get(0)).startsWith("=> [[");
    }

    public String getRealName() {
        String str;
        if (this._body.size() == 1 && (str = this._body.get(0)).startsWith("=> [[")) {
            int len = str.length();
            return str.substring(5, len - 2);
        }
        return null;
    }

    public int hashCode() {
        String str = this._wdic.getGroupId() + this._head;
        return str.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WdicItem) {
            String pid2;
            String pid1;
            String gid2;
            WdicItem item = (WdicItem)obj;
            String gid1 = this._wdic.getGroupId();
            if (gid1.equals(gid2 = item.getWdic().getGroupId()) && (pid1 = this._wdic.getPartId()).equals(pid2 = item.getWdic().getPartId())) {
                return this._head.equals(item.getHead());
            }
        }
        return false;
    }

    @Override
    public int compareTo(WdicItem item) {
        String str1 = this._head;
        String str2 = item.getHead();
        try {
            byte[] b1 = str1.getBytes("EUC-JP");
            byte[] b2 = str2.getBytes("EUC-JP");
            int len1 = b1.length;
            int len2 = b2.length;
            int len = Math.min(len1, len2);
            for (int i = 0; i < len; ++i) {
                int ch1 = b1[i] & 0xFF;
                int ch2 = b2[i] & 0xFF;
                int comp = ch1 - ch2;
                if (comp == 0) continue;
                return comp;
            }
            return len1 - len2;
        }
        catch (UnsupportedEncodingException e) {
            return str1.compareTo(str2);
        }
    }
}

