/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.tool;

import fuku.eb4j.Book;
import fuku.eb4j.EBException;
import fuku.eb4j.SubBook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.util.ByteUtil;
import fuku.eb4j.util.HexUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.ArrayUtils;

public class EBDump {
    private static final String _COPYRIGHT = "Copyright (c) 2002-2007 by Hisaya FUKUMOTO.";
    private static final String _EMAIL = "fukumoto@users.sourceforge.jp";
    private static final String _PROGRAM = EBDump.class.getName();
    private static final String DEFAULT_BOOK_DIR = ".";
    private Book _book = null;

    public static void main(String[] args) {
        String arg;
        Options options = new Options();
        options.addOption("s", "subbook", true, "subbook index number");
        options.addOption("p", "page", true, "page number (HEX)");
        options.addOption("o", "offset", true, "offset number (HEX)");
        options.addOption("P", "position", true, "position (HEX)");
        options.addOption("d", "dump", true, "dump size (HEX)");
        options.addOption("h", "help", false, "display this help and exit");
        options.addOption("v", "version", false, "output version information and exit");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(_PROGRAM + ": " + e.getMessage());
            System.exit(1);
        }
        int subindex = 0;
        long page = 1L;
        int off = 0;
        long pos = -1L;
        int size = 0;
        if (cmd.hasOption("s")) {
            arg = cmd.getOptionValue("s");
            try {
                subindex = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                System.err.println(_PROGRAM + ": invalid subbook index `" + arg + "'");
                System.exit(1);
            }
            if (subindex <= 0) {
                System.err.println(_PROGRAM + ": invalid subbook index `" + arg + "'");
                System.exit(1);
            }
            --subindex;
        }
        if (cmd.hasOption("p")) {
            arg = cmd.getOptionValue("p");
            try {
                page = Long.parseLong(arg, 16);
            }
            catch (NumberFormatException e) {
                System.err.println(_PROGRAM + ": invalid page number `" + arg + "'");
                System.exit(1);
            }
            if (page <= 0L) {
                System.err.println(_PROGRAM + ": invalid page number `" + arg + "'");
                System.exit(1);
            }
        }
        if (cmd.hasOption("o")) {
            arg = cmd.getOptionValue("o");
            try {
                off = Integer.parseInt(arg, 16);
            }
            catch (NumberFormatException e) {
                System.err.println(_PROGRAM + ": invalid offset number `" + arg + "'");
                System.exit(1);
            }
            if (off < 0) {
                System.err.println(_PROGRAM + ": invalid offset number `" + arg + "'");
                System.exit(1);
            }
        }
        if (cmd.hasOption("P")) {
            arg = cmd.getOptionValue("P");
            try {
                pos = Long.parseLong(arg, 16);
            }
            catch (NumberFormatException e) {
                System.err.println(_PROGRAM + ": invalid position `" + arg + "'");
                System.exit(1);
            }
            if (pos < 0L) {
                System.err.println(_PROGRAM + ": invalid position `" + arg + "'");
                System.exit(1);
            }
        }
        if (cmd.hasOption("d")) {
            arg = cmd.getOptionValue("d");
            try {
                size = Integer.parseInt(arg, 16);
            }
            catch (NumberFormatException e) {
                System.err.println(_PROGRAM + ": invalid dump size `" + arg + "'");
                System.exit(1);
            }
            if (size <= 0) {
                System.err.println(_PROGRAM + ": invalid dump size `" + arg + "'");
                System.exit(1);
            }
        }
        if (cmd.hasOption("h")) {
            EBDump._usage(options);
            System.exit(0);
        }
        if (cmd.hasOption("v")) {
            EBDump._version();
            System.exit(0);
        }
        String path = null;
        String[] paths = cmd.getArgs();
        int len = ArrayUtils.getLength((Object)paths);
        switch (len) {
            case 0: {
                path = DEFAULT_BOOK_DIR;
                break;
            }
            case 1: {
                path = paths[0];
                break;
            }
            default: {
                System.err.println(_PROGRAM + ": too many arguments");
                EBDump._usage();
                System.exit(1);
            }
        }
        try {
            EBDump ebdump = new EBDump(path);
            if (pos < 0L) {
                pos = BookInputStream.getPosition((long)page, (int)off);
            }
            ebdump._dump(subindex, pos, size);
        }
        catch (EBException e) {
            System.err.println(_PROGRAM + ": " + e.getMessage());
        }
    }

    private static void _usage() {
        System.out.println("Try `java " + _PROGRAM + " --help' for more information");
    }

    private static void _usage(Options options) {
        HelpFormatter fmt = new HelpFormatter();
        fmt.printHelp("java " + _PROGRAM + " [option...] [book-directory]", "\nOptions:", options, "\nReport bugs to <fukumoto@users.sourceforge.jp>.", false);
    }

    private static void _version() {
        Package pkg = EBDump.class.getPackage();
        System.out.println(_PROGRAM + " " + pkg.getImplementationVersion());
        System.out.println(_COPYRIGHT);
        System.out.println("All right reserved.");
    }

    private EBDump(String path) throws EBException {
        this._book = new Book(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _dump(int subindex, long pos, int size) throws EBException {
        SubBook sub = this._book.getSubBook(subindex);
        if (sub == null) {
            return;
        }
        if (size <= 0) {
            size = 2048;
        }
        BookInputStream bis = sub.getTextFile().getInputStream();
        byte[] b = new byte[size];
        try {
            bis.seek(pos);
            bis.readFully(b, 0, b.length);
        }
        finally {
            bis.close();
        }
        long page = BookInputStream.getPage((long)pos);
        long pos2 = pos + (long)size;
        long start = pos - (pos & 0xFL);
        long end = pos2;
        if ((end & 0xFL) > 0L) {
            end += 16L - end % 16L;
        }
        StringBuilder buf = new StringBuilder();
        int idx = 0;
        long i = 0L;
        for (i = start; i < end; i += 16L) {
            int j;
            if (pos + (long)idx >= page * 2048L) {
                ++page;
            }
            buf.append(this._toHexString(page)).append(':');
            int offset = (int)(i % 2048L);
            buf.append(this._toHexString(offset)).append(' ');
            int k = 0;
            for (j = 0; j < 16; ++j) {
                if (j == 8) {
                    buf.append(' ');
                }
                buf.append(' ');
                if (i + (long)j >= pos && i + (long)j < pos2) {
                    buf.append(this._toHexString(b[idx + k]));
                    ++k;
                    continue;
                }
                buf.append("  ");
            }
            buf.append("  ");
            for (j = 0; j < 16; j += 2) {
                if (i + (long)j >= pos && i + (long)j < pos2) {
                    int high = b[idx++] & 0xFF;
                    if (i + (long)j + 1L >= pos && i + (long)j + 1L < pos2) {
                        int low = b[idx++] & 0xFF;
                        if (high > 32 && high < 127 && low > 32 && low < 127) {
                            buf.append(ByteUtil.jisx0208ToString((byte[])b, (int)(idx - 2), (int)2));
                            continue;
                        }
                        if (high > 32 && high > 127 && low > 160 && low < 255) {
                            buf.append("??");
                            continue;
                        }
                        if (high > 160 && high < 255 && low > 32 && low < 127) {
                            buf.append("??");
                            continue;
                        }
                        buf.append("..");
                        continue;
                    }
                    buf.append(". ");
                    continue;
                }
                buf.append(' ');
                if (i + (long)j + 1L >= pos && i + (long)j + 1L < pos2) {
                    ++idx;
                    buf.append('.');
                    continue;
                }
                buf.append(' ');
            }
            System.out.println(buf.toString());
            System.out.flush();
            buf.delete(0, buf.length());
        }
    }

    private String _toHexString(byte hex) {
        return HexUtil.toHexString((byte)hex);
    }

    private String _toHexString(int hex) {
        return HexUtil.toHexString((int)hex, (int)3);
    }

    private String _toHexString(long hex) {
        return HexUtil.toHexString((long)hex, (int)5);
    }
}

