/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;

public class ServletWebRequest
extends ServletRequestAttributes
implements WebRequest {
    public ServletWebRequest(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String paramName) {
        return this.getRequest().getParameter(paramName);
    }

    public String[] getParameterValues(String paramName) {
        return this.getRequest().getParameterValues(paramName);
    }

    public Map getParameterMap() {
        return this.getRequest().getParameterMap();
    }

    public Locale getLocale() {
        return this.getRequest().getLocale();
    }

    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    public String getDescription(boolean includeClientInfo) {
        HttpServletRequest request = this.getRequest();
        StringBuffer buffer = new StringBuffer();
        buffer.append("uri=").append(request.getRequestURI());
        if (includeClientInfo) {
            String user;
            HttpSession session;
            String client = request.getRemoteAddr();
            if (StringUtils.hasLength((String)client)) {
                buffer.append(";client=").append(client);
            }
            if ((session = request.getSession(false)) != null) {
                buffer.append(";session=").append(session.getId());
            }
            if (StringUtils.hasLength((String)(user = request.getRemoteUser()))) {
                buffer.append(";user=").append(user);
            }
        }
        return buffer.toString();
    }

    public String toString() {
        return "ServletWebRequest: " + this.getDescription(true);
    }
}

