/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.util;

public class UnicodeUtil {
    private UnicodeUtil() {
    }

    public static String sanitizeUnicode(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (Character.isHighSurrogate(ch) || Character.isLowSurrogate(ch)) {
                buf.append(ch);
                continue;
            }
            switch (ch) {
                case '\u2013': {
                    ch = '-';
                    break;
                }
                case '\u2015': {
                    ch = '\u2014';
                    break;
                }
                case '\u2225': {
                    ch = '\u2016';
                    break;
                }
                case '\uff0d': {
                    ch = '\u2212';
                    break;
                }
                case '\uff5e': {
                    ch = '\u301c';
                    break;
                }
                case '\uffe0': {
                    ch = '\u00a2';
                    break;
                }
                case '\uffe1': {
                    ch = '\u00a3';
                    break;
                }
                case '\uffe2': {
                    ch = '\u00ac';
                    break;
                }
            }
            buf.append(ch);
        }
        return buf.toString();
    }
}

