/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import fuku.xml2eb.Position;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;

public class Reference {
    private Map<String, Integer> _charMap = new HashMap<String, Integer>();
    private Map<String, Position> _tagMap = new HashMap<String, Position>();
    private Map<String, String> _formatMap = new HashMap<String, String>();
    private Map<String, AudioFormat> _audioFormatMap = new HashMap<String, AudioFormat>();
    private Map<Position, String> _refMap = new HashMap<Position, String>();

    public void putNarrowChar(String name, int code) {
        String key = "narrow:" + name;
        this._charMap.put(key, code);
    }

    public boolean hasNarrowChar(String name) {
        String key = "narrow:" + name;
        return this._charMap.containsKey(key);
    }

    public int getNarrowChar(String name) {
        String key = "narrow:" + name;
        Integer code = this._charMap.get(key);
        if (code == null) {
            return -1;
        }
        return code;
    }

    public void putWideChar(String name, int code) {
        String key = "wide:" + name;
        this._charMap.put(key, code);
    }

    public boolean hasWideChar(String name) {
        String key = "wide:" + name;
        return this._charMap.containsKey(key);
    }

    public int getWideChar(String name) {
        String key = "wide:" + name;
        Integer code = this._charMap.get(key);
        if (code == null) {
            return -1;
        }
        return code;
    }

    public void putHeadTag(String name, File file, long pos) {
        String key = "head:" + name;
        this._tagMap.put(key, new Position(file, pos));
    }

    public boolean hasHeadTag(String name) {
        String key = "head:" + name;
        return this._tagMap.containsKey(key);
    }

    public Position getHeadTag(String name) {
        String key = "head:" + name;
        return this._tagMap.get(key);
    }

    public void putBodyTag(String name, File file, long pos) {
        String key = "body:" + name;
        this._tagMap.put(key, new Position(file, pos));
    }

    public boolean hasBodyTag(String name) {
        String key = "body:" + name;
        return this._tagMap.containsKey(key);
    }

    public Position getBodyTag(String name) {
        String key = "body:" + name;
        return this._tagMap.get(key);
    }

    public void putGraphicTag(String name, String format, File file, long pos) {
        String key = "graphic:" + name;
        this._tagMap.put(key, new Position(file, pos));
        this._formatMap.put(key, format);
    }

    public boolean hasGraphicTag(String name) {
        String key = "graphic:" + name;
        return this._tagMap.containsKey(key);
    }

    public Position getGraphicTag(String name) {
        String key = "graphic:" + name;
        return this._tagMap.get(key);
    }

    public String getGraphicFormat(String name) {
        String key = "graphic:" + name;
        return this._formatMap.get(key);
    }

    public void putSoundTag(String name, String format, File file, long start, long end) {
        String key = "sound-start:" + name;
        this._tagMap.put(key, new Position(file, start));
        key = "sound-end:" + name;
        this._tagMap.put(key, new Position(file, end));
        key = "sound:" + name;
        this._formatMap.put(key, format);
    }

    public boolean hasSoundTag(String name) {
        String key = "sound-start:" + name;
        return this._tagMap.containsKey(key);
    }

    public Position[] getSoundTag(String name) {
        Position[] pos = new Position[2];
        String key = "sound-start:" + name;
        pos[0] = this._tagMap.get(key);
        key = "sound-end:" + name;
        pos[1] = this._tagMap.get(key);
        return pos;
    }

    public String getSoundFormat(String name) {
        String key = "sound:" + name;
        return this._formatMap.get(key);
    }

    public void putAudioFormat(String name, AudioFormat audioFormat) {
        this._audioFormatMap.put(name, audioFormat);
    }

    public AudioFormat getAudioFormat(String name) {
        return this._audioFormatMap.get(name);
    }

    public void putHeadRef(File file, long pos, String name) {
        String tag = "head:" + name;
        this._refMap.put(new Position(file, pos), tag);
    }

    public void putBodyRef(File file, long pos, String name) {
        String tag = "body:" + name;
        this._refMap.put(new Position(file, pos), tag);
    }

    public void putIndexRef(File file, long pos, String name) {
        String tag = "index:" + name;
        this._refMap.put(new Position(file, pos), tag);
    }

    public void putGraphicRef(File file, long pos, String name) {
        String tag = "graphic:" + name;
        this._refMap.put(new Position(file, pos), tag);
    }

    public void putSoundRef(File file, long pos, String name) {
        String tag = "sound:" + name;
        this._refMap.put(new Position(file, pos), tag);
    }

    public Map<Position, String> getHeadRef() {
        return this._getRef("head:");
    }

    public Map<Position, String> getBodyRef() {
        return this._getRef("body:");
    }

    public Map<Position, String> getIndexRef() {
        return this._getRef("index:");
    }

    public Map<Position, String> getGraphicRef() {
        return this._getRef("graphic:");
    }

    public Map<Position, String> getSoundRef() {
        return this._getRef("sound:");
    }

    private Map<Position, String> _getRef(String prefix) {
        int len = prefix.length();
        HashMap<Position, String> map = new HashMap<Position, String>();
        for (Map.Entry<Position, String> entry : this._refMap.entrySet()) {
            String tag = entry.getValue();
            if (!tag.startsWith(prefix)) continue;
            tag = tag.substring(len);
            map.put(entry.getKey(), tag);
        }
        return map;
    }
}

