/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import fuku.xml2eb.Index;
import java.io.File;
import java.util.ArrayList;

public class IndexLayer
extends ArrayList<Index> {
    private int _level = 0;
    private long _block = 1L;
    private int _wordLength = 0;
    private int _blockLength = 4;
    private File _file = null;

    public IndexLayer(File file, int level) {
        this._level = level;
        File dir = file.getParentFile();
        if (dir == null) {
            dir = new File(".");
        }
        String name = file.getName() + "." + level;
        this._file = new File(dir, name);
    }

    @Override
    public void clear() {
        super.clear();
        ++this._block;
        this._wordLength = 0;
        this._blockLength = 4;
    }

    public int getLevel() {
        return this._level;
    }

    public long getBlock() {
        return this._block;
    }

    public int getWordLength() {
        return this._wordLength;
    }

    public void setWordLength(int len) {
        this._wordLength = len;
    }

    public int getBlockLength() {
        return this._blockLength;
    }

    public Index getLastIndex() {
        int len = this.size();
        return (Index)this.get(len - 1);
    }

    @Override
    public boolean add(Index index) {
        this._blockLength += index.getWord().getWordLength() + 13;
        return super.add(index);
    }

    public File getFile() {
        return this._file;
    }
}

