/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles2;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.context.ChainedTilesContextFactory;
import org.apache.tiles.definition.UrlDefinitionsFactory;
import org.apache.tiles.factory.TilesContainerFactory;
import org.apache.tiles.jsp.context.JspTilesContextFactory;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.servlet.context.ServletTilesContextFactory;
import org.apache.tiles.web.util.ServletContextAdapter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.tiles2.SpringLocaleResolver;

public class TilesConfigurer
implements ServletContextAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, String> tilesPropertyMap = new HashMap<String, String>();
    private ServletContext servletContext;

    public TilesConfigurer() {
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory", TilesContainerFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.context.TilesContextFactory", ChainedTilesContextFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory", UrlDefinitionsFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", BasicPreparerFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.context.ChainTilesContextFactory.FACTORY_CLASS_NAMES", ServletTilesContextFactory.class.getName() + "," + JspTilesContextFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.locale.LocaleResolver", SpringLocaleResolver.class.getName());
    }

    public void setDefinitions(String[] definitions) {
        if (definitions != null) {
            String defs = StringUtils.arrayToCommaDelimitedString((Object[])definitions);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("TilesConfigurer: adding definitions [" + defs + "]"));
            }
            this.tilesPropertyMap.put("org.apache.tiles.impl.BasicTilesContainer.DEFINITIONS_CONFIG", defs);
        }
    }

    public void setValidateDefinitions(boolean validateDefinitions) {
        this.tilesPropertyMap.put("org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE", Boolean.toString(validateDefinitions));
    }

    public void setDefinitionsFactoryClass(Class definitionsFactoryClass) {
        this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory", definitionsFactoryClass.getName());
    }

    public void setPreparerFactoryClass(Class preparerFactoryClass) {
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", preparerFactoryClass.getName());
    }

    public void setUseMutableTilesContainer(boolean useMutableTilesContainer) {
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", Boolean.toString(useMutableTilesContainer));
    }

    public void setTilesProperties(Properties tilesProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)tilesProperties, this.tilesPropertyMap);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() throws TilesException {
        TilesContainer container = this.createTilesContainer(this.servletContext);
        TilesAccess.setContainer((Object)this.servletContext, (TilesContainer)container);
    }

    protected TilesContainer createTilesContainer(ServletContext context) throws TilesException {
        ServletContextAdapter adaptedContext = new ServletContextAdapter((ServletConfig)new DelegatingServletConfig());
        TilesContainerFactory factory = TilesContainerFactory.getFactory((Object)adaptedContext);
        return factory.createContainer((Object)adaptedContext);
    }

    public void destroy() throws TilesException {
        TilesAccess.setContainer((Object)this.servletContext, null);
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return "TilesConfigurer";
        }

        public ServletContext getServletContext() {
            return TilesConfigurer.this.servletContext;
        }

        public String getInitParameter(String paramName) {
            return (String)TilesConfigurer.this.tilesPropertyMap.get(paramName);
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(TilesConfigurer.this.tilesPropertyMap.keySet());
        }
    }
}

