/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.util;

import fuku.eb4j.util.ByteUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageUtil {
    private static final Log _log = LogFactory.getLog(ImageUtil.class);
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 8, 6, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] PNG_FOOTER = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};

    private ImageUtil() {
    }

    public static byte[] bitmapToPNG(byte[] b, int width, int height) {
        return ImageUtil.bitmapToPNG(b, width, height, Color.BLACK, Color.WHITE, false, -1);
    }

    public static byte[] bitmapToPNG(byte[] b, int width, int height, Color foreground, Color background, boolean transparent) {
        return ImageUtil.bitmapToPNG(b, width, height, foreground, background, transparent, -1);
    }

    public static byte[] bitmapToPNG(byte[] b, int width, int height, Color foreground, Color background, boolean transparent, int level) {
        byte[] fRGB = new byte[]{(byte)foreground.getRed(), (byte)foreground.getGreen(), (byte)foreground.getBlue(), -1};
        byte[] bRGB = new byte[]{(byte)background.getRed(), (byte)background.getGreen(), (byte)background.getBlue(), transparent ? (byte)0 : -1};
        byte[] image = new byte[(width * 4 + 1) * height];
        Arrays.fill(image, (byte)0);
        int offi = 0;
        int offb = 0;
        byte[] c = null;
        for (int y = 0; y < height; ++y) {
            image[offi++] = 0;
            for (int x = 0; x < width; x += 8) {
                int cnt = 8;
                if (x + 8 > width) {
                    cnt = width - x;
                }
                int mask = 128;
                for (int i = 0; i < cnt; ++i) {
                    c = (b[offb] & mask) > 0 ? fRGB : bRGB;
                    image[offi++] = c[0];
                    image[offi++] = c[1];
                    image[offi++] = c[2];
                    image[offi++] = c[3];
                    mask >>>= 1;
                }
                ++offb;
            }
        }
        return ImageUtil._encodePNG(width, height, image, level);
    }

    public static byte[] dibToPNG(byte[] b) {
        return ImageUtil.dibToPNG(b, -1);
    }

    public static byte[] dibToPNG(byte[] b, int level) {
        if ((b[0] & 0xFF) != 66 || (b[1] & 0xFF) != 77) {
            _log.warn((Object)"file type 'BM' is not found in file header");
            return new byte[0];
        }
        int off = (int)ByteUtil.getLongLE4(b, 10);
        int hsize = (int)ByteUtil.getLongLE4(b, 14);
        int width = 0;
        int height = 0;
        int bitCount = 0;
        int compress = 0;
        int paletteOff = 14 + hsize;
        int paletteSize = 0;
        int paletteCnt = 0;
        int[] bitField = new int[4];
        Arrays.fill(bitField, 0);
        if (hsize < 40) {
            width = ByteUtil.getIntLE2(b, 18);
            height = ByteUtil.getIntLE2(b, 20);
            bitCount = ByteUtil.getIntLE2(b, 24);
            paletteSize = 3;
        } else {
            width = (int)ByteUtil.getLongLE4(b, 18);
            height = (int)ByteUtil.getLongLE4(b, 22);
            bitCount = ByteUtil.getIntLE2(b, 28);
            compress = (int)ByteUtil.getLongLE4(b, 30);
            paletteCnt = (int)ByteUtil.getLongLE4(b, 46);
            paletteSize = 4;
            if (hsize < 52) {
                if (compress == 0) {
                    if (bitCount == 16) {
                        bitField[0] = 31744;
                        bitField[1] = 992;
                        bitField[2] = 31;
                    } else if (bitCount == 32) {
                        bitField[0] = 0xFF0000;
                        bitField[1] = 65280;
                        bitField[2] = 255;
                    }
                } else if (compress == 3 && (bitCount == 16 || bitCount == 32)) {
                    bitField[0] = (int)ByteUtil.getLongLE4(b, 54);
                    bitField[1] = (int)ByteUtil.getLongLE4(b, 58);
                    bitField[2] = (int)ByteUtil.getLongLE4(b, 62);
                    paletteOff += 12;
                }
            } else {
                bitField[0] = (int)ByteUtil.getLongLE4(b, 54);
                bitField[1] = (int)ByteUtil.getLongLE4(b, 58);
                bitField[2] = (int)ByteUtil.getLongLE4(b, 62);
                bitField[3] = (int)ByteUtil.getLongLE4(b, 66);
            }
        }
        int n = bitField.length;
        int[] bitNum = new int[n];
        Arrays.fill(bitNum, 0);
        int[] bitShift = new int[n];
        Arrays.fill(bitShift, 0);
        for (int i = 0; i < n; ++i) {
            int mask = bitField[i];
            if (mask == 0) continue;
            while ((mask & 1) == 0) {
                mask >>>= 1;
                int n2 = i;
                bitShift[n2] = bitShift[n2] + 1;
            }
            int cnt = bitShift[i];
            while ((mask & 1) != 0) {
                mask >>>= 1;
                int n3 = i;
                bitNum[n3] = bitNum[n3] + 1;
                if (++cnt < bitCount) continue;
            }
            cnt = 1;
            for (int j = 0; j < bitNum[i]; ++j) {
                cnt <<= 1;
            }
            bitNum[i] = cnt - 1;
        }
        if (off == 0) {
            off = 14 + hsize;
            if (paletteCnt != 0) {
                off += paletteSize * paletteCnt;
            } else if (bitCount == 1 || bitCount == 4 || bitCount == 8) {
                off += paletteSize * (1 << bitCount);
            }
            if (hsize == 40 && compress == 3 && (bitCount == 16 || bitCount == 32)) {
                off += 12;
            }
        }
        byte[] dib = b;
        if (compress > 0) {
            if (compress == 1 && bitCount == 8) {
                dib = ImageUtil._expandRLE8(b, off, width, height);
            } else if (compress == 2 && bitCount == 4) {
                dib = ImageUtil._expandRLE4(b, off, width, height);
            } else if (compress != 3 || bitCount != 16 && bitCount != 32) {
                _log.warn((Object)("unknown compression type: compress=" + compress + " bitCount=" + bitCount));
                return new byte[0];
            }
        }
        int lineBytes = (width * bitCount + 31) / 32 * 4;
        byte[] line = new byte[lineBytes];
        byte[] image = new byte[(width * 4 + 1) * height];
        Arrays.fill(image, (byte)0);
        int idx = 0;
        switch (bitCount) {
            case 1: {
                for (int y = height - 1; y >= 0; --y) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * y, line, 0, lineBytes);
                    for (int x = 0; x < width; x += 8) {
                        int cnt = 8;
                        if (x + 8 > width) {
                            cnt = width - x;
                        }
                        int mask = 128;
                        for (int i = 0; i < cnt; ++i) {
                            int palette = paletteOff;
                            if ((line[x / 8] & mask) > 0) {
                                palette += paletteSize;
                            }
                            image[idx++] = dib[palette + 2];
                            image[idx++] = dib[palette + 1];
                            image[idx++] = dib[palette];
                            image[idx++] = -1;
                            mask >>>= 1;
                        }
                    }
                }
                break;
            }
            case 4: {
                for (int y = height - 1; y >= 0; --y) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * y, line, 0, lineBytes);
                    for (int x = 0; x < width; x += 2) {
                        int palette = paletteOff + (line[x / 2] >>> 4 & 0xF) * paletteSize;
                        image[idx++] = dib[palette + 2];
                        image[idx++] = dib[palette + 1];
                        image[idx++] = dib[palette];
                        image[idx++] = -1;
                        if (width - x <= 1) continue;
                        palette = paletteOff + (line[x / 2] & 0xF) * paletteSize;
                        image[idx++] = dib[palette + 2];
                        image[idx++] = dib[palette + 1];
                        image[idx++] = dib[palette];
                        image[idx++] = -1;
                    }
                }
                break;
            }
            case 8: {
                for (int y = height - 1; y >= 0; --y) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * y, line, 0, lineBytes);
                    for (int x = 0; x < width; ++x) {
                        int palette = paletteOff + (line[x] & 0xFF) * paletteSize;
                        image[idx++] = dib[palette + 2];
                        image[idx++] = dib[palette + 1];
                        image[idx++] = dib[palette];
                        image[idx++] = -1;
                    }
                }
                break;
            }
            case 16: {
                for (int y = height - 1; y >= 0; --y) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * y, line, 0, lineBytes);
                    int w = width * 4;
                    for (int x = 0; x < w; x += 2) {
                        int val = ByteUtil.getIntLE2(line, x);
                        for (int i = 0; i < 3; ++i) {
                            int pxl = (val & bitField[i]) >>> bitShift[i];
                            if (bitNum[i] != 255) {
                                pxl = Math.round((float)pxl * 255.0f / (float)bitNum[i]);
                            }
                            image[idx++] = (byte)pxl;
                        }
                        if (bitField[3] == 0) {
                            image[idx++] = -1;
                            continue;
                        }
                        int pxl = (val & bitField[3]) >>> bitShift[3];
                        if (bitNum[3] != 255) {
                            pxl = Math.round((float)pxl * 255.0f / (float)bitNum[3]);
                        }
                        image[idx++] = (byte)pxl;
                    }
                }
                break;
            }
            case 24: {
                for (int y = height - 1; y >= 0; --y) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * y, line, 0, lineBytes);
                    int w = width * 3;
                    for (int x = 0; x < w; x += 3) {
                        image[idx++] = line[x + 2];
                        image[idx++] = line[x + 1];
                        image[idx++] = line[x];
                        image[idx++] = -1;
                    }
                }
                break;
            }
            case 32: {
                for (int y = height - 1; y >= 0; --y) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * y, line, 0, lineBytes);
                    int w = width * 4;
                    for (int x = 0; x < w; x += 4) {
                        int val = (int)ByteUtil.getLongLE4(line, x);
                        for (int i = 0; i < 3; ++i) {
                            int pxl = (val & bitField[i]) >>> bitShift[i];
                            if (bitNum[i] != 255) {
                                pxl = Math.round((float)pxl * 255.0f / (float)bitNum[i]);
                            }
                            image[idx++] = (byte)pxl;
                        }
                        if (bitField[3] == 0) {
                            image[idx++] = -1;
                            continue;
                        }
                        int pxl = ((val ^= 0xFFFFFFFF) & bitField[3]) >>> bitShift[3];
                        if (bitNum[3] != 255) {
                            pxl = Math.round((float)pxl * 255.0f / (float)bitNum[3]);
                        }
                        image[idx++] = (byte)pxl;
                    }
                }
                break;
            }
            default: {
                _log.warn((Object)("unknown bit count: " + bitCount));
                return new byte[0];
            }
        }
        return ImageUtil._encodePNG(width, height, image, level);
    }

    private static byte[] _expandRLE8(byte[] rle, int off, int width, int height) {
        int lineBytes = (width * 8 + 31) / 32 * 4;
        int size = off + lineBytes * height;
        byte[] dib = new byte[size];
        Arrays.fill(dib, (byte)0);
        System.arraycopy(rle, 0, dib, 0, off);
        int sidx = off;
        block5: for (int y = 0; y < height; ++y) {
            int didx = off + lineBytes * y;
            int x = 0;
            while (x < width) {
                int code1 = rle[sidx++] & 0xFF;
                int code2 = rle[sidx++] & 0xFF;
                if (code1 == 0) {
                    boolean eol = false;
                    switch (code2) {
                        case 0: {
                            if (x <= 0) break;
                            eol = true;
                            break;
                        }
                        case 1: {
                            return dib;
                        }
                        case 2: {
                            code1 = rle[sidx++] & 0xFF;
                            code2 = rle[sidx++] & 0xFF;
                            x += code1;
                            y += code2;
                            didx += code1 + lineBytes * code2;
                            break;
                        }
                        default: {
                            x += code2;
                            for (int i = 0; i < code2; ++i) {
                                dib[didx++] = rle[sidx++];
                            }
                            if (code2 % 2 == 0) break;
                            ++sidx;
                        }
                    }
                    if (!eol) continue;
                    continue block5;
                }
                x += code1;
                for (int i = 0; i < code1; ++i) {
                    dib[didx++] = (byte)code2;
                }
            }
        }
        return dib;
    }

    private static byte[] _expandRLE4(byte[] rle, int off, int width, int height) {
        int lineBytes = (width * 4 + 31) / 32 * 4;
        int size = off + lineBytes * height;
        byte[] dib = new byte[size];
        Arrays.fill(dib, (byte)0);
        System.arraycopy(rle, 0, dib, 0, off);
        int sidx = off;
        block5: for (int y = 0; y < height; ++y) {
            int didx = off + lineBytes * y;
            boolean high = true;
            int x = 0;
            while (x < width) {
                int code1 = rle[sidx++] & 0xFF;
                int code2 = rle[sidx++] & 0xFF;
                if (code1 == 0) {
                    boolean eol = false;
                    switch (code2) {
                        case 0: {
                            if (x <= 0) break;
                            eol = true;
                            break;
                        }
                        case 1: {
                            return dib;
                        }
                        case 2: {
                            code1 = rle[sidx++] & 0xFF;
                            code2 = rle[sidx++] & 0xFF;
                            x += code1;
                            y += code2;
                            didx += code1 / 2 + lineBytes * code2;
                            if (code1 % 2 == 0) break;
                            boolean bl = high = !high;
                            if (!high) break;
                            ++didx;
                            break;
                        }
                        default: {
                            int i;
                            x += code2;
                            int cnt = (code2 + 1) / 2;
                            if (high) {
                                for (i = 0; i < cnt; ++i) {
                                    dib[didx++] = rle[sidx++];
                                }
                                if (code2 % 2 != 0) {
                                    int n = --didx;
                                    dib[n] = (byte)(dib[n] & 0xF0);
                                    high = false;
                                }
                            } else {
                                for (i = 0; i < cnt; ++i) {
                                    int n = didx++;
                                    dib[n] = (byte)(dib[n] | rle[sidx] >>> 4 & 0xF);
                                    int n2 = didx;
                                    dib[n2] = (byte)(dib[n2] | rle[sidx++] << 4 & 0xF0);
                                }
                                if (code2 % 2 != 0) {
                                    dib[didx] = 0;
                                    high = true;
                                }
                            }
                            if (cnt % 2 == 0) break;
                            ++sidx;
                        }
                    }
                    if (!eol) continue;
                    continue block5;
                }
                x += code1;
                if (!high) {
                    dib[didx++] = (byte)(code2 >>> 4 & 0xF);
                    code2 = code2 >>> 4 & 0xF | code2 << 4 & 0xF0;
                    --code1;
                    high = true;
                }
                int cnt = (code1 + 1) / 2;
                for (int i = 0; i < cnt; ++i) {
                    dib[didx++] = (byte)code2;
                }
                if (code1 % 2 == 0) continue;
                int n = --didx;
                dib[n] = (byte)(dib[n] & 0xF0);
                high = false;
            }
        }
        return dib;
    }

    private static byte[] _encodePNG(int width, int height, byte[] image, int level) {
        byte[] buf = new byte[image.length + 62];
        Deflater def = new Deflater(level);
        def.setInput(image, 0, image.length);
        def.finish();
        int len = 0;
        while (!def.needsInput()) {
            int n = def.deflate(buf, len, buf.length - len);
            len += n;
        }
        def.end();
        int size = PNG_HEADER.length + len + 12 + PNG_FOOTER.length;
        byte[] png = new byte[size];
        Arrays.fill(png, (byte)0);
        System.arraycopy(PNG_HEADER, 0, png, 0, PNG_HEADER.length);
        png[16] = (byte)(width >>> 24 & 0xFF);
        png[17] = (byte)(width >>> 16 & 0xFF);
        png[18] = (byte)(width >>> 8 & 0xFF);
        png[19] = (byte)(width & 0xFF);
        png[20] = (byte)(height >>> 24 & 0xFF);
        png[21] = (byte)(height >>> 16 & 0xFF);
        png[22] = (byte)(height >>> 8 & 0xFF);
        png[23] = (byte)(height & 0xFF);
        CRC32 crc = new CRC32();
        crc.update(png, 12, 17);
        long c = crc.getValue();
        png[29] = (byte)(c >>> 24 & 0xFFL);
        png[30] = (byte)(c >>> 16 & 0xFFL);
        png[31] = (byte)(c >>> 8 & 0xFFL);
        png[32] = (byte)(c & 0xFFL);
        int off = PNG_HEADER.length;
        png[off++] = (byte)(len >>> 24 & 0xFF);
        png[off++] = (byte)(len >>> 16 & 0xFF);
        png[off++] = (byte)(len >>> 8 & 0xFF);
        png[off++] = (byte)(len & 0xFF);
        png[off++] = 73;
        png[off++] = 68;
        png[off++] = 65;
        png[off++] = 84;
        System.arraycopy(buf, 0, png, off, len);
        crc.reset();
        crc.update(png, off - 4, len + 4);
        c = crc.getValue();
        off += len;
        png[off++] = (byte)(c >>> 24 & 0xFFL);
        png[off++] = (byte)(c >>> 16 & 0xFFL);
        png[off++] = (byte)(c >>> 8 & 0xFFL);
        png[off++] = (byte)(c & 0xFFL);
        System.arraycopy(PNG_FOOTER, 0, png, off, PNG_FOOTER.length);
        return png;
    }
}

