/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.FileInfo;
import fuku.eb4j.io.HuffmanNode;
import fuku.eb4j.util.ByteUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class EPWINGInputStream
extends BookInputStream {
    protected EPWINGInputStream(FileInfo info) throws EBException {
        super(info);
        this.open();
        this.cache = new byte[2048];
    }

    @Override
    protected void initFileInfo() throws EBException {
        int freq;
        long value;
        int off;
        int i;
        try {
            this.info.setRealFileSize(this.stream.length());
        }
        catch (IOException e) {
            throw new EBException(4, this.info.getPath(), e);
        }
        byte[] b = new byte[512];
        int len = 32;
        if (this.info.getFormat() == 3) {
            len += 16;
        }
        this.readRawFully(b, 0, len);
        this.info.setEpwingIndexPosition(ByteUtil.getLong4(b, 0));
        this.info.setEpwingIndexSize(ByteUtil.getLong4(b, 4));
        this.info.setEpwingFrequencyPosition(ByteUtil.getLong4(b, 8));
        this.info.setEpwingFrequencySize(ByteUtil.getLong4(b, 12));
        if (this.info.getEpwingIndexSize() < 36L || this.info.getEpwingFrequencySize() < 512L) {
            throw new EBException(5, this.info.getPath());
        }
        long pos = this.info.getEpwingIndexPosition() + (this.info.getEpwingIndexSize() - 36L) / 36L * 36L;
        try {
            this.stream.seek(pos);
        }
        catch (IOException e) {
            throw new EBException(6, this.info.getPath(), e);
        }
        this.readRawFully(b, 0, 36);
        this.info.setFileSize(this.info.getEpwingIndexSize() / 36L * 32768L);
        for (int i2 = 1; i2 < 16; ++i2) {
            int p = i2 * 2 + 4;
            if (ByteUtil.getInt2(b, p) != 0) continue;
            this.info.setFileSize(this.info.getFileSize() - 2048L * (16L - (long)i2));
            break;
        }
        int leaf32 = 0;
        int leaf16 = 0;
        if (this.info.getFormat() == 2) {
            leaf16 = (int)((this.info.getEpwingFrequencySize() - 512L) / 4L);
        } else {
            leaf16 = 1024;
            leaf32 = (int)((this.info.getEpwingFrequencySize() - (long)leaf16 * 4L - 512L) / 6L);
        }
        ArrayList<HuffmanNode> list = null;
        if (this.info.getFormat() == 3) {
            list = new ArrayList(leaf32 + leaf16 + 256 + 1);
            len = b.length - b.length % 6;
            try {
                this.stream.seek(this.info.getEpwingFrequencyPosition());
            }
            catch (IOException e) {
                throw new EBException(6, this.info.getPath(), e);
            }
            this.readRawFully(b, 0, len);
            i = 0;
            off = 0;
            while (i < leaf32) {
                if (off >= len) {
                    this.readRawFully(b, 0, len);
                    off = 0;
                }
                value = ByteUtil.getLong4(b, off);
                freq = ByteUtil.getInt2(b, off + 4);
                list.add(new HuffmanNode(value, freq, 3));
                ++i;
                off += 6;
            }
        } else {
            list = new ArrayList<HuffmanNode>(leaf16 + 256 + 1);
        }
        len = b.length - b.length % 4;
        try {
            this.stream.seek(this.info.getEpwingFrequencyPosition() + (long)leaf32 * 6L);
        }
        catch (IOException e) {
            throw new EBException(6, this.info.getPath(), e);
        }
        this.readRawFully(b, 0, len);
        i = 0;
        off = 0;
        while (i < leaf16) {
            if (off >= b.length) {
                this.readRawFully(b, 0, len);
                off = 0;
            }
            value = ByteUtil.getInt2(b, off);
            freq = ByteUtil.getInt2(b, off + 2);
            list.add(new HuffmanNode(value, freq, 2));
            ++i;
            off += 4;
        }
        try {
            this.stream.seek(this.info.getEpwingFrequencyPosition() + (long)leaf32 * 6L + (long)leaf16 * 4L);
        }
        catch (IOException e) {
            throw new EBException(6, this.info.getPath(), e);
        }
        this.readRawFully(b, 0, b.length);
        i = 0;
        off = 0;
        while (i < 256) {
            int freq2 = ByteUtil.getInt2(b, off);
            list.add(new HuffmanNode(i, freq2, 1));
            ++i;
            off += 2;
        }
        list.add(new HuffmanNode(256L, 1, 0));
        this.info.setEpwingRootNode(HuffmanNode.makeTree(list));
        super.initFileInfo();
    }

    @Override
    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            int n;
            if (this.info.getFileSize() <= this.filePos) {
                if (rlen == 0) {
                    return -1;
                }
                return rlen;
            }
            if (this.cachePos < 0L || this.filePos < this.cachePos || this.cachePos + 2048L <= this.filePos) {
                this.cachePos = this.filePos - this.filePos % 2048L;
                long pos = this.info.getEpwingIndexPosition() + this.filePos / 32768L * 36L;
                try {
                    this.stream.seek(pos);
                }
                catch (IOException e) {
                    throw new EBException(6, this.info.getPath(), e);
                }
                byte[] buf = new byte[36];
                this.readRawFully(buf, 0, buf.length);
                int offset = (int)(4L + this.filePos / 2048L % 16L * 2L);
                long pagePos = ByteUtil.getLong4(buf, 0) + (long)ByteUtil.getInt2(buf, offset);
                try {
                    this.stream.seek(pagePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this.info.getPath(), e);
                }
                this._decode();
            }
            if (len - rlen < (n = (int)(2048L - this.filePos % 2048L))) {
                n = len - rlen;
            }
            if (this.info.getFileSize() - this.filePos < (long)n) {
                n = (int)(this.info.getFileSize() - this.filePos);
            }
            int p = (int)(this.filePos - this.cachePos);
            System.arraycopy(this.cache, p, b, off + rlen, n);
            rlen += n;
            this.filePos += (long)n;
        }
        return rlen;
    }

    private void _decode() throws EBException {
        byte[] b = new byte[2048];
        int inPos = 0;
        int inLen = 0;
        int outPos = 0;
        int outLen = 0;
        int bitIndex = 7;
        if (this.info.getFormat() == 3) {
            this.readRawFully(b, 0, 1);
            if ((b[0] & 0xFF) != 0) {
                this.readRawFully(this.cache, 0, 2048);
                return;
            }
        }
        while (outLen < 2048) {
            HuffmanNode node = this.info.getEpwingRootNode();
            while (!node.isLeaf()) {
                int bit;
                if (inLen <= inPos) {
                    inLen = this.readRaw(b, 0, b.length);
                    if (inLen <= 0) {
                        throw new EBException(5, this.info.getPath());
                    }
                    inPos = 0;
                }
                if ((node = (bit = b[inPos] >>> bitIndex & 1) == 1 ? node.getLeft() : node.getRight()) == null) {
                    throw new EBException(5, this.info.getPath());
                }
                if (bitIndex > 0) {
                    --bitIndex;
                    continue;
                }
                bitIndex = 7;
                ++inPos;
            }
            if (node.getLeafType() == 0) {
                if (outLen >= 2048) break;
                Arrays.fill(this.cache, outPos, this.cache.length, (byte)0);
                break;
            }
            if (node.getLeafType() == 3) {
                if (outLen >= 2047) {
                    this.cache[outPos] = (byte)(node.getValue() >>> 24 & 0xFFL);
                    ++outPos;
                    ++outLen;
                    continue;
                }
                if (outLen >= 2046) {
                    this.cache[outPos] = (byte)(node.getValue() >>> 24 & 0xFFL);
                    this.cache[outPos + 1] = (byte)(node.getValue() >>> 16 & 0xFFL);
                    outPos += 2;
                    outLen += 2;
                    continue;
                }
                if (outLen >= 2045) {
                    this.cache[outPos] = (byte)(node.getValue() >>> 24 & 0xFFL);
                    this.cache[outPos + 1] = (byte)(node.getValue() >>> 16 & 0xFFL);
                    this.cache[outPos + 2] = (byte)(node.getValue() >>> 8 & 0xFFL);
                    outPos += 3;
                    outLen += 3;
                    continue;
                }
                this.cache[outPos] = (byte)(node.getValue() >>> 24 & 0xFFL);
                this.cache[outPos + 1] = (byte)(node.getValue() >>> 16 & 0xFFL);
                this.cache[outPos + 2] = (byte)(node.getValue() >>> 8 & 0xFFL);
                this.cache[outPos + 3] = (byte)(node.getValue() & 0xFFL);
                outPos += 4;
                outLen += 4;
                continue;
            }
            if (node.getLeafType() == 2) {
                if (outLen >= 2047) {
                    this.cache[outPos] = (byte)(node.getValue() >>> 8 & 0xFFL);
                    ++outPos;
                    ++outLen;
                    continue;
                }
                this.cache[outPos] = (byte)(node.getValue() >>> 8 & 0xFFL);
                this.cache[outPos + 1] = (byte)(node.getValue() & 0xFFL);
                outPos += 2;
                outLen += 2;
                continue;
            }
            this.cache[outPos] = (byte)(node.getValue() & 0xFFL);
            ++outPos;
            ++outLen;
        }
    }
}

