/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.FileInfo;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class BookInputStream {
    public static final int PAGE_SIZE = 2048;
    protected FileInfo info = null;
    protected RandomAccessFile stream = null;
    protected long filePos = 0L;
    protected byte[] cache = null;
    protected long cachePos = -1L;

    protected BookInputStream(FileInfo info) {
        this.info = info;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public long getFileSize() {
        return this.info.getFileSize();
    }

    public long getRealFileSize() {
        return this.info.getRealFileSize();
    }

    public int getSliceSize() {
        return this.info.getSliceSize();
    }

    protected void initFileInfo() throws EBException {
    }

    protected void open() throws EBException {
        if (this.stream != null) {
            this.close();
        }
        try {
            this.stream = new RandomAccessFile(this.info.getFile(), "r");
        }
        catch (FileNotFoundException e) {
            EBException exp = new EBException(2, this.info.getPath());
            exp.setStackTrace(e.getStackTrace());
            throw exp;
        }
        this.filePos = 0L;
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void readFully(byte[] b) throws EBException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws EBException {
        int rlen = len;
        int offset = off;
        while (rlen > 0) {
            int n = this.read(b, offset, rlen);
            if (n == -1) {
                throw new EBException(4, this.info.getPath());
            }
            rlen -= n;
            offset += n;
        }
    }

    public int read(byte[] b) throws EBException {
        return this.read(b, 0, b.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws EBException;

    public void seek(long page, int offset) {
        this.seek(BookInputStream.getPosition(page, offset));
    }

    public void seek(long pos) {
        this.filePos = pos < 0L ? 0L : (pos > this.info.getFileSize() ? this.info.getFileSize() : pos);
    }

    protected int readRaw(byte[] b) throws EBException {
        return this.readRaw(b, 0, b.length);
    }

    protected int readRaw(byte[] b, int off, int len) throws EBException {
        int ret;
        try {
            ret = this.stream.read(b, off, len);
        }
        catch (IOException e) {
            throw new EBException(4, this.info.getPath(), e);
        }
        return ret;
    }

    protected void readRawFully(byte[] b) throws EBException {
        this.readRawFully(b, 0, b.length);
    }

    protected void readRawFully(byte[] b, int off, int len) throws EBException {
        try {
            this.stream.readFully(b, off, len);
        }
        catch (EOFException e) {
            throw new EBException(4, this.info.getPath(), e);
        }
        catch (IOException e) {
            throw new EBException(4, this.info.getPath(), e);
        }
    }

    public static long getPosition(long page, int offset) {
        return (page - 1L) * 2048L + (long)offset;
    }

    public static long getPage(long pos) {
        return pos / 2048L + 1L;
    }

    public static int getOffset(long pos) {
        return (int)(pos % 2048L);
    }
}

