
#ifndef __VIDEO_H__
#define __VIDEO_H__

G_BEGIN_DECLS

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

struct _Video {
    GtkFrame	    parent_instance;
    GtkWidget	    *save_btn;
    RESULT	    *res;

#ifdef ENABLE_GSTREAMER
    GtkWidget *output, *play_btn, *time;
    GstElement *pipeline, *sink;
    gboolean	video_resized;
    GMainLoop *loop;
#endif
};

struct _VideoClass {
    GtkFrameClass   parent_class;
};

void		video_output_finalize(Video *self);
void		video_render(Video *self, RenderTextCtx *ctx);

GType		video_get_type (void);

G_END_DECLS

#endif /* __VIDEO_H__ */
