
#ifndef __TEXTVIEW_H__
#define __TEXTVIEW_H__

#include "prefs.h"
#include "dump.h"

G_BEGIN_DECLS

#define TYPE_TEXTVIEW (textview_get_type ())
#define TEXTVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXTVIEW, TextView))
#define TEXTVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXTVIEW, TextViewClass))
#define IS_TEXTVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXTVIEW))
#define IS_TEXTVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXTVIEW))
#define TEXTVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXTVIEW, TextViewClass))

typedef struct _TextView TextView;
typedef struct _TextViewClass TextViewClass;

struct _TextView {
    GtkTextView	    parent_instance;
    GtkTextTag	    *tag;
    Prefs	    *prefs;
    History	    *history;
    Dump	    *dump;
    GtkWidget	    *popupwnd;
};

struct _TextViewClass {
    GtkTextViewClass    parent_class;
};

void	    textview_open(TextView *self, RESULT *res, gboolean clear, const gchar *word);
void        textview_clear_textbuf(GtkTextView *view);
void        textview_insert_message(TextView *self, gchar *msg, gboolean clear);
void	    textview_highlight_word(TextView *self, const gchar *word);
void	    textview_find_next(TextView *self, const gchar *str);

GType	    textview_get_type (void);

G_END_DECLS

#endif /* __TEXTVIEW_H__ */

