
#ifndef __RENDER_H__
#define __RENDER_H__

#include "textview.h"
#include "prefs.h"

typedef struct
{
    TextView	*view;
    GtkTextBuffer *buf;
    BOOK_INFO   *binfo;
    RESULT      *link;
    Prefs	*prefs;
}  RenderTextCtx;

void            render_text(BOOK_INFO *binfo, TextView *view, const gchar *text, const gchar *word, Prefs *prefs);
gboolean	render_get_last_mark(RenderTextCtx *ctx, const gchar *name, GtkTextIter *iter1, GtkTextIter *iter2);
gint		render_get_font_size(GtkWidget *w);

#endif /* __RENDER_H__ */
