
#ifndef __PREFS_H__
#define __PREFS_H__

#include "builder.h"

G_BEGIN_DECLS

#define TYPE_PREFS (prefs_get_type ())
#define PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFS, Prefs))
#define PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFS, PrefsClass))
#define IS_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFS))
#define IS_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFS))
#define PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFS, PrefsClass))

typedef struct _Prefs Prefs;
typedef struct _PrefsClass PrefsClass;

struct _Prefs {
    GObject	    parent_instance;
    GData	    *data;
    Builder	    *builder;
};

struct _PrefsClass {
    GObjectClass    parent_class;
};

void		    prefs_load(Prefs *self);
void		    prefs_save(Prefs *self);

void		    prefs_close_wnd(Prefs *prefs);
const gchar*	    prefs_get_userdir();

gint		    prefs_get_int(Prefs *self, const gchar *name);
void		    prefs_set_int(Prefs *self, const gchar *name, gint value);

const gchar*	    prefs_get_str(Prefs *self, const gchar *name);
void		    prefs_set_str(Prefs *self, const gchar *name, const gchar *value);

GType		    prefs_get_type (void);

G_END_DECLS

#endif /* __PREFS_H__ */

