
#ifndef __POPUPWND_H__
#define __POPUPWND_H__

#include "builder.h"
#include "dicts.h"
#include "prefs.h"
#include "textview.h"

G_BEGIN_DECLS

#define TYPE_POPUPWND (popupwnd_get_type ())
#define POPUPWND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POPUPWND, Popupwnd))
#define POPUPWND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POPUPWND, PopupwndClass))
#define IS_POPUPWND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POPUPWND))
#define IS_POPUPWND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POPUPWND))
#define POPUPWND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POPUPWND, PopupwndClass))

typedef struct _Popupwnd Popupwnd;
typedef struct _PopupwndClass PopupwndClass;

struct _Popupwnd {
    GtkWindow   parent_instance;
    GtkWidget	*menu;
    gpointer	*mainwnd;
    Builder     *builder;
    Dicts       *dicts;
    Prefs       *prefs;
    GSequence   *results;
    TextView    *text;
    gint	lookup_started, lookup_suspended, x, y, dx, dy;
    guint       timeout_id;
    gboolean	drag;
    BOOK_INFO	*binfo;
};

struct _PopupwndClass {
    GtkWindowClass parent_class;
};

void		popupwnd_search(Popupwnd *self, const gchar *str);
void		popupwnd_lookup_start(Popupwnd *self);
void		popupwnd_lookup_stop(Popupwnd *self);
void		popupwnd_lookup_suspend(Popupwnd *self);
void		popupwnd_lookup_resume(Popupwnd *self);
const gchar*	popupwnd_selection_copy(Popupwnd *self, gboolean force_copy);
gboolean	popupwnd_locked(Popupwnd *self);

GType		popupwnd_get_type (void);

void		popupwnd_search_selection(gpointer data);

G_END_DECLS

#endif /* __POPUPWND_H__ */

#ifndef __POPUP_H__
#define __POPUP_H__

#include "textview.h"

void            popupwnd_open(RESULT *res);
void            popupwnd_close();
void		popupwnd_find();

#if 0
struct _popupwnd
{
    gboolean    lock, remember_pos, drag, jap_only;
    gint        x, y, w, h, search_method, timeout, maxhits, press_x_root, press_y_root, press_window_x, press_window_y;
    GtkWidget   *wnd, *label, *scan, *scan_status_icon_menu, *menu, *lockbtn;
    TextView	*view;
    GSequence   *results;
    BOOK_INFO   *binfo;
} popupwnd;
#endif

#endif /* __POPUP_H__ */
