
#ifndef __MAINWND_H__
#define __MAINWND_H__

#include "builder.h"
#include "dicts.h"
#include "prefs.h"
#include "dump.h"
#include "history.h"
#include "hotkeys.h"
#include "textview.h"
#include "popupwnd.h"

G_BEGIN_DECLS

#define TYPE_MAINWND (mainwnd_get_type ())
#define MAINWND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAINWND, Mainwnd))
#define MAINWND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAINWND, MainwndClass))
#define IS_MAINWND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAINWND))
#define IS_MAINWND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAINWND))
#define MAINWND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAINWND, MainwndClass))

typedef struct _Mainwnd Mainwnd;
typedef struct _MainwndClass MainwndClass;

struct _Mainwnd {
    GtkWindow	parent_instance;
    Builder	*builder;
    Dicts	*dicts;
    Prefs	*prefs;
    History	*history;
    Hotkeys	*hotkeys;
    Dump	*dump;
    GSequence	*results;
    TextView	*text;
    Popupwnd	*popupwnd;
    gchar	*word;
    GtkCellRenderer *dictr;
    gint	indent;
};

struct _MainwndClass {
    GtkWindowClass parent_class;
};

void            mainwnd_show_about(GtkWidget *w, gpointer data);
void            mainwnd_prepare(Mainwnd *self);
void		mainwnd_dicts_update(Mainwnd *self);
GtkWindow*	mainwnd_get_wnd();
GSequence*	mainwnd_get_results();
gint		mainwnd_get_search_method();
gboolean        mainwnd_get_dicts(GtkTreeModel **store, GtkTreeIter *iter);
void		mainwnd_insert_text(gchar *txt, gboolean clear);
void            mainwnd_search(Mainwnd *self, const gchar *word, gint method);
void            mainwnd_open(Mainwnd *self, RESULT *res);
void            mainwnd_reset_font(Mainwnd *self);
void            mainwnd_reset_headwords(Mainwnd *self);
gint		mainwnd_get_font_size();
void		mainwnd_exit();

GType          mainwnd_get_type (void);

G_END_DECLS

void            mainwnd_search_(gpointer data);
void            mainwnd_clear_combo(gpointer data);
void            mainwnd_iconify_restore(gpointer data);
void		mainwnd_search_selection(gpointer data);
void		mainwnd_find(gpointer data);

#endif /* __MAINWND_H__ */
