
#ifndef __LOG_H__
#define __LOG_H__

typedef enum {
	LOG_ERROR     = 1 << 2,
	LOG_CRITICAL  = 1 << 3,
	LOG_WARNING   = 1 << 4,
	LOG_MESSAGE   = 1 << 5,
	LOG_INFO      = 1 << 6,
} LOG_LEVEL;

#define LOG(...) {log_func (__FILE__, __LINE__, __VA_ARGS__);} 

void log_func(const gchar *file, gint line, LOG_LEVEL level, const gchar *message, ...);

#endif /* __LOG_H__ */
